!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeset_unit_option
  use cubetools_parameters
  use cubetools_structure
  use cubetools_keyword_arg
  use cubetools_unit
  use cubeset_messaging
  !
  public :: unit_opt_t
  private
  !
  type :: unit_opt_t
     type(option_t),      pointer :: opt
     type(keyword_arg_t), pointer :: arg
     logical                      :: do
     character(len=unit_l)        :: name
   contains
     procedure, public :: register => cubeset_unit_option_register
     procedure, public :: parse    => cubeset_unit_option_parse   
  end type unit_opt_t
  !
contains
  !
  subroutine cubeset_unit_option_register(option,kind,namelist,error)
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(unit_opt_t),    intent(inout) :: option
    integer(kind=code_k), intent(in)    :: kind
    character(len=*),     intent(in)    :: namelist(:)
    logical,              intent(inout) :: error
    !
    type(keyword_arg_t)  :: keyarg
    character(len=*), parameter :: rname = 'UNIT>OPTION>REGISTER'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         unitkinds(kind),'name',&
         'Set current unit for '//trim(unitkinds(kind))//' units',&
         strg_id,&
         option%opt,error)
    if (error) return
    call keyarg%register(&
         'name',&
         'New current unit name',&
         strg_id,&
         code_arg_mandatory,&
         namelist,&
         .not.flexible,&
         option%arg,&
         error)
    if (error) return
  end subroutine cubeset_unit_option_register
  !
  subroutine cubeset_unit_option_parse(option,line,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(unit_opt_t), intent(inout) :: option
    character(len=*),  intent(in)    :: line
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname = 'UNIT>OPTION>PARSE'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call option%opt%present(line,option%do,error)
    if (error) return
    if (option%do) then
       call cubetools_getarg(line,option%opt,1,option%name,mandatory,error)
       if (error) return
    endif
  end subroutine cubeset_unit_option_parse
end module cubeset_unit_option
!
module cubeset_unit
  use cubetools_structure
  use cubetools_unit
  use cubeset_unit_option
  use cubeset_messaging
  !
  public :: units,cubeset_unit_command
  private
  !
  type :: unit_comm_t
     type(option_t), pointer :: comm
     type(unit_opt_t)        :: kind(nunitkinds) 
     type(option_t), pointer :: def
   contains
     procedure, public  :: register => cubeset_unit_register
     procedure, private :: parse    => cubeset_unit_parse
     procedure, private :: main     => cubeset_unit_main
  end type unit_comm_t
  type(unit_comm_t) :: units
  !
  type :: unit_input_t
     logical               :: dodef
  end type unit_input_t
  !
contains
  !
  subroutine cubeset_unit_command(line,error)
    !---------------------------------------------------------------------
    ! Support routine for command
    ! UNITS
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(unit_input_t) :: user
    character(len=*), parameter :: rname='UNIT>COMMAND'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call units%parse(line,user,error)
    if (error) return
    call units%main(user,error)
    if (error) return
  end subroutine cubeset_unit_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeset_unit_register(units,error)
    use cubetools_parameters
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(unit_comm_t), intent(inout) :: units
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Set user current units'
    character(len=*), parameter :: comm_help = &
         'Current units are the units used to display information to&
         & the user and the expected units for user input. If called&
         & without options, UNITS display the current units and its&
         & convertion factor to internal units'
    character(len=*), parameter :: rname='UNIT>REGISTER'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'UNITS','',&
         comm_abstract,&
         comm_help,&
         cubeset_unit_command,&
         units%comm,error)
    if (error) return
    !
    call units%kind(code_unit_uv)%register(code_unit_uv,unit_uv_name,error)
    if (error) return    
    call units%kind(code_unit_fov)%register(code_unit_fov,unit_fov_name,error)
    if (error) return
    call units%kind(code_unit_pang)%register(code_unit_pang,unit_pang_name,error)
    if (error) return
    call units%kind(code_unit_beam)%register(code_unit_beam,unit_beam_name,error)
    if (error) return
    call units%kind(code_unit_freq)%register(code_unit_freq,unit_freq_name,error)
    if (error) return
    call units%kind(code_unit_velo)%register(code_unit_velo,unit_velo_name,error)
    if (error) return
    call units%kind(code_unit_wave)%register(code_unit_wave,unit_wave_name,error)
    if (error) return
    call units%kind(code_unit_chan)%register(code_unit_chan,unit_chan_name,error)
    if (error) return
    call units%kind(code_unit_pixe)%register(code_unit_pixe,unit_pixe_name,error)
    if (error) return
    call units%kind(code_unit_dist)%register(code_unit_dist,unit_dist_name,error)
    if (error) return
    call units%kind(code_unit_unk)%register(code_unit_unk,unit_unk_name,error)
    if (error) return
    !
    call cubetools_register_option(&
         'DEFAULTS','',&
         'Restore current units to defaults',&
         strg_id,&
         units%def,error)
    if (error) return
  end subroutine cubeset_unit_register
  !
  subroutine cubeset_unit_parse(units,line,user,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(unit_comm_t), intent(inout) :: units
    character(len=*),   intent(in)    :: line
    type(unit_input_t), intent(out)   :: user
    logical,            intent(inout) :: error
    !
    integer(kind=4) :: ikind
    character(len=*), parameter :: rname='UNIT>PARSE'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call units%def%present(line,user%dodef,error)
    if (error) return
    !
    do ikind=1,nunitkinds
       call units%kind(ikind)%parse(line,error)
       if (error) return
    end do
  end subroutine cubeset_unit_parse
  !
  subroutine cubeset_unit_main(units,user,error)
    use cubetools_unit
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(unit_comm_t), intent(in)    :: units
    type(unit_input_t), intent(in)    :: user
    logical,            intent(inout) :: error
    !
    integer(kind=4) :: ikind
    character(len=*), parameter :: rname='UNIT>MAIN'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    if (user%dodef) then
       call cubetools_unit_defaults(error)
       if (error) return
    endif
    !
    do ikind=1,nunitkinds
       if (units%kind(ikind)%do) then
          call cubetools_unit_set(units%kind(ikind)%name,ikind,error)
          if (error) return
       end if
    end do
    !
    if (cubetools_nopt().eq.0) then
       call cubetools_unit_print(error)
       if (error) return
    endif
  end subroutine cubeset_unit_main
end module cubeset_unit
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
