!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_image_cplx
  use cubemain_messaging
  !
  public :: image_cplx_t
  private
  !
  type image_cplx_t
     integer(kind=4) :: code_pointer = code_pointer_null
     complex(kind=sign_k), pointer :: z(:,:) => null()
     integer(kind=pixe_k) :: nx = 0
     integer(kind=pixe_k) :: ny = 0
   contains
     procedure, public :: reallocate_and_init => cubemain_image_cplx_reallocate_and_init
     procedure, public :: reallocate          => cubemain_image_cplx_reallocate
     procedure, public :: reassociate         => cubemain_image_cplx_reassociate
     procedure, public :: init                => cubemain_image_cplx_init
     procedure, public :: get                 => cubemain_image_cplx_get
     procedure, public :: put                 => cubemain_image_cplx_put
     final :: cubemain_image_cplx_free
  end type image_cplx_t
  !
contains
  !
  subroutine cubemain_image_cplx_reallocate_and_init(image,name,cube,initval,error)
    use cube_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image_cplx_t), intent(inout) :: image
    character(len=*),    intent(in)    :: name
    type(cube_t),        intent(in)    :: cube
    real(kind=sign_k),   intent(in)    :: initval
    logical,             intent(inout) :: error
    !
    integer(kind=pixe_k) :: nx,ix
    integer(kind=pixe_k) :: ny,iy
    character(len=*), parameter :: rname='IMAGE>CPLX>REALLOCATE>AND>INIT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    ! Allocate
    nx = cube%head%arr%n%l
    ny = cube%head%arr%n%m
    call image%reallocate(name,nx,ny,error)
    if (error) return
    ! Initialize
    do iy=1,ny
       do ix=1,nx
          image%z(ix,iy) = initval
       enddo ! ix
    enddo ! iy
  end subroutine cubemain_image_cplx_reallocate_and_init
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_image_cplx_reallocate(image,kind,nx,ny,error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image_cplx_t),  intent(inout) :: image
    character(len=*),     intent(in)    :: kind
    integer(kind=pixe_k), intent(in)    :: nx,ny
    logical,              intent(inout) :: error
    !
    logical :: alloc
    integer(kind=4) :: ier
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='IMAGE>CPLX>REALLOCATE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    ! Sanity check
    if (nx.le.0 .or. ny.le.0) then
       call cubemain_message(seve%e,rname,'Negative or zero number of pixels')
       error = .true.
      return
    endif
    !
    alloc = .true.
    if (image%code_pointer.eq.code_pointer_allocated) then
       ! The request is to get an allocated pointer
       if (image%nx.eq.nx .and.  &
           image%ny.eq.ny) then
          write(mess,'(a,a,i0,a,i0)')  &
               kind,' z already allocated at the right size: ',nx, ' x ',ny
          call cubemain_message(mainseve%alloc,rname,mess)
          alloc = .false.
       else
          write(mess,'(a,a,a)') 'Pointer ',kind,  &
               ' z already allocated but with a different size => Freeing it first'
          call cubemain_message(mainseve%alloc,rname,mess)
          call cubemain_image_cplx_free(image)
       endif
    else
       ! image%z is either null or associated, so I will need to allocate it anyway
    endif
    if (alloc) then
       allocate(image%z(nx,ny),stat=ier)
       if (failed_allocate(rname,trim(kind)//' image z',ier,error)) return
    endif
    ! Allocation success => image%code_pointer may be updated
    image%nx = nx
    image%ny = ny
    image%code_pointer = code_pointer_allocated
  end subroutine cubemain_image_cplx_reallocate
  !
  subroutine cubemain_image_cplx_reassociate(image,kind,nx,ny,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image_cplx_t),  intent(inout) :: image
    character(len=*),     intent(in)    :: kind
    integer(kind=pixe_k), intent(in)    :: nx,ny
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE>CPLX>REASSOCIATE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    ! Sanity check
    if (nx.le.0 .or. ny.le.0) then
       call cubemain_message(seve%e,rname,'Negative or zero number of pixels')
       error = .true.
      return
    endif
    !
    ! The request is to get a null pointer without memory leak => Free when needed.
    call cubemain_image_cplx_free(image)
    ! Association success => image%code_pointer may be updated
    image%code_pointer = code_pointer_associated
  end subroutine cubemain_image_cplx_reassociate
  !
  subroutine cubemain_image_cplx_init(image,cube,error)
    use cube_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image_cplx_t), intent(out)   :: image
    type(cube_t),        intent(in)    :: cube
    logical,             intent(inout) :: error
    !
    ! integer(kind=4) :: xaxis,yaxis
    ! integer(kind=pixe_k) :: nx,ny
    character(len=*), parameter :: rname='IMAGE>CPLX>INIT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    ! Associate
    call image%reassociate('image',cube%tuple%current%desc%nx,cube%tuple%current%desc%ny,error)
    if (error) return
    ! Fill
    ! 
  !!$  if (code.eq.code_pointer_allocated) then
  !!$     image%z(ix,iy) = complex(gr4nan,gr4nan)
  !!$  else
  !!$     ! Does nothing
  !!$  endif
  end subroutine cubemain_image_cplx_init
  !
  subroutine cubemain_image_cplx_free(image)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(image_cplx_t), intent(inout) :: image
    !
    character(len=*), parameter :: rname='IMAGE>CPLX>FREE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (image%code_pointer.eq.code_pointer_allocated) then
       if (associated(image%z)) deallocate(image%z)
    else
       image%z => null()
    endif
    image%nx = 0
    image%ny = 0
    image%code_pointer = code_pointer_null
  end subroutine cubemain_image_cplx_free
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_image_cplx_get(image,cube,iimage,error)
    use cube_types
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Get the iimage-th image from the cube
    ! When image%z is an allocated pointer, we make a copy.
    ! In all other cases (associated or null), we make it point to the data.
    !---------------------------------------------------------------------
    class(image_cplx_t),  intent(inout) :: image
    type(cube_t),         intent(inout) :: cube
    integer(kind=entr_k), intent(in)    :: iimage
    logical,              intent(inout) :: error
    ! 
    type(cube_chan_t) :: chan
    integer(kind=chan_k) :: ichan
    character(len=*), parameter :: rname='GET>IMAGE>CPLX'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (.not.cube%iscplx()) then
       call cubemain_message(seve%e,rname,  &
            'Invalid attempt to get a C*4 image from a R*4 cube')
       error = .true.
       return
    endif
    !
    ichan = iimage
    call cubetuple_get_chan(cube%user,cube%prog,cube,ichan,chan,error)
    if (error) return
    !
    if (image%code_pointer.eq.code_pointer_allocated) then
       image%z(:,:) = chan%c4(:,:)
    else
       image%z => chan%c4
       image%code_pointer = code_pointer_associated
    endif
    image%nx = chan%nx
    image%ny = chan%ny
    !
    call cubeio_free_chan(chan,error)
    if (error)  return
  end subroutine cubemain_image_cplx_get
  !
  subroutine cubemain_image_cplx_put(image,cube,iimage,error)
    use cube_types
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Put the iimage-th image to the cube
    ! Only use pointers => Nothing to free
    !---------------------------------------------------------------------
    class(image_cplx_t),  intent(in)    :: image
    type(cube_t),         intent(inout) :: cube
    integer(kind=entr_k), intent(in)    :: iimage
    logical,              intent(inout) :: error
    !
    type(cube_chan_t) :: chan
    integer(kind=chan_k) :: ichan
    character(len=*), parameter :: rname='IMAGE>CPLX>PUT>ARRAY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (.not.cube%iscplx()) then
       call cubemain_message(seve%e,rname,  &
            'Invalid attempt to put a C*4 image to a R*4 cube')
       error = .true.
       return
    endif
    !
    chan%allocated = code_pointer_associated
    chan%nx = image%nx
    chan%ny = image%ny
    chan%c4 => image%z
    chan%iscplx = .true.
    !
    ichan = iimage
    call cubetuple_put_chan(cube%user,cube%prog,cube,ichan,chan,error)
    if (error) return
  end subroutine cubemain_image_cplx_put
end module cubemain_image_cplx
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
