!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeio_header_hcdf
  use cubetools_header_types
  use cubetools_header_interface
  use cubecdf_header
  use cubeio_interface
  use cubeio_messaging
  !
  public :: cubeio_header_get_and_derive_fromhcdf,cubeio_header_put_tohcdf
  public :: cubeio_hcdf_export
  private
  !
contains
  !
  subroutine cubeio_header_get_and_derive_fromhcdf(hcdf,head,error)
    !-------------------------------------------------------------------
    ! From type(cdf_header_t) to type(cube_header_t)
    !-------------------------------------------------------------------
    type(cdf_header_t),  intent(in)    :: hcdf
    type(cube_header_t), intent(inout) :: head
    logical,             intent(inout) :: error
    !
    type(cube_header_interface_t) :: interface
    character(len=*), parameter :: rname='HEADER>GET>AND>DERIVE'
    !
    call cubeio_message(ioseve%trace,rname,'Welcome')
    !
    call cubeio_hcdf_export(hcdf,interface,error)
    if (error) return
    call cubetools_header_import_and_derive(interface,head,error)
    if (error) return
  end subroutine cubeio_header_get_and_derive_fromhcdf
  !
  subroutine cubeio_header_put_tohcdf(head,order,hcdf,verbose,error)
    use image_def
    !-------------------------------------------------------------------
    ! From type(cube_header_t) to type(cdf_header_t) with desired order
    !-------------------------------------------------------------------
    type(cube_header_t),  intent(in)    :: head
    integer(kind=code_k), intent(in)    :: order  ! code_order_*
    type(cdf_header_t),   intent(inout) :: hcdf
    logical,              intent(in)    :: verbose
    logical,              intent(inout) :: error
    !
    type(cube_header_interface_t) :: interface
    character(len=*), parameter :: rname='HEADER>PUT'
    !
    call cubeio_message(ioseve%trace,rname,'Welcome')
    !
    call cubetools_header_export(head,interface,error)
    if (error) return
    call cubeio_interface_transpose(interface,order,error)
    if (error) return
    call cubeio_hcdf_import(interface,hcdf,error)
    if (error) return
  end subroutine cubeio_header_put_tohcdf
  !
  !---------------------------------------------------------------------
  !
  subroutine cubeio_hcdf_export(hcdf,out,error)
    use cubetools_messaging
    !-------------------------------------------------------------------
    ! From type(cdf_header_t) to type(cube_header_interface_t)
    !-------------------------------------------------------------------
    type(cdf_header_t),            intent(in)    :: hcdf
    type(cube_header_interface_t), intent(inout) :: out
    logical,                       intent(inout) :: error
    !
    character(len=*), parameter :: rname='HCDF>EXPORT'
    !
    call cubeio_message(seve%e,rname,'Not implemented')
    error = .true.
    return
  end subroutine cubeio_hcdf_export
  !
  subroutine cubeio_hcdf_import(in,hcdf,error)
    use cubetools_messaging
    !-------------------------------------------------------------------
    ! From type(cube_header_interface_t) to type(gildas)
    !-------------------------------------------------------------------
    type(cube_header_interface_t), intent(in)    :: in
    type(cdf_header_t),            intent(inout) :: hcdf
    logical,                       intent(inout) :: error
    !
    integer(kind=ndim_k) :: ndim
    character(len=*), parameter :: rname='HGDF>IMPORT'
    !
    call cubeio_message(ioseve%trace,rname,'Welcome')
    !
    ! Data format
    hcdf%type = in%array_type
    ! Dimension section
    if (in%axset_ndim.le.maxdim) then
       ndim = in%axset_ndim
    else
       call hcdf%message(seve%d,rname,'Larger number of dimensions than room to store it! => Truncating')
       ndim = maxdim
    endif
    hcdf%ndim = ndim
    hcdf%dim = 0
    hcdf%dim(1:ndim) = in%axset_dim(1:ndim)
  end subroutine cubeio_hcdf_import
  !
end module cubeio_header_hcdf
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
