!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_sum
  use cubetools_structure
  use cubetools_axis_types
  use cubetools_keyword_arg
  use cubeadm_index
  use cube_types
  use cubemain_messaging
  use cubemain_auxiliary
  use cubemain_merging
  use cubemain_identifier
  !
  type :: sum_comm_t
     type(option_t), pointer  :: comm
     type(merging_comm_t)     :: merge
   contains
     procedure, public  :: register     => cubemain_sum_register
     procedure, public  :: parse        => cubemain_sum_parse
     procedure, public  :: main         => cubemain_sum_main
  end type sum_comm_t
  type(sum_comm_t) :: sum
  !
contains
  !
  subroutine cubemain_sum_command(line,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(merging_user_t) :: user
    character(len=*), parameter :: rname = 'SUM>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call sum%parse(line,user,error)
    if (error) return
    !
    call sum%main(user,error)
    if (error) return
  end subroutine cubemain_sum_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_sum_register(sum,error)
    use cubetools_unit
    use cubedag_allflags
    use cubemain_identifier
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(sum_comm_t), intent(inout) :: sum
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname = 'SUM>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'SUM','',&
         'Sum cubes from the current index',&
         'Sum the cubes in the current index. The summation can be&
         & spectrally aligned by usign option /ALIGN. Several aspects&
         & of the output cube can be controlled: its axes &
         & (/LAXIS, /MAXIS, /FAXIS and /VAXIS), its projection &
         &(/PTYPE, /PCENTER and /PANGLE) as well as its &
         & reference frequency and line. A reference cube can be used to  &
         &  define the spectral and spatial characteristics of&
         & the summed cube (/LIKE). If no options are given&
         & the axes will be chosen in a way to cover all the&
         & data in all cubes in the index. By default the&
         & family name of the output cube will be the same&
         & of the first cube in the current index, this can&
         & be changed with the usage of option /FAMILY.',&
         & cubemain_sum_command, sum%comm,error)
    if (error) return
    !
    call sum%merge%register('summed',error)
    if (error) return
  end subroutine cubemain_sum_register
  !
  subroutine cubemain_sum_parse(sum,line,user,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(sum_comm_t),     intent(in)    :: sum
    character(len=*),      intent(in)    :: line
    class(merging_user_t), intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname = 'SUM>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call sum%merge%parse(line,user,error)
    if (error) return
    !
  end subroutine cubemain_sum_parse
  !
  subroutine cubemain_sum_main(sum,user,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(sum_comm_t),     intent(in)    :: sum
    class(merging_user_t), intent(in)    :: user
    logical,               intent(inout) :: error
    !
    type(merging_prog_t) :: prog
    logical, parameter :: issum = .true.
    character(len=*), parameter :: rname = 'SUM>MAIN'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call user%toprog(sum%merge,issum,prog,error)
    if (error) return
    call prog%main(error)
    if (error) return
  end subroutine cubemain_sum_main
end module cubemain_sum
