subroutine clean_beam (line,error)
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  use gbl_message
  use imager_interfaces, only : map_message, get_clean
  !
  character(len=*), intent(in) :: line
  logical, intent(inout) :: error
  real, parameter :: sec=acos(-1.0)/180./3600.
  !
  character(len=*), parameter :: rname = 'FIT'
  integer, parameter :: o_thresh=1
  integer :: jplane, nfield
  real, save, target :: fit_major, fit_minor, fit_angle
  logical, save :: first=.true.
  character(len=message_length) :: chain
  !
  if (huv%loca%size.eq.0) then
    call map_message(seve%e,rname,'No UV data')
    error = .true.
    return
  endif
  !
  if (hbeam%loca%size.eq.0) then
    call map_message(seve%e,rname,'No Dirty Beam')
    error = .true.
    return
  endif
  !
  jplane = max(1,method%iplane)
  call sic_i4 (line,0,1,jplane,.false.,error)
  if (error) return
  if (jplane.lt.1) then
    call map_message(seve%e,rname,'Invalid field')
    error = .true.
    return
  endif
  !
  nfield = 1
  if (hbeam%char%code(3).eq.'FIELD') then
    nfield = hbeam%gil%dim(3)
  endif
  if (hbeam%gil%ndim.gt.3) then
    if (hbeam%char%code(4).eq.'FIELD') then
      nfield = hbeam%gil%dim(4)
    endif
  endif
  if (jplane.gt.nfield) then
    call map_message(seve%e,rname,'No such field')
    error = .true.
    return
  endif
  method%major = 0.0
  method%minor = 0.0
  method%angle = 0.0
  method%thresh = user_method%thresh
  call sic_r4(line,o_thresh,1,method%thresh,.false.,error)
  if (error) return
  !
  if (nfield.gt.1) then
    write(chain,'(A,I4,A,I4)') 'Fitting beam # ',jplane,' /',nfield
    call map_message(seve%i,rname,chain)
  endif
  !
  call get_clean (method, hbeam, dbeam(:,:,1,jplane),error)
  !
  fit_major = method%major/sec
  fit_minor = method%minor/sec
  fit_angle = method%angle ! In Degree ?
  !
  if (first) then
	call sic_def_real('BEAM_MAJOR',fit_major,0,0,.true.,error)
	call sic_def_real('BEAM_MINOR',fit_minor,0,0,.true.,error)
	call sic_def_real('BEAM_ANGLE',fit_angle,0,0,.true.,error)
	first = .false.
  endif
end subroutine clean_beam
!
subroutine new_dirty_beam
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  !
  ! needed when a new dirty map is computed by command uv_map:
  logical :: error
  error = .false.
  !
  if (allocated(dclean)) deallocate(dclean)
  call sic_delvariable ('CLEAN',.false.,error)
  hclean%loca%size = 0
  !
  if (allocated(dresid)) deallocate(dresid)
  call sic_delvariable ('RESIDUAL',.false.,error)
  hresid%loca%size = 0
  !
  if (allocated(dcct)) deallocate(dcct)
  call sic_delvariable ('CCT',.false.,error)
  hcct%loca%size = 0
  !
  if (allocated(dsky)) deallocate(dsky)
  call sic_delvariable ('SKY',.false.,error)
  hsky%loca%size = 0
end subroutine new_dirty_beam
