subroutine com_support(line,error)
  use gildas_def
  use gkernel_interfaces
  use imager_interfaces, only : map_message, mask_clean
  use clean_arrays
  use clean_support
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER  
  !   Support routine for command
  !	  SUPPORT [/PLOT] [/CURSOR] [/RESET] [/MASK] [/VARIABLE]
  !           [/THRESHOLD  Raw Smooth [SmoothingLength]
  !---------------------------------------------------------------------
  character(len=*), intent(in)  :: line  ! Commandand line
  logical,          intent(out) :: error ! Logical error flag
  !
  ! Local variables
  character(len=*), parameter :: rname='SUPPORT'
  integer(kind=4), parameter :: o_name=0
  integer(kind=4), parameter :: o_curs=1
  integer(kind=4), parameter :: o_mask=2
  integer(kind=4), parameter :: o_plot=3
  integer(kind=4), parameter :: o_rese=4
  integer(kind=4), parameter :: o_thre=5
  integer(kind=4), parameter :: o_vari=6
  !
  logical :: fromfile, do_plot
  character(len=filename_length) :: file
  integer(kind=4) :: ier
  real(kind=4), allocatable, target :: imask(:,:)
  real :: raw,smo,length,noise,margin
  !
  do_plot = sic_present(o_plot,0)
  !
  if (sic_present(o_curs,0)) then  ! /CURSOR
    call map_message(seve%i,rname,'Use cursor to define polygon')
    user_method%do_mask = .true.
    file = ' '
    fromfile = .false.
    call sic_delvariable('MASK',.false.,error)
    hmask%loca%size = 0
    !
  else if (sic_present(o_rese,0)) then  ! /RESET
    if (allocated(dmask)) then
      deallocate(dmask,stat=ier)
    endif
    call greg_poly_reset(supportpol,supportvar,error)
    if (error)  return
    user_method%do_mask = .true.  ! The mask HAS changed...
    call sic_delvariable('MASK',.false.,error)
    support_type = support_none
    hmask%loca%size = 0
    ! Delete the "supportvar" structure
    call sic_delvariable(supportvar,.false.,error)
    return
    !
  else if (sic_present(o_mask,0)) then  ! /MASK
    if (allocated(dmask)) then
      call sic_delvariable('MASK',.false.,error)
      call sic_def_real ('MASK',dmask,hmask%gil%ndim,   &
           &        hmask%gil%dim,.true.,error)
      user_method%do_mask = .true.
      support_type = 1 ! First plane will be used by default
      !
      ! Show it if asked for by /PLOT option
      if (do_plot) then
        allocate (imask(hmask%gil%dim(1),hmask%gil%dim(2)),stat=ier)
        imask = 0.0
        where (dmask(:,:,1).ne.0) imask = 1.0
        call sic_def_real ('BITMAP_MASK',imask,hmask%gil%ndim,   &
         &        hmask%gil%dim,.true.,error)
        call gr_exec2('PLOT BITMAP_MASK /SCALING LIN -0.5 1.5')
        error = gr_error()
        call sic_delvariable('BITMAP_MASK',.false.,error)
        deallocate (imask,stat=ier)
      endif
    else
      call map_message(seve%e,rname,'No mask defined')
      error  = .true.
    endif
    return
  else if (sic_present(o_thre,0)) then
    !
    ! SUPPORT /THRESHOLD Raw Smooth [Length]
    !
    !  Raw      Thresholding (in Sigma) of the Clean image
    !  Smooth   Thresholding (in Sigma) after smoothing
    !  Length   Smoothing length: default is Clean beam major axis
    !
    if (hclean%loca%size.eq.0) then
      call map_message(seve%e,rname,'No CLEAN image')
      error = .true.
      return
    endif
    raw = 5.0
    smo = 2.0
    length = hclean%gil%majo
    !
    call sic_r4(line,o_thre,1,raw,.false.,error)
    if (error) return
    call sic_r4(line,o_thre,2,smo,.false.,error)
    if (error) return
    call sic_r4(line,o_thre,3,length,.false.,error)
    if (error) return
    if (length.eq.0)  length = hclean%gil%majo
    margin = 0.18
    call sic_r4(line,o_thre,4,margin,.false.,error)
    if (margin.lt.0 .or. margin.gt.0.5) then
      call map_message(seve%e,rname,'Margin must be >0 and <0.5')
      error = .true.
      return
    endif
    !
    noise = max(hdirty%gil%noise,hclean%gil%noise,hclean%gil%rms)
    !
    call sic_delvariable('MASK',.false.,error)
    if (allocated(dmask)) deallocate(dmask)    
    call gdf_copy_header(hclean,hmask,error)
    allocate(dmask(hmask%gil%dim(1),hmask%gil%dim(2),hmask%gil%dim(3)),   &
     &        stat=ier)
    !
    call mask_clean(hmask,dmask,dclean,raw*noise,smo*noise,length,margin,error)
    if (error) return
    !
    call sic_def_real ('MASK',dmask,hmask%gil%ndim,   &
         &        hmask%gil%dim,.true.,error)
    user_method%do_mask = .true.
    support_type = 1 ! First plane will be used by default 
    return   
  else if (do_plot.and.sic_narg(o_name).eq.0) then  
    ! SUPPORT /PLOT 
    !
    ! Just plot
    if (support_type.eq.support_poly) then
      call greg_poly_plot(supportpol,error)
    else if (support_type.ne.support_none) then
      allocate (imask(hmask%gil%dim(1),hmask%gil%dim(2)),stat=ier)
      imask = 0.0
      where (dmask(:,:,1).ne.0) imask = 1.0
      call sic_def_real ('BITMAP_MASK',imask,hmask%gil%ndim,   &
       &        hmask%gil%dim,.true.,error)
      call gr_exec2('PLOT BITMAP_MASK /SCALING LIN -0.5 1.5')
      error = gr_error()
      call sic_delvariable('BITMAP_MASK',.false.,error)
      deallocate (imask,stat=ier)
      support_type = 1
    else
      call map_message(seve%w,rname,'No support defined')
      error  = .true.      
    endif
    return
  else
    !
    ! This also re-instate the Polygon as the Clean support
    user_method%do_mask = .true.
    if (sic_narg(o_name).ge.1) then
      call greg_poly_parsename(line,o_name,o_vari,fromfile,file,error)
      if (error) return
    else
      fromfile = .false.
      file = ' '  ! Not from file, not from var, i.e. from cursor
    endif
  endif
  !
  ! Define the polygon from file or cursor:
  call sic_delvariable(supportvar,.false.,error)
  call sic_defstructure(supportvar,.true.,error)
  !
  hmask%loca%size = 0
  call greg_poly_define(rname,file,fromfile,supportpol,supportvar,error)
  if (error)  return
  support_type = support_poly
  !
  ! /PLOT if needed
  if (do_plot) call greg_poly_plot(supportpol,error)
  !
end subroutine com_support
!
subroutine mask_clean (head,mask,data,raw,smo,length,margin,error) 
  use clean_def
  use image_def
  use gbl_message
  use gkernel_interfaces
  use imager_interfaces, only : mulgau, map_message
  !---------------------------------------------------------------------
  ! @ private-mandatory
  !
  ! IMAGER
  !   Support routine for SUPPORT /THRESHOLD command
  !
  !   Builds a Mask from a Threshold and Smoothing 
  !---------------------------------------------------------------------
  type (gildas), intent(inout) :: head
  real, intent(out), target :: mask(head%gil%dim(1),head%gil%dim(2),head%gil%dim(3))
  real, intent(in) :: data (head%gil%dim(1),head%gil%dim(2),head%gil%dim(3))
  real, intent(in) :: raw
  real, intent(in) :: smo
  real, intent(in) :: length
  real, intent(in) :: margin
  logical, intent(out) :: error
  !
  real(8), parameter :: pi=3.141592653589793d0
  character(len=*), parameter :: rname='SUPPORT'
  !
  integer nx,ny,nc,ix,iy,ic,jx,jy,ndim,dim(2),ier
  real xinc, yinc,fact
  real, allocatable :: wfft(:)
  real, pointer :: tmp(:,:)
  complex, allocatable :: ft(:,:)
  character(len=80) :: chain
  !
  nx = head%gil%dim(1)
  ny = head%gil%dim(2)
  nc = head%gil%dim(3)
  allocate (wfft(2*max(nx,ny)),ft(nx,ny),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,rname,'Memory allocation error in MASK_CLEAN')
    error = .true.
    return
  endif
  xinc = head%gil%convert(3,1)
  yinc = head%gil%convert(3,2)
  !
  dim(1) = nx
  dim(2) = ny
  ndim = 2
  jy = margin*ny
  jx = margin*nx
  !
  write(chain,'(A,1PG10.2,1PG10.2,A,0PF8.2,A,F6.2)') 'Threshold',raw,smo, &
    & ',  Smoothing ',length*180.*3600./pi,'", guard band ',margin
  call map_message(seve%i,rname,chain)
  !
  do ic=1,nc
    tmp => mask(:,:,ic)
    !
    ! Guard band of margin-th of the image size on each edge to
    ! avoid aliased sidelobes
    tmp = 0.0
    if (head%gil%eval.ge.0.0) then
      do iy=jy+1,ny-jy
        do ix=jx+1,nx-jx
          if (abs(data(ix,iy,ic)-head%gil%bval).gt.head%gil%eval) then
            if (data(ix,iy,ic).ge.raw) tmp(ix,iy) = data(ix,iy,ic)
          endif
        enddo
      enddo    
    else
      do iy=jy+1,ny-jy
        do ix=jx+1,nx-jx
          if (data(ix,iy,ic).ge.raw) tmp(ix,iy) = data(ix,iy,ic)
        enddo
      enddo
    endif
    ft(:,:) = cmplx(tmp,0.0)
    !
    call fourt(ft,dim,ndim,-1,0,wfft)
    !
    ! Correct for Beam Area for flux density normalisation
    fact = length**2*pi/(4.0*log(2.0))/abs(xinc*yinc)/(nx*ny)
    call mulgau(ft,nx,ny,   &
         &    length, length, 0.0,   &
         &    fact,xinc,yinc)
    call fourt(ft,dim,ndim,1,1,wfft)
    !
    ! Extract Real part
    tmp(:,:) = real(ft)
    where (tmp.lt.smo) tmp = 0.0
  enddo
  deallocate (wfft,ft)
end subroutine mask_clean
