subroutine sexfor(xa,ya)
  use phys_const
  use gbl_message
  use greg_dependencies_interfaces
  use greg_interfaces, except_this=>sexfor
  use greg_wcs
  !---------------------------------------------------------------------
  ! @ private
  !  Makes a nice format for projection information
  !---------------------------------------------------------------------
  real(kind=8), intent(in) :: xa  ! X position
  real(kind=8), intent(in) :: ya  ! Y position
  ! Local
  character(len=*), parameter :: rname='SEXFOR'
  real(kind=8) :: xabs,yabs,xalt,yalt
  character(len=16) :: chra,chde
  character(len=message_length) :: chain
  logical :: error
  !
  error = .false.
  chain = ' '
  call rel_to_abs (gproj,xa,ya,xabs,yabs,1)
  !
  select case (i_system)
  case (type_un)
    write (chain,100) xabs*180.d0/pi,yabs*180.d0/pi
    call greg_message(seve%r,rname,chain)
    !
  case (type_eq)
    ! Display native equatorial coordinates + alternate galactic
    chra = ' '
    chde = ' '
    call sexag(chra,xabs,12)
    call sexag(chde,yabs,360)
    if (i_equinox.eq.equinox_null) then
      write(chain,104)  chra,chde
    else
      write(chain,102)  chra,chde,i_equinox
    endif
    call greg_message(seve%r,rname,chain)
    !
    if (i_equinox.eq.equinox_null) then
      write(chain,103)
    else
      call equ_gal(xabs,yabs,i_equinox,xalt,yalt,error)
      if (error)  return
      write(chain,101)  xalt*180.d0/pi,yalt*180.d0/pi
    endif
    call greg_message(seve%r,rname,chain)
    !
  case (type_ga)
    ! Display native galactic coordinates + alternate equatorial (use
    ! an arbitrary equinox)
    call gal_equ(xabs,yabs,xalt,yalt,i_equinox_def,error)
    if (error)  return
    chra = ' '
    chde = ' '
    call sexag(chra,xalt,12)
    call sexag(chde,yalt,360)
    write(chain,101)  xabs*180.d0/pi,yabs*180.d0/pi
    call greg_message(seve%r,rname,chain)
    write(chain,102)  chra,chde,i_equinox_def
    call greg_message(seve%r,rname,chain)
    !
  case default
    call greg_message(seve%w,rname,'System not supported')
    !
  end select
  !
100 format('Absolute position ',f12.6,1x,f12.6,' degrees')
101 format('    Lii ',f12.6,t35,'Bii ',f12.6)
102 format('    Ra  ',a    ,t35,'Dec ',a,' (Eq. ',f0.1,')')
103 format('    Lii  N/A'  ,t35,'Bii   N/A')
104 format('    Ra  ',a    ,t35,'Dec ',a,' (Eq. unknown)')
end subroutine sexfor
