!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_image_types
  use cubetools_array_types
  use cube_types
  use cubeadm_messaging
  use cubeadm_taskloop
  use cubeadm_taskloop_iteration
  !
  public :: image_t
  private
  !
  type, extends(real_2d_t) :: image_t
     type(cube_t),             private, pointer :: cube => null() ! Associated cube
     type(cubeadm_iterator_t), private, pointer :: task => null() ! Associated task iteration
     type(image_iteration_t),  private          :: iter           ! Current iteration
   contains
     generic,   public  :: allocate   => allocate_iter,allocate_noiter
     generic,   public  :: associate  => associate_iter,associate_noiter
     procedure, public  :: get        => image_get
     procedure, public  :: put        => image_put
     procedure, public  :: put_in     => image_put_in
     procedure, public  :: blank_like => image_blank_like
     procedure, private :: tasknum    => image_task_num
     !
     procedure, private :: allocate_iter    => image_allocate_iter
     procedure, private :: allocate_noiter  => image_allocate_noiter
     procedure, private :: associate_iter   => image_associate_iter
     procedure, private :: associate_noiter => image_associate_noiter
     procedure, private :: iteration_subset => image_iteration_subset
     procedure, private :: iteration_plane  => image_iteration_plane
  end type image_t
  !
contains
  !
  subroutine image_allocate_iter(image,name,cube,iterator,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),                   intent(inout) :: image
    character(len=*),                 intent(in)    :: name
    type(cube_t),             target, intent(in)    :: cube
    type(cubeadm_iterator_t), target, intent(in)    :: iterator
    logical,                          intent(inout) :: error
    !
    image%task => iterator
    call image_allocate_noiter(image,name,cube,error)
    if (error)  return
  end subroutine image_allocate_iter
  !
  subroutine image_allocate_noiter(image,name,cube,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),       intent(inout) :: image
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE>ALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a R*4 image from a C*4 cube')
       error = .true.
       return
    endif
    !
    image%cube => cube
    call image%iteration_subset(error)
    if (error)  return
    call image%reallocate(name,image%iter%nx,image%iter%ny,error)
    if (error) return
  end subroutine image_allocate_noiter
  !
  subroutine image_associate_iter(image,name,cube,iterator,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),                   intent(inout) :: image
    character(len=*),                 intent(in)    :: name
    type(cube_t),             target, intent(in)    :: cube
    type(cubeadm_iterator_t), target, intent(in)    :: iterator
    logical,                          intent(inout) :: error
    !
    image%task => iterator
    call image_associate_noiter(image,name,cube,error)
    if (error)  return
  end subroutine image_associate_iter
  !
  subroutine image_associate_noiter(image,name,cube,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),       intent(inout) :: image
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE>ASSOCIATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a R*4 image from a C*4 cube')
       error = .true.
       return
    endif
    !
    image%cube => cube
    call image%iteration_subset(error)
    if (error)  return
    call image%prepare_association(name,image%iter%nx,image%iter%ny,error)
    if (error) return
  end subroutine image_associate_noiter
  !
  !------------------------------------------------------------------------
  !
  subroutine image_get(image,oent,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Get the ient image from the cube
    ! When image%val is an allocated pointer, we make a copy.
    ! In all other cases (associated or null), we make it point to the data.
    !---------------------------------------------------------------------
    class(image_t),       intent(inout) :: image  !
    integer(kind=entr_k), intent(in)    :: oent   ! Output entry number
    logical,              intent(inout) :: error  !
    ! 
    type(cube_chan_t) :: entry
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='GET>IMAGE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call image%iteration_plane(oent,error)
    if (error)  return
    !
    call cubetuple_get_chan(image%cube%user,image%cube%prog,image%cube,  &
                            image%iter%inz,entry,error)
    if (error) return
    !
    ! Sanity check
    if (image%iter%inxf.lt.1 .or. image%iter%inxl.gt.entry%nx  .or.  &
        image%iter%inyf.lt.1 .or. image%iter%inyl.gt.entry%ny) then
      write(mess,'(9(A,I0))')  &
        'Region overlaps image range. Region: [',  &
        image%iter%inxf,':',image%iter%inxl,',',   &
        image%iter%inyf,':',image%iter%inyl,'], image: [',  &
        1,':',entry%nx,',',  &
        1,':',entry%ny,']'
      call cubeadm_message(seve%e,rname,mess)
      error = .true.
      return
    endif
    !
    if (image%pointeris.eq.code_pointer_allocated) then
       image%val(:,:) = entry%r4(image%iter%inxf:image%iter%inxl,  &
                                 image%iter%inyf:image%iter%inyl)
    else
       image%val => entry%r4(image%iter%inxf:image%iter%inxl,  &
                             image%iter%inyf:image%iter%inyl)
       image%pointeris = code_pointer_associated
    endif
    ! image%nx/ny not redefined as we might point to a subset region,
    ! image%xf/xl/yf/yl should be consistent.
    ! image%nx = entry%nx
    ! image%ny = entry%ny
    !
    call cubeio_free_chan(entry,error)
    if (error) return
  end subroutine image_get
  !
  subroutine image_put(image,oent,error)
    !---------------------------------------------------------------------
    ! Put the ient image to the cube
    ! Only use pointers => Nothing to free
    !---------------------------------------------------------------------
    class(image_t),       intent(inout) :: image  !
    integer(kind=entr_k), intent(in)    :: oent   ! Output entry number
    logical,              intent(inout) :: error  !
    !
    call image_put_in(image,image%cube,oent,error)
    if (error)  return
  end subroutine image_put
  !
  subroutine image_put_in(image,cube,oent,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Put the ient image to the cube.
    ! Only use pointers => Nothing to free.
    !
    ! This flavor, which explicitely states the output cube, should be used
    ! when the input image needs to be written in another cube without
    ! copy. See, eg, the SPLIT command. This should an exotic use compare to
    ! image_put.
    ! ---------------------------------------------------------------------
    class(image_t),       intent(inout) :: image  !
    type(cube_t),         intent(inout) :: cube   !
    integer(kind=entr_k), intent(in)    :: oent   ! Output entry number
    logical,              intent(inout) :: error  !
    !
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='IMAGE>PUT>IN'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    entry%allocated = code_pointer_associated
    entry%nx = image%iter%nx
    entry%ny = image%iter%ny
    entry%r4 => image%val
    entry%iscplx = .false.
    !
    call image%iteration_plane(oent,error)
    if (error)  return
    !
    call cubetuple_put_chan(cube%user,       &
                            cube%prog,       &
                            cube,            &
                            image%tasknum(), &
                            image%iter%ouz,  &
                            entry,           &
                            error)
    if (error) return
  end subroutine image_put_in
  !
  !-----------------------------------------------------------------------
  !
  subroutine image_blank_like(image,reference,error)
    use cubetools_nan
    !---------------------------------------------------------------------
    ! *** JP: Is it a method of the image_t type or of the real_2d_t one?
    !---------------------------------------------------------------------
    class(image_t), intent(inout) :: image
    type(image_t),  intent(in)    :: reference
    logical,        intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='IMAGE>BLANK>LIKE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    do iy=1,image%ny
       do ix=1,image%nx
          if (ieee_is_nan(reference%val(ix,iy))) image%val(ix,iy) = gr4nan
       enddo ! ix
    enddo ! iy
  end subroutine image_blank_like
  !
  function image_task_num(image)
    !-------------------------------------------------------------------
    ! Return the task number this image_t is running with
    !-------------------------------------------------------------------
    integer(kind=entr_k) :: image_task_num
    class(image_t), intent(in) :: image
    !
    if (associated(image%task)) then
      image_task_num = image%task%num
    else
      ! Assume single thread
      image_task_num = 1
    endif
  end function image_task_num
  !
  subroutine image_iteration_subset(image,error)
    !-------------------------------------------------------------------
    ! Compute the X-Y ranges of the image iteration.
    !-------------------------------------------------------------------
    class(image_t), intent(inout) :: image
    logical,        intent(inout) :: error
    !
    ! --- Leading dimensions ---
    image%iter%inxf = 1
    image%iter%inxl = image%cube%tuple%current%desc%nx
    image%iter%inyf = 1
    image%iter%inyl = image%cube%tuple%current%desc%ny
    if (associated(image%task)) then
      if (associated(image%task%region)) then
        if (image%task%region%ix%first.ne.code_indx_auto)  &
          image%iter%inxf = image%task%region%ix%first
        if (image%task%region%ix%last.ne.code_indx_auto)  &
          image%iter%inxl = image%task%region%ix%last
        if (image%task%region%iy%first.ne.code_indx_auto)  &
          image%iter%inyf = image%task%region%iy%first
        if (image%task%region%iy%last.ne.code_indx_auto)  &
          image%iter%inyl = image%task%region%iy%last
      endif
    endif
    !
    image%iter%mx = image%iter%inxl-image%iter%inxf+1
    image%iter%my = image%iter%inyl-image%iter%inyf+1
    image%iter%nx = image%iter%mx
    image%iter%ny = image%iter%my
    !
  ! image%iter%ouxf = 1
  ! image%iter%ouxl = image%iter%nx
  ! image%iter%ouyf = 1
  ! image%iter%ouyl = image%iter%ny
    !
    ! --- Trailing dimension ---
    image%iter%mz = image%cube%tuple%current%desc%nc
    if (associated(image%task)) then
      if (associated(image%task%region)) then
        if (image%task%region%iz%first.ne.code_indx_auto)  &
          image%iter%mz = image%task%region%iz%last-image%task%region%iz%first+1
      endif
    endif
    image%iter%nz = 1  ! Always 1 plane
    ! Those are to be computed later at each iteration
    image%iter%inz = 0
    image%iter%ouz = 0
  end subroutine image_iteration_subset
  !
  subroutine image_iteration_plane(image,oent,error)
    !-------------------------------------------------------------------
    ! Compute the input and output plane number for output entry 'oent'
    !-------------------------------------------------------------------
    class(image_t),       intent(inout) :: image  !
    integer(kind=entr_k), intent(in)    :: oent   ! Output entry number
    logical,              intent(inout) :: error  !
    !
    ! Input
    image%iter%inz = oent
    if (associated(image%task)) then
      if (associated(image%task%region)) then
        if (image%task%region%iz%first.ne.code_indx_auto)  &
          image%iter%inz = oent + image%task%region%iz%first - 1
      endif
    endif
    !
    ! Output
    image%iter%ouz = oent
  end subroutine image_iteration_plane
end module cubeadm_image_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
