subroutine astro_convert(line,error)
  use gbl_message
  use gkernel_interfaces
  use ast_astro
  !---------------------------------------------------------------------
  ! @ private
  !	ASTRO Command CONVERT
  !---------------------------------------------------------------------
  character(len=*):: line           !
  logical :: error                  !
  ! Local
  character(len=2) :: coord, coord_old  ! coordinate system ('EQ','GA','HO'...)
  character(len=2) :: vtyp, vtype_old   ! velocity system ('LS', 'EA', 'HE')
  real(kind=4) :: equinox, equinox_old        ! Equinox
  real(kind=4) :: velo                        ! Velocity (km/s)
  real(kind=8) :: lambda, beta                ! coords (rad)
  character(len=80) :: name,file,par
  character(len=20) :: chain
  integer(kind=4) :: nlu, npar, lpar, nc, lun, ko, olun, i, nt, icat, ier
  character(len=2) :: ftype
  real(kind=4) :: flux, spindex, mag(9),redsh
  character(len=132) :: c_line, o_line, comment
  character(len=13) :: rname
  ! Data
  data rname /'ASTRO_CONVERT'/
  ! Code -------------------------------------------------------------------
  !
  ! search in catalog
  if (sic_present(1,0)) then
    icat = 2
  else
    icat = 1
  endif
  if (lenc(catalog_name(icat)).eq.0) then
    call astro_message(seve%f,rname,'No catalog')
    error = .true.
    return
  endif
  !
  ! Define output file
  if (sic_present(0,1)) then
    call sic_ch (line,0,1,name,nc,.true.,error)
    if (error) return
    call sic_parsef(name,file,' ','.cat')
  else
    name = catalog_name(icat)
    ! Rename extension
    call sic_parsef(name,file,' ',' ')
    call sic_parsef(name,file,' ','.cat')
  endif
  !
  ! Open input file
  ier = sic_getlun (lun)
  ier = sic_open(lun,catalog_name(icat),'OLD',.true.)
  if (ier.ne.0) then
    call astro_message(seve%e,rname,'Error opening '//catalog_name(icat))
    call sic_frelun(lun)
    error = .true.
    return
  endif
  !
  ! Open output file
  ier = sic_getlun(olun)
  ier = sic_open(olun,file,'NEW',.false.)
  if (ier.ne.0) then
    call astro_message(seve%e,rname,'Error opening '//file)
    close (unit=lun)
    call sic_frelun (lun)
    call sic_frelun (olun)
    error = .true.
    return
  endif
  !
  write(olun,1000) 'INDIVIDUAL: SNAM SLAM SBET VLSR'
  vtyp = 'LS'
  !
  do while (.true.)
    100      read(lun,1000,end=210,iostat=ier) c_line
    if (ier.ne.0) then
      call astro_message(seve%e,rname,'Error reading catalog')
      error = .true.
      goto 210
    endif
    nlu = lenc(c_line)
    if (nlu.eq.0) then
      write(olun,1000) '!'
      goto 100
    elseif (c_line(1:1).eq.'!') then
      write(olun,1000) c_line(1:nlu)
      goto 100
    endif
    i = index(c_line(1:nlu),'!')
    if (i.ne.0) then
      comment = c_line(i+1:nlu)
    else
      comment = ' '
    endif
    call sic_blanc(c_line,nlu)
    npar = 1
    lpar = 12
    call sic_next(c_line(1:nlu),par,lpar,npar)
    if (lpar.eq.0) goto 100
    coord_old = coord
    equinox_old = equinox
    vtype_old = vtyp
    call decode_line (c_line, npar, coord, equinox, lambda, beta, vtyp, velo,redsh,  &
    ftype, flux, spindex, mag, error)
    !
    ! Coordinate system
    if (coord_old.ne.coord .or. equinox.ne.equinox_old) then
      if (coord.eq.'EQ' .and. equinox.eq.1950.0) then
        write(olun,1000) 'COMMON: SBAS=1;'
      elseif (coord.eq.'EQ' .and. equinox.eq.2000.0) then
        write(olun,1000) 'COMMON: SBAS=-1;'
      elseif (coord.eq.'EQ') then
        write(olun,1001) 'COMMON: SBAS=2; SEQN=',equinox,';'
      elseif (coord.eq.'GA') then
        write(olun,1000) 'COMMON: SBAS=0;'
      elseif (coord.eq.'EC' .and. equinox.eq.1950.0) then
        write(olun,1000) 'COMMON: SBAS=6;'
      elseif (coord.eq.'EC') then
        write(olun,1001) 'COMMON: SBAS=7; SEQN=',equinox,';'
      elseif (coord.eq.'DA') then
        write(olun,1000) 'COMMON: SBAS=3;'
      elseif (coord.eq.'HO') then
        write(olun,1000) 'COMMON: SBAS=10;'
      endif
    endif
    !
    ! Source name
    call strip(par(1:lpar),'_')
    o_line(1:19) = 'SNAM='//par(1:lpar)
    ko = 20
    !
    ! Lambda
    if (coord.eq.'EQ' .or. coord.eq.'DA') then
      call rad2sexa(lambda,24,chain,4,left=.true.)
    else
      call rad2sexa(lambda,360,chain,3,left=.true.)
    endif
    call strip(chain,':')
    o_line(ko:) = ';SLAM='//chain
    ko = 40
    !
    ! Beta
    call rad2sexa(beta,360,chain,3,left=.true.)
    call strip(chain,':')
    o_line(ko:) = ';SBET='//chain
    ko = 60
    !
    ! Velocity
    if (vtyp.eq.'LS') then
      o_line(ko:) = ';VLSR='
      if (vtyp.ne.vtype_old) write(olun,1000) 'INDIVIDUAL: SNAM SLAM SBET VLSR'
    elseif (vtyp.eq.'HE') then
      o_line(ko:) = ';VHEL='
      if (vtyp.ne.vtype_old) write(olun,1000) 'INDIVIDUAL: SNAM SLAM SBET VHEL'
    else if (vtyp.eq.'RE') then
      call astro_message(seve%w,'CONVERT','Redshift unsupported')
      goto 25
    else 
      call astro_message(seve%w,'CONVERT','EARTH velocities unsupported')
      goto 25
    endif
    ko = ko + 6
    write(chain,1002) velo
    nt = lenc(chain)
    call sic_blanc(chain, nt)
    o_line(ko:) = chain
    ko = ko + lenc(chain)
    25       continue
    o_line(ko:) = ';'
    write(olun,1000) o_line(1:ko)
    if (lenc(comment).gt.0) then
      write (olun,1000) '!             '//comment(1:lenc(comment))
    endif
  enddo
  !
  210   close (unit=lun)
  call sic_frelun (lun)
  write(olun,1000) 'STOP'
  close (unit=olun)
  call sic_frelun (olun)
  return
  !
  1000  format(a)
  1001  format(a,f11.5,a)
  1002  format(f12.5)
end subroutine astro_convert
!
subroutine strip(c1,char)
  !---------------------------------------------------------------------
  ! @ private
  !	Suppress character CHAR from string C1
  ! Arguments
  !	C1	C*(*)	String to be stripped
  !	CHAR	C*1	Stripping character
  !---------------------------------------------------------------------
  character(len=*):: c1             !
  character(len=1) :: char          !
  ! Global
  integer(kind=4) :: lenc
  ! Local
  integer(kind=4) :: i
  ! Code ------------------------------------------------------------------
  do i=1, lenc(c1)
    if (c1(i:i).eq.char) then
      c1(i:i) = ' '
    endif
  enddo
end subroutine strip
