<?php

include "cli.php";

class person {
    var $name;
    var $salary;
    var $address;
    var $rating;
}

$con = new gb_connection;
$rc = $con->open("localhost", 6100);
if ($rc != cli_ok) { 
    user_error("con->open failed with status $rc");
}

$stmt = $con->create_statement("insert into person");
$stmt->bind_column("name", &$name);
$stmt->bind_column("salary", &$salary);
$stmt->bind_column("address", &$address);
$stmt->bind_column("rating", &$rating);
$stmt->bind_column("pets", &$pets);

$name = "John Smith";
$address = "1 Guildhall St., Cambridge CB2 3NH, UK";
$salary = 80000;
$rating = 3.84;
$pets = array("dog", "cat");
$rc = $stmt->insert(&$ref);
if ($rc != cli_ok || get_class($ref) != "gb_reference") { 
    user_error("stmt->insert 1 failed with status $rc");
}

$name = "Joe Cooker";
$address = "Outlook drive, 15/3";
$salary = 50000;
$rating = 1.76;
$pets = array("snake");
$rc = $stmt->insert($ref);
if ($rc != cli_ok || get_class($ref) != "gb_reference") { 
    user_error("stmt->insert 2 failed with status $rc");
}

$rc = $stmt->free();
if ($rc != cli_ok) { 
    user_error("stmt->free failed with status $rc");
}

$p = new person;
$p->name = "Hugo Grant";
$p->address = "London, Baker street,12";
$p->salary = 65000;
$p->rating = 2.14;      
$p->pets = array("canary", "goldfish");
$rc = $con->insert($p, &$ref);
if ($rc != cli_ok || get_class($ref) != "gb_reference") { 
    user_error("stmt->insert 3 failed with status $rc");
}
$con->commit();
$stmt = $con->create_statement("select * from person where salary > %salary order by salary");
$salary = 65000;
$stmt->bind_column("name", &$name);
$stmt->bind_column("salary", &$salary);
$stmt->bind_column("rating", &$rating);
$stmt->bind_parameter("%salary", &$salary);
$rc = $stmt->fetch();
if ($rc != 1) {
    user_error("stmt->fetch 1 returns $rc instead of 1");
}
print("NAME\t\tSALARY\tRATING\n");
while ($stmt->get_next() == cli_ok) { 
    print("$name\t$salary\t$rating\n");
}
$salary = 50000;
$rc = $stmt->fetch();
if ($rc != 2) {
    user_error("stmt->fetch 2 returns $rc instead of 2");
}
if (($rc = $stmt->free()) != cli_ok) { 
    user_error("stmt->close failed with status $rc");
}

$stmt = $con->create_statement("select * from person where current = %ref");
$stmt->bind_parameter("%ref", &$ref);
$stmt->bind_object(&$p);
$rc = $stmt->fetch();
if ($rc != 1) {
    user_error("stmt->fetch 3 returns $rc instead of 1");
}
$rc = $stmt->get_first();
if ($rc != cli_ok) { 
    user_error("stmt->get_first failed with status $rc");
}
print("Object oid=".$ref->oid.", name=".$p->name.", address=".$p->address.", rating=".$p->rating.", salary=".$p->salary."\n");
foreach ($p->pets as $pet) {
        print("Pet: $pet\n");
}
$stmt->free();

$stmt = $con->create_statement("select * from person where rating > %rating and salary between %min and %max");
settype(&$rating, "double");
$min_salary = 50000;
$max_salary = 100000;
$stmt->bind_parameter("%rating", &$rating);
$stmt->bind_parameter("%min", &$min_salary);
$stmt->bind_parameter("%max", &$max_salary);
$stmt->bind_array(&$tuple);
$rating = 2.0;
$rc = $stmt->fetch(true);
if ($rc != 2) {
    user_error("stmt->fetch 4 returns $rc instead of 2");
}
$rc = $stmt->get_last();
print("NAME\t\tSALARY\tRATING\tADDRESS\n");
do { 
    if ($rc != cli_ok) { 
        user_error("stmt->get_prev failed with status $rc");     
    }           
    print($tuple["name"]."\t".$tuple["salary"]."\t".$tuple["rating"]."\t".$tuple["address"]."\n");
    $tuple["salary"] = (integer)((double)$tuple["salary"]*1.1);
    $rc = $stmt->update();
    if ($rc != cli_ok) { 
        user_error("stmt->update failed with status $rc");
    }
} while (($rc = $stmt->get_prev()) != cli_not_found);
$stmt->free();

$rc = $con->commit();
if ($rc != cli_ok) { 
    user_error("con->commit failed with status $rc");
}

$stmt = $con->create_statement("select * from person where address like %pattern");
$pattern = "%";
$stmt->bind_object(&$p);
$stmt->bind_parameter("%pattern", &$pattern); 
$rc = $stmt->fetch();
if ($rc != 3) {
    user_error("stmt->fetch 5 returns $rc instead of 3");
}
print("NAME\t\tSALARY\tRATING\tADDRESS\n");
while ($stmt->get_next() != cli_not_found) { 
    print($p->name."\t".$p->salary."\t".$p->rating."\t".$p->address."\n");
}
$stmt->free();

$stmt = $con->create_statement("select * from person");
$rc = $stmt->fetch(true);
if ($rc != 3) {
    user_error("stmt->fetch 6 returns $rc instead of 3");
}
$rc = $stmt->remove();
if ($rc != cli_ok) { 
    user_error("stmt->remove failed with status $rc");
}
$stmt->free();

$rc = $con->close();
if ($rc != cli_ok) { 
    user_error("com->close failed with status $rc");
}
print("*** CLI test sucessfully passed!\n");

?>


