/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import generic.theme.Gui;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenHighlightColors {
    private Map<String, Color> colorsByName = new HashMap<String, Color>();
    private List<Color> recentColors = new ArrayList<Color>();

    private Color generateColor() {
        float h = (float)Math.random();
        float s = 0.25f;
        float b = 1.0f;
        if (Gui.isDarkTheme()) {
            s = 0.5f;
            b = 0.5f;
        }
        return Color.getHSBColor(h, s, b);
    }

    public Color getColor(String text) {
        return this.colorsByName.computeIfAbsent(text, t -> this.generateColor());
    }

    public void setColor(String text, Color color) {
        this.colorsByName.put(text, color);
        this.recentColors.add(color);
    }

    public List<Color> getRecentColors() {
        return this.recentColors;
    }
}

