/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.frida;

import agent.frida.jna.FridaNative;
import agent.frida.manager.FridaDebugger;
import agent.frida.manager.FridaError;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaScript;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaTarget;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class FridaEng {
    private static final NativeLong FRIDA_REALM_NATIVE = new NativeLong(0L);

    public static FridaDebugger init() {
        FridaNative.INSTANCE.GH_frida_init();
        return new FridaDebugger(FridaNative.INSTANCE.GH_frida_device_manager_new());
    }

    public static FridaTarget createTarget(FridaDebugger d) {
        return FridaEng.createTargetByType(d, FridaDeviceType.TYPE_LOCAL.ordinal());
    }

    public static FridaTarget createTargetByType(FridaDebugger d, long type) {
        Pointer deviceManager = d.getPointer();
        FridaError err = new FridaError();
        Pointer device = FridaNative.INSTANCE.GH_frida_device_manager_find_device_by_type_sync(deviceManager, new NativeLong(type), new NativeLong(10L), null, err.error);
        if (device == null) {
            Msg.error((Object)d, (Object)err);
            return null;
        }
        String id = FridaNative.INSTANCE.GH_frida_device_get_id(device);
        String name = FridaNative.INSTANCE.GH_frida_device_get_name(device);
        FridaTarget target = new FridaTarget(device, id, name);
        Msg.warn((Object)d, (Object)("current target: " + id));
        return target;
    }

    public static FridaTarget createTargetById(FridaDebugger d, String id) {
        Pointer deviceManager = d.getPointer();
        FridaError err = new FridaError();
        Pointer device = FridaNative.INSTANCE.GH_frida_device_manager_find_device_by_id_sync(deviceManager, id, new NativeLong(10L), null, err.error);
        if (device == null) {
            Msg.error((Object)d, (Object)err);
            return null;
        }
        String name = FridaNative.INSTANCE.GH_frida_device_get_name(device);
        FridaTarget target = new FridaTarget(device, id, name);
        Msg.warn((Object)d, (Object)("current target: " + id));
        return target;
    }

    public static List<FridaTarget> enumerateDevices(FridaDebugger d) {
        Pointer deviceManager = d.getPointer();
        FridaError err = new FridaError();
        Pointer deviceList = FridaNative.INSTANCE.GH_frida_device_manager_enumerate_devices_sync(deviceManager, null, err.error);
        if (deviceList == null) {
            Msg.error((Object)d, (Object)err);
            return null;
        }
        Integer numDevices = FridaNative.INSTANCE.GH_frida_device_list_size(deviceList);
        ArrayList<FridaTarget> targetList = new ArrayList<FridaTarget>(numDevices);
        for (int i = 0; i != numDevices; ++i) {
            Pointer device = FridaNative.INSTANCE.GH_frida_device_list_get(deviceList, i);
            String id = FridaNative.INSTANCE.GH_frida_device_get_id(device);
            String name = FridaNative.INSTANCE.GH_frida_device_get_name(device);
            FridaTarget t = new FridaTarget(device, id, name);
            targetList.add(t);
        }
        return targetList;
    }

    public static List<FridaProcess> enumerateProcesses(FridaTarget t) {
        Pointer device = t.getPointer();
        FridaError err = new FridaError();
        Pointer list = FridaNative.INSTANCE.GH_frida_device_enumerate_processes_sync(device, null, null, err.error);
        if (list == null) {
            Msg.error((Object)t, (Object)err);
            return null;
        }
        Integer numProcesses = FridaNative.INSTANCE.GH_frida_process_list_size(list);
        ArrayList<FridaProcess> processList = new ArrayList<FridaProcess>(numProcesses);
        for (int i = 0; i != numProcesses; ++i) {
            Pointer process = FridaNative.INSTANCE.GH_frida_process_list_get(list, i);
            NativeLong pid = FridaNative.INSTANCE.GH_frida_process_get_pid(process);
            String name = FridaNative.INSTANCE.GH_frida_process_get_name(process);
            FridaProcess p = new FridaProcess(process, pid);
            p.setName(name);
            processList.add(p);
        }
        return processList;
    }

    public static List<FridaProcess> enumerateApplications(FridaTarget t) {
        Pointer device = t.getPointer();
        FridaError err = new FridaError();
        Pointer list = FridaNative.INSTANCE.GH_frida_device_enumerate_applications_sync(device, null, null, err.error);
        if (list == null) {
            Msg.error((Object)t, (Object)err);
            return null;
        }
        Integer numApplications = FridaNative.INSTANCE.GH_frida_process_list_size(list);
        ArrayList<FridaProcess> processList = new ArrayList<FridaProcess>(numApplications);
        for (int i = 0; i != numApplications; ++i) {
            Pointer application = FridaNative.INSTANCE.GH_frida_application_list_get(list, i);
            NativeLong pid = FridaNative.INSTANCE.GH_frida_application_get_pid(application);
            String name = FridaNative.INSTANCE.GH_frida_application_get_name(application);
            String identifier = FridaNative.INSTANCE.GH_frida_application_get_identifier(application);
            FridaProcess p = new FridaProcess(application, pid);
            p.setName(name);
            p.setIdentifier(identifier);
            processList.add(p);
        }
        return processList;
    }

    public static FridaSession attach(FridaTarget t, NativeLong pid, FridaError err) {
        FridaNative.GError.ByReference ref;
        Pointer localDevice = t.getPointer();
        Pointer session = FridaNative.INSTANCE.GH_frida_device_attach_sync(localDevice, pid, FRIDA_REALM_NATIVE, null, ref = new FridaNative.GError.ByReference());
        if (session == null) {
            Msg.error((Object)t, (Object)((Object)ref));
            return null;
        }
        Pointer process = FridaNative.INSTANCE.GH_frida_device_get_process_by_pid_sync(localDevice, pid, null, null, err.error);
        if (process == null) {
            Msg.error((Object)t, (Object)err);
            return null;
        }
        FridaProcess p = new FridaProcess(process, pid);
        FridaSession s = new FridaSession(session, p);
        p.setSession(s);
        s.setTarget(t);
        t.setSession(s);
        return s;
    }

    public static FridaSession spawn(FridaTarget t, String fileName, FridaError err) {
        Pointer localDevice = t.getPointer();
        NativeLong pid = FridaNative.INSTANCE.GH_frida_device_spawn_sync(localDevice, fileName, FRIDA_REALM_NATIVE, null, err.error);
        if (!err.success()) {
            Msg.error((Object)t, (Object)err);
            return null;
        }
        return FridaEng.attach(t, pid, err);
    }

    public static void resume(FridaTarget t, NativeLong pid, FridaError err) {
        Pointer localDevice = t.getPointer();
        FridaNative.INSTANCE.GH_frida_device_resume_sync(localDevice, pid, null, err.error);
        if (!err.success()) {
            Msg.error((Object)t, (Object)err);
        }
    }

    public static void kill(FridaTarget t, NativeLong pid, FridaError err) {
        Pointer localDevice = t.getPointer();
        FridaNative.INSTANCE.GH_frida_device_kill_sync(localDevice, pid, null, err.error);
        if (!err.success()) {
            Msg.error((Object)t, (Object)err);
        }
    }

    public static void detach(FridaSession s, FridaError err) {
        Pointer session = s.getPointer();
        FridaNative.INSTANCE.GH_frida_session_detach_sync(session, null, err.error);
        if (!err.success()) {
            Msg.error((Object)s, (Object)err);
        }
    }

    public static void resume(FridaSession s, FridaError err) {
        Pointer session = s.getPointer();
        FridaNative.INSTANCE.GH_frida_session_resume_sync(session, null, err.error);
        if (!err.success()) {
            Msg.error((Object)s, (Object)err);
        }
    }

    public static NativeLong connectSignal(FridaScript s, String signal, FridaNative.MessageCallback cb, Pointer userData) {
        Pointer script = s.getPointer();
        return FridaNative.INSTANCE.GH_g_signal_connect_data(script, signal, cb, userData, null, new NativeLong(0L));
    }

    public static void disconnectSignal(FridaScript s, NativeLong signal) {
        Pointer script = s.getPointer();
        FridaNative.INSTANCE.GH_g_signal_handler_disconnect(script, signal);
    }

    public static NativeLong createSignal(String signal) {
        return FridaNative.INSTANCE.GH_g_signal_new(signal, FridaNative.INSTANCE.GH_frida_bus_session_get_type(), new NativeLong(2L), new NativeLong(0L), null, null, null, new NativeLong(1L), new NativeLong(1L), new NativeLong(16L));
    }

    public static void emitSignal(FridaSession s, String signal) {
        Pointer script = s.getPointer();
        FridaNative.INSTANCE.GH_g_signal_emit_by_name(script, signal);
    }

    public static NativeLong getBusType() {
        return FridaNative.INSTANCE.GH_frida_bus_session_get_type();
    }

    public static FridaScript createScript(FridaSession s, String commands, Pointer options) {
        if (s == null) {
            Msg.error((Object)s, (Object)"null session");
            return null;
        }
        Pointer session = s.getPointer();
        FridaError err = new FridaError();
        Pointer script = FridaNative.INSTANCE.GH_frida_session_create_script_sync(session, commands, options, null, err.error);
        if (script == null) {
            Msg.error((Object)s, (Object)("Unable to create script: " + commands));
            return null;
        }
        return new FridaScript(script);
    }

    public static void unref(FridaScript s) {
        Pointer script = s.getPointer();
        FridaNative.INSTANCE.GH_frida_unref(script);
    }

    public static void loadScript(FridaScript s) {
        Pointer script = s.getPointer();
        FridaError err = new FridaError();
        FridaNative.INSTANCE.GH_frida_script_load_sync(script, null, err.error);
        if (!err.success()) {
            Msg.error((Object)s, (Object)err);
        }
    }

    public static void unloadScript(FridaScript s) {
        Pointer script = s.getPointer();
        FridaError err = new FridaError();
        FridaNative.INSTANCE.GH_frida_script_unload_sync(script, null, err.error);
        if (!err.success()) {
            Msg.error((Object)s, (Object)err);
        }
    }

    public static Pointer createOptions(String name) {
        Pointer options = FridaNative.INSTANCE.GH_frida_script_options_new();
        FridaNative.INSTANCE.GH_frida_script_options_set_name(options, name);
        FridaNative.INSTANCE.GH_frida_script_options_set_runtime(options, new NativeLong(0L));
        return options;
    }

    public static void enableDebugger(FridaSession s, NativeLong port) {
        Pointer session = s.getPointer();
        FridaError err = new FridaError();
        FridaNative.INSTANCE.GH_frida_session_enable_debugger_sync(session, port, null, err.error);
        if (!err.success()) {
            Msg.error((Object)s, (Object)err);
        }
    }

    public static enum FridaDeviceType {
        TYPE_LOCAL,
        TYPE_REMOTE,
        TYPE_USB;

    }
}

