/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmitObjects;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.UniqueLayout;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.utils.MessageFormattingUtils;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeParser;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class SleighProgramCompiler
extends Enum<SleighProgramCompiler> {
    private static final String EXPRESSION_SOURCE_NAME = "expression";
    public static final String NIL_SYMBOL_NAME = "__nil";
    private static final /* synthetic */ SleighProgramCompiler[] $VALUES;

    public static SleighProgramCompiler[] values() {
        return (SleighProgramCompiler[])$VALUES.clone();
    }

    public static SleighProgramCompiler valueOf(String name) {
        return Enum.valueOf(SleighProgramCompiler.class, name);
    }

    public static PcodeParser createParser(SleighLanguage language) {
        return new ErrorCollectingPcodeParser(language);
    }

    public static ConstructTpl compileTemplate(Language language, PcodeParser parser, String sourceName, String source) {
        return parser.compilePcode(source, sourceName, 1);
    }

    public static List<PcodeOp> buildOps(Language language, ConstructTpl template) throws UnknownInstructionException, MemoryAccessException, IOException {
        Address zero = language.getDefaultSpace().getAddress(0L);
        SleighParserContext c = new SleighParserContext(zero, zero, zero, zero);
        ParserWalker walk = new ParserWalker(c);
        PcodeEmitObjects emit = new PcodeEmitObjects(walk);
        emit.build(template, 0);
        emit.resolveRelatives();
        return List.of(emit.getPcodeOp());
    }

    protected static void addParserSymbols(PcodeParser parser, Map<Integer, UserOpSymbol> symbols) {
        for (UserOpSymbol sym : symbols.values()) {
            parser.addSymbol((SleighSymbol)sym);
        }
    }

    protected static VarnodeSymbol addNilSymbol(PcodeParser parser) {
        SleighSymbol exists = parser.findSymbol(NIL_SYMBOL_NAME);
        if (exists != null) {
            return (VarnodeSymbol)exists;
        }
        long offset = parser.allocateTemp();
        VarnodeSymbol nil = new VarnodeSymbol(new Location("<util>", 0), NIL_SYMBOL_NAME, parser.getUniqueSpace(), offset, 1);
        parser.addSymbol((SleighSymbol)nil);
        return nil;
    }

    public static <T extends PcodeProgram> T constructProgram(PcodeProgramConstructor<T> ctor, SleighLanguage language, ConstructTpl template, Map<Integer, UserOpSymbol> libSyms) {
        try {
            return ctor.construct(language, SleighProgramCompiler.buildOps((Language)language, template), libSyms);
        }
        catch (UnknownInstructionException | MemoryAccessException | IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PcodeProgram compileProgram(PcodeParser parser, SleighLanguage language, String sourceName, String source, PcodeUseropLibrary<?> library) {
        Map<Integer, UserOpSymbol> symbols = library.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, sourceName, source);
        return SleighProgramCompiler.constructProgram(PcodeProgram::new, language, template, symbols);
    }

    public static PcodeProgram compileProgram(SleighLanguage language, String sourceName, String source, PcodeUseropLibrary<?> library) {
        return SleighProgramCompiler.compileProgram(SleighProgramCompiler.createParser(language), language, sourceName, source, library);
    }

    public static PcodeExpression compileExpression(PcodeParser parser, SleighLanguage language, String expression) {
        Map<Integer, UserOpSymbol> symbols = PcodeExpression.CAPTURING.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, EXPRESSION_SOURCE_NAME, "___result(" + expression + ");");
        return SleighProgramCompiler.constructProgram(PcodeExpression::new, language, template, symbols);
    }

    public static PcodeExpression compileExpression(SleighLanguage language, String expression) {
        return SleighProgramCompiler.compileExpression(SleighProgramCompiler.createParser(language), language, expression);
    }

    public static VarnodeSymbol paramSym(Language language, SleighBase sleigh, String opName, String paramName, Varnode arg) {
        AddressSpace gSpace = language.getAddressFactory().getAddressSpace(arg.getSpace());
        AddrSpace sSpace = sleigh.getSpace(gSpace.getUnique());
        return new VarnodeSymbol(new Location(opName, 0), paramName, sSpace, arg.getOffset(), arg.getSize());
    }

    public static PcodeProgram compileUserop(SleighLanguage language, String opName, List<String> params, String source, PcodeUseropLibrary<?> library, List<Varnode> args) {
        PcodeParser parser = SleighProgramCompiler.createParser(language);
        Map<Integer, UserOpSymbol> symbols = library.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        SleighBase sleigh = parser.getSleigh();
        int count = params.size();
        if (args.size() != count) {
            throw new IllegalArgumentException("Mismatch of params and args sizes");
        }
        VarnodeSymbol nil = SleighProgramCompiler.addNilSymbol(parser);
        VarnodeData nilVnData = nil.getFixedVarnode();
        for (int i = 0; i < count; ++i) {
            String p = params.get(i);
            Varnode a = args.get(i);
            if (a == null && i == 0) {
                parser.addSymbol((SleighSymbol)new VarnodeSymbol(nil.getLocation(), p, nilVnData.space, nilVnData.offset, nilVnData.size));
                continue;
            }
            parser.addSymbol((SleighSymbol)SleighProgramCompiler.paramSym((Language)language, sleigh, opName, p, a));
        }
        try {
            ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, opName, source);
            return SleighProgramCompiler.constructProgram(PcodeProgram::new, language, template, symbols);
        }
        catch (Throwable t) {
            Msg.error(SleighProgramCompiler.class, (Object)("Error trying to compile userop:\n" + source));
            throw t;
        }
    }

    private static /* synthetic */ SleighProgramCompiler[] $values() {
        return new SleighProgramCompiler[0];
    }

    static {
        $VALUES = SleighProgramCompiler.$values();
    }

    public static class ErrorCollectingPcodeParser
    extends PcodeParser {
        private final List<PcodeLogEntry> entries = new ArrayList<PcodeLogEntry>();

        public ErrorCollectingPcodeParser(SleighLanguage language) {
            super(language, UniqueLayout.INJECT.getOffset(language));
        }

        public void reportError(Location location, String msg) {
            this.entries.add(new PcodeError(location, msg));
            super.reportError(location, msg);
        }

        public void reportWarning(Location location, String msg) {
            this.entries.add(new PcodeWarning(location, msg));
            super.reportWarning(location, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConstructTpl compilePcode(String pcodeStatements, String srcFile, int srcLine) throws SleighException {
            try {
                ConstructTpl constructTpl = super.compilePcode(pcodeStatements, srcFile, srcLine);
                return constructTpl;
            }
            finally {
                if (this.getErrors() != 0) {
                    throw new DetailedSleighException(this.entries);
                }
            }
        }
    }

    public static interface PcodeProgramConstructor<T extends PcodeProgram> {
        public T construct(SleighLanguage var1, List<PcodeOp> var2, Map<Integer, UserOpSymbol> var3);
    }

    public static class DetailedSleighException
    extends SleighException {
        private final List<PcodeLogEntry> details;

        public DetailedSleighException(List<PcodeLogEntry> details) {
            super(PcodeLogEntry.formatList(details));
            this.details = List.copyOf(details);
        }

        public List<PcodeLogEntry> getDetails() {
            return this.details;
        }
    }

    record PcodeWarning(Location loc, String msg) implements PcodeLogEntry
    {
        @Override
        public String type() {
            return "WARNING";
        }
    }

    record PcodeError(Location loc, String msg) implements PcodeLogEntry
    {
        @Override
        public String type() {
            return "ERROR";
        }
    }

    public static interface PcodeLogEntry {
        public static String formatList(List<PcodeLogEntry> list) {
            return list.stream().map(e -> e.format()).collect(Collectors.joining("\n"));
        }

        public Location loc();

        public String msg();

        public String type();

        default public String format() {
            return "%s: %s".formatted(this.type(), MessageFormattingUtils.format((Location)this.loc(), (CharSequence)this.msg()));
        }
    }
}

