/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.emulator.AdaptedMemoryState;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emulate.BreakTable;
import ghidra.pcode.emulate.BreakTableCallBack;
import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;

public class ModifiedPcodeThread<T>
extends DefaultPcodeThread<T> {
    protected final EmulateInstructionStateModifier modifier;
    protected final Emulate emulate;

    public ModifiedPcodeThread(String name, AbstractPcodeMachine<T> machine) {
        super(name, machine);
        this.emulate = new GlueEmulate(this.language, new AdaptedMemoryState<T>(this.state, PcodeExecutorStatePiece.Reason.EXECUTE_READ){

            @Override
            public void setMemoryBank(MemoryBank bank) {
            }
        }, new BreakTableCallBack(this.language));
        this.modifier = this.createModifier();
    }

    protected EmulateInstructionStateModifier createModifier() {
        String classname = this.language.getProperty("emulateInstructionStateModifierClass");
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(classname);
            if (!EmulateInstructionStateModifier.class.isAssignableFrom(c)) {
                Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid emulateInstructionStateModifierClass"));
                throw new RuntimeException(classname + " does not implement interface " + EmulateInstructionStateModifier.class.getName());
            }
            Constructor<?> constructor = c.getConstructor(Emulate.class);
            return (EmulateInstructionStateModifier)constructor.newInstance(this.emulate);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid emulateInstructionStateModifierClass"));
            throw new RuntimeException("Failed to instantiate " + classname + " for language " + this.language.getLanguageID(), e);
        }
    }

    @Override
    public void overrideCounter(Address counter) {
        super.overrideCounter(counter);
        if (this.modifier != null) {
            this.modifier.initialExecuteCallback(this.emulate, counter, this.getContext());
        }
    }

    @Override
    protected void postExecuteInstruction() {
        if (this.modifier != null) {
            this.modifier.postExecuteCallback(this.emulate, this.instruction == null ? null : this.instruction.getAddress(), this.frame.copyCode(), this.frame.getBranched(), this.getCounter());
        }
    }

    @Override
    protected boolean onMissingUseropDef(PcodeOp op, String opName) {
        if (this.modifier != null) {
            return this.modifier.executeCallOther(op);
        }
        return super.onMissingUseropDef(op, opName);
    }

    protected class GlueEmulate
    extends Emulate {
        public GlueEmulate(SleighLanguage lang, MemoryState s, BreakTable b) {
            super(lang, s, b);
        }

        @Override
        public Language getLanguage() {
            return ModifiedPcodeThread.this.language;
        }

        @Override
        public void setExecuteAddress(Address addr) {
            ModifiedPcodeThread.this.overrideCounter(addr);
        }

        @Override
        public Address getExecuteAddress() {
            return ModifiedPcodeThread.this.getCounter();
        }

        @Override
        public void setContextRegisterValue(RegisterValue regValue) {
            ModifiedPcodeThread.this.overrideContext(regValue);
        }

        @Override
        public RegisterValue getContextRegisterValue() {
            return ModifiedPcodeThread.this.getContext();
        }
    }
}

