/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface2;

import SWIG.SBThread;
import SWIG.StateType;
import agent.lldb.manager.LldbEventsListenerAdapter;
import agent.lldb.manager.LldbReason;
import agent.lldb.manager.LldbStateListener;
import agent.lldb.manager.cmd.LldbSetActiveThreadCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import agent.lldb.model.iface1.LldbModelSelectableObject;
import agent.lldb.model.iface1.LldbModelTargetAccessConditioned;
import agent.lldb.model.iface1.LldbModelTargetExecutionStateful;
import agent.lldb.model.iface1.LldbModelTargetSteppable;
import agent.lldb.model.impl.LldbModelTargetStackImpl;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetThread;
import java.util.concurrent.CompletableFuture;

public interface LldbModelTargetThread
extends TargetAggregate,
TargetThread,
LldbModelTargetAccessConditioned,
LldbModelTargetExecutionStateful,
LldbModelTargetSteppable,
LldbStateListener,
LldbEventsListenerAdapter,
LldbModelSelectableObject {
    default public SBThread getThread() {
        return (SBThread)this.getModelObject();
    }

    default public void threadStateChangedSpecific(StateType state, LldbReason reason) {
        TargetRegisterContainer container = (TargetRegisterContainer)this.getCachedAttribute("Registers");
        TargetRegisterBank bank = (TargetRegisterBank)container.getCachedAttribute("User");
        if (state.equals(StateType.eStateStopped)) {
            bank.readRegistersNamed(this.getCachedElements().keySet());
        }
    }

    @Override
    default public CompletableFuture<Void> setActive() {
        LldbManagerImpl manager = this.getManager();
        SBThread thread = this.getThread();
        return manager.execute(new LldbSetActiveThreadCommand(manager, thread, -1L));
    }

    public LldbModelTargetStackImpl getStack();

    public String getExecutingProcessorType();
}

