/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBThread;
import agent.lldb.lldb.DebugClient;
import agent.lldb.lldb.DebugThreadInfo;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbProcessCreatedEvent;
import agent.lldb.manager.evt.LldbStoppedEvent;
import agent.lldb.manager.evt.LldbThreadCreatedEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.LinkedHashSet;
import java.util.Set;

public class LldbAttachCommand
extends AbstractLldbCommand<Set<SBThread>> {
    private LldbProcessCreatedEvent created = null;
    private boolean completed = false;
    private String key;
    private int keyType = 0;
    private boolean wait = true;
    private boolean async = false;

    public LldbAttachCommand(LldbManagerImpl manager, String key) {
        this(manager, key, true, false);
        this.keyType = 0;
    }

    public LldbAttachCommand(LldbManagerImpl manager, String key, boolean wait) {
        this(manager, key, wait, false);
        this.keyType = 1;
    }

    public LldbAttachCommand(LldbManagerImpl manager, String key, boolean wait, boolean async) {
        super(manager);
        this.key = key;
        this.wait = wait;
        this.async = async;
        this.keyType = 2;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof LldbProcessCreatedEvent) {
            this.created = (LldbProcessCreatedEvent)evt;
        } else if (evt instanceof LldbThreadCreatedEvent) {
            pending.claim(evt);
        } else if (evt instanceof LldbStoppedEvent) {
            pending.claim(evt);
        }
        return this.completed && this.created != null;
    }

    @Override
    public Set<SBThread> complete(LldbPendingCommand<?> pending) {
        LinkedHashSet<SBThread> threads = new LinkedHashSet<SBThread>();
        for (LldbThreadCreatedEvent adds : pending.findAllOf(LldbThreadCreatedEvent.class)) {
            DebugThreadInfo info = (DebugThreadInfo)adds.getInfo();
            threads.add(info.thread);
        }
        return threads;
    }

    @Override
    public void invoke() {
        DebugClient client = this.manager.getClient();
        client.attachProcess(client.getLocalServer(), this.keyType, this.key, this.wait, this.async);
    }
}

