/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationContext;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class X86_64_CoffRelocationHandler
implements CoffRelocationHandler {
    public static final short IMAGE_REL_AMD64_ABSOLUTE = 0;
    public static final short IMAGE_REL_AMD64_ADDR64 = 1;
    public static final short IMAGE_REL_AMD64_ADDR32 = 2;
    public static final short IMAGE_REL_AMD64_ADDR32NB = 3;
    public static final short IMAGE_REL_AMD64_REL32 = 4;
    public static final short IMAGE_REL_AMD64_REL32_1 = 5;
    public static final short IMAGE_REL_AMD64_REL32_2 = 6;
    public static final short IMAGE_REL_AMD64_REL32_3 = 7;
    public static final short IMAGE_REL_AMD64_REL32_4 = 8;
    public static final short IMAGE_REL_AMD64_REL32_5 = 9;
    public static final short IMAGE_REL_AMD64_SECTION = 10;
    public static final short IMAGE_REL_AMD64_SECREL = 11;
    public static final short IMAGE_REL_AMD64_SECREL7 = 12;
    public static final short IMAGE_REL_AMD64_TOKEN = 13;
    public static final short IMAGE_REL_AMD64_SREL32 = 14;
    public static final short IMAGE_REL_AMD64_PAIR = 15;
    public static final short IMAGE_REL_AMD64_SSPAN32 = 16;

    public boolean canRelocate(CoffFileHeader fileHeader) {
        return fileHeader.getMachine() == -31132;
    }

    public RelocationResult relocate(Address address, CoffRelocation relocation, CoffRelocationContext relocationContext) throws MemoryAccessException, RelocationException {
        Program program = relocationContext.getProgram();
        Memory mem = program.getMemory();
        int distance = 0;
        long addend = mem.getInt(address);
        int byteLength = 4;
        switch (relocation.getType()) {
            case 1: {
                addend = mem.getLong(address);
                long value = relocationContext.getSymbolAddress(relocation).add(addend).getOffset();
                mem.setLong(address, value);
                byteLength = 8;
                break;
            }
            case 2: {
                int value = (int)relocationContext.getSymbolAddress(relocation).add(addend).getOffset();
                mem.setInt(address, value);
                break;
            }
            case 3: {
                int value = (int)relocationContext.getSymbolAddress(relocation).add(addend).subtract(program.getImageBase());
                mem.setInt(address, value);
                break;
            }
            case 9: {
                ++distance;
            }
            case 8: {
                ++distance;
            }
            case 7: {
                ++distance;
            }
            case 6: {
                ++distance;
            }
            case 5: {
                ++distance;
            }
            case 4: {
                int value = (int)relocationContext.getSymbolAddress(relocation).add(addend).subtract(address);
                mem.setInt(address, value -= distance + 4);
                break;
            }
            case 0: 
            case 10: 
            case 11: 
            case 13: {
                return RelocationResult.SKIPPED;
            }
            default: {
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

