/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbThreadSelectedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;

public class GdbSetActiveFrameCommand
extends AbstractGdbCommandWithThreadId<Void> {
    private final Integer frameId;
    private final boolean internal;

    public GdbSetActiveFrameCommand(GdbManagerImpl manager, Integer threadId, int frameId, boolean internal) {
        super(manager, threadId);
        this.frameId = frameId;
        this.internal = internal;
    }

    @Override
    protected String encode(String threadPart) {
        return "-interpreter-exec" + threadPart + " console \"frame " + this.frameId + "\"";
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbThreadSelectedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        return null;
    }

    @Override
    public boolean isFocusInternallyDriven() {
        return this.internal;
    }
}

