/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.widgets.button.GRadioButton;
import docking.widgets.label.GDLabel;
import docking.widgets.list.GList;
import docking.wizard.AbstractWizardJPanel;
import docking.wizard.PanelManager;
import docking.wizard.WizardManager;
import ghidra.util.HelpLocation;
import ghidra.util.NamingUtilities;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RepositoryPanel
extends AbstractWizardJPanel {
    private String serverName;
    private JRadioButton existingRepButton;
    private JRadioButton createRepButton;
    private ButtonGroup buttonGroup;
    private GList<String> nameList;
    private DefaultListModel<String> listModel;
    private JTextField nameField;
    private JLabel nameLabel;
    private PanelManager panelManager;
    private HelpLocation helpLoc;

    public RepositoryPanel(PanelManager panelManager, String serverName, String[] repositoryNames, boolean readOnlyServerAccess) {
        super((LayoutManager)new BorderLayout(5, 10));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.panelManager = panelManager;
        this.serverName = serverName;
        this.buildMainPanel(repositoryNames, readOnlyServerAccess);
    }

    public String getTitle() {
        return "Specify Repository Name on " + this.serverName;
    }

    public void initialize() {
        this.existingRepButton.setSelected(true);
        this.nameList.clearSelection();
        this.nameField.setText("");
    }

    public boolean isValidInformation() {
        if (this.createRepButton.isSelected()) {
            String name = this.nameField.getText();
            if (name.length() == 0) {
                return false;
            }
            if (!NamingUtilities.isValidProjectName((String)name)) {
                this.panelManager.getWizardManager().setStatusMessage("Invalid project repository name");
                return false;
            }
            return !this.listModel.contains(name);
        }
        return this.nameList.getSelectedValue() != null;
    }

    public HelpLocation getHelpLocation() {
        if (this.helpLoc != null) {
            return this.helpLoc;
        }
        return new HelpLocation("FrontEndPlugin", "SelectRepository");
    }

    void setHelpLocation(HelpLocation helpLoc) {
        this.helpLoc = helpLoc;
    }

    boolean createRepository() {
        return this.createRepButton.isSelected();
    }

    String getRepositoryName() {
        if (this.createRepButton.isSelected()) {
            return this.nameField.getText();
        }
        return (String)this.nameList.getSelectedValue();
    }

    private void buildMainPanel(String[] repositoryNames, boolean readOnlyServerAccess) {
        this.buttonGroup = new ButtonGroup();
        this.add(this.createListPanel(repositoryNames), "Center");
        this.add(this.createNamePanel(), "South");
        this.addListeners();
        if (readOnlyServerAccess) {
            this.createRepButton.setEnabled(false);
            this.createRepButton.setSelected(false);
            this.nameField.setEnabled(false);
            this.nameLabel.setEnabled(false);
        }
    }

    private JPanel createListPanel(String[] repositoryNames) {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createTitledBorder("Choose Existing Repository"));
        this.existingRepButton = new GRadioButton("Existing Repository", repositoryNames.length > 0);
        this.existingRepButton.setEnabled(repositoryNames.length > 0);
        this.buttonGroup.add(this.existingRepButton);
        JPanel innerPanel = new JPanel(new BorderLayout());
        GDLabel label = new GDLabel("Repository Names", 2);
        label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        innerPanel.add((Component)label, "North");
        this.listModel = new DefaultListModel();
        for (String repositoryName : repositoryNames) {
            this.listModel.addElement(repositoryName);
        }
        this.nameList = new GList(this.listModel);
        this.nameList.setEnabled(this.existingRepButton.isSelected());
        JScrollPane sp = new JScrollPane((Component)this.nameList);
        innerPanel.add(sp);
        panel.add(this.existingRepButton);
        panel.add(innerPanel);
        return panel;
    }

    private JPanel createNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout((LayoutManager)new VerticalLayout(5));
        namePanel.setBorder(BorderFactory.createTitledBorder("Create Repository"));
        this.createRepButton = new GRadioButton("Create Repository", !this.existingRepButton.isSelected());
        this.buttonGroup.add(this.createRepButton);
        this.nameLabel = new GDLabel("Repository Name:", 4);
        this.nameLabel.setEnabled(this.createRepButton.isSelected());
        this.nameField = new JTextField(20);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RepositoryPanel.this.validateName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RepositoryPanel.this.validateName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RepositoryPanel.this.validateName();
            }
        };
        this.nameField.getDocument().addDocumentListener(dl);
        this.nameField.setEnabled(this.createRepButton.isSelected());
        JPanel innerPanel = new JPanel();
        innerPanel.add(this.nameLabel);
        innerPanel.add(this.nameField);
        namePanel.add(this.createRepButton);
        namePanel.add(innerPanel);
        return namePanel;
    }

    private void validateName() {
        String name;
        WizardManager wm = this.panelManager.getWizardManager();
        Object msg = null;
        if (this.createRepButton.isSelected() && (name = this.nameField.getText()).length() != 0) {
            if (!NamingUtilities.isValidProjectName((String)name)) {
                msg = "Invalid project repository name";
            } else if (this.listModel.contains(name)) {
                msg = name + " already exists";
            }
        }
        wm.validityChanged();
        if (msg != null) {
            wm.setStatusMessage(msg);
        }
    }

    private void addListeners() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean existingRepSelected = RepositoryPanel.this.existingRepButton.isSelected();
                RepositoryPanel.this.nameList.setEnabled(existingRepSelected);
                if (!existingRepSelected) {
                    RepositoryPanel.this.nameList.clearSelection();
                }
                boolean createRepSelected = RepositoryPanel.this.createRepButton.isSelected();
                RepositoryPanel.this.nameField.setEnabled(createRepSelected);
                RepositoryPanel.this.nameLabel.setEnabled(createRepSelected);
                if (!createRepSelected) {
                    RepositoryPanel.this.nameField.setText("");
                }
                RepositoryPanel.this.validateName();
            }
        };
        this.existingRepButton.addActionListener(listener);
        this.createRepButton.addActionListener(listener);
        ListSelectionModel selModel = this.nameList.getSelectionModel();
        selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                RepositoryPanel.this.panelManager.getWizardManager().validityChanged();
            }
        });
    }
}

