/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.CompositeMember;
import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import java.util.ArrayList;
import java.util.List;

public class BitFieldGroupCompositeMember
extends CompositeMember {
    private List<DefaultCompositeMember> list = new ArrayList<DefaultCompositeMember>();

    @Override
    boolean isBitFieldMember() {
        return true;
    }

    @Override
    boolean isSingleBitFieldMember() {
        return false;
    }

    @Override
    boolean isContainer() {
        return false;
    }

    @Override
    boolean isStructureContainer() {
        return false;
    }

    @Override
    boolean isUnionContainer() {
        return false;
    }

    @Override
    int getOffset() {
        if (this.list.isEmpty()) {
            return 0;
        }
        return this.list.get(0).getOffset();
    }

    int getConsumedBits() {
        int consumed = 0;
        for (DefaultCompositeMember m : this.list) {
            consumed += ((BitFieldDataType)m.getDataType()).getBitSize();
        }
        return consumed;
    }

    @Override
    void setOffset(int offset) {
        for (DefaultCompositeMember m : this.list) {
            m.setOffset(offset);
        }
    }

    @Override
    int getLength() {
        if (this.list.isEmpty()) {
            return 0;
        }
        return this.list.get(0).getLength();
    }

    @Override
    DefaultCompositeMember getParent() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0).getParent();
    }

    @Override
    void setParent(DefaultCompositeMember newParent) {
        for (DefaultCompositeMember m : this.list) {
            m.setParent(newParent);
        }
    }

    @Override
    boolean addMember(DefaultCompositeMember member) {
        DataType dt = member.getDataType();
        if (dt == null || dt.getLength() <= 0) {
            return false;
        }
        DefaultCompositeMember bf0 = this.list.remove(0);
        return bf0.addMember(member);
    }

    @Override
    boolean addToStructure(DefaultCompositeMember structure) {
        boolean success = true;
        for (DefaultCompositeMember m : this.list) {
            m.setBitFieldGroup(null);
            success &= m.addToStructure(structure);
        }
        return success;
    }

    @Override
    void finalizeDataType(int preferredSize) {
    }

    private DefaultCompositeMember validateNewMember(CompositeMember member) {
        if (!member.isSingleBitFieldMember()) {
            throw new IllegalArgumentException("expected single bit-field member");
        }
        if (!(this.list.isEmpty() || member.getOffset() == this.getOffset() && member.getLength() == this.getLength())) {
            throw new IllegalArgumentException("expected bit-field member with same offset and length");
        }
        DefaultCompositeMember m = (DefaultCompositeMember)member;
        m.setBitFieldGroup(this);
        return m;
    }

    void addToGroup(CompositeMember member) {
        this.list.add(this.validateNewMember(member));
    }
}

