/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.agent;

import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.agent.SpiDebuggerObjectModel;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public abstract class AbstractDebuggerObjectModel
implements SpiDebuggerObjectModel {
    public final Object lock = new Object();
    public final Object cbLock = new Object();
    protected final ExecutorService clientExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern(this.getClass().getSimpleName() + "-thread-%d").build());
    protected final ListenerSet<DebuggerModelListener> listeners = new ListenerSet(DebuggerModelListener.class, (Executor)this.clientExecutor);
    protected SpiTargetObject root;
    protected boolean rootAdded;
    protected boolean cbRootAdded;
    protected CompletableFuture<SpiTargetObject> completedRoot = new CompletableFuture();
    protected final Map<List<String>, SpiTargetObject> creationLog = new LinkedHashMap<List<String>, SpiTargetObject>();
    protected final Map<List<String>, SpiTargetObject> cbCreationLog = new LinkedHashMap<List<String>, SpiTargetObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void objectCreated(SpiTargetObject object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.creationLog.put(object.getPath(), object);
            if (object.isRoot()) {
                if (this.root != null) {
                    throw new IllegalStateException("Already have a root");
                }
                this.root = object;
            }
            CompletableFuture.runAsync(() -> {
                Object object2 = this.cbLock;
                synchronized (object2) {
                    this.cbCreationLog.put(object.getPath(), object);
                }
            }, this.clientExecutor).exceptionally(ex -> {
                Msg.error((Object)this, (Object)"Error updating objectCreated before callback");
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void objectInvalidated(TargetObject object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.creationLog.remove(object.getPath());
            CompletableFuture.runAsync(() -> {
                Object object2 = this.cbLock;
                synchronized (object2) {
                    this.cbCreationLog.remove(object.getPath());
                }
            }, this.clientExecutor).exceptionally(ex -> {
                Msg.error((Object)this, (Object)"Error updated objectInvalidated before callback");
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addModelRoot(SpiTargetObject root) {
        assert (root == this.root);
        Object object = this.lock;
        synchronized (object) {
            this.rootAdded = true;
            root.getSchema().validateTypeAndInterfaces(root, null, null, root.enforcesStrictSchema());
            CompletableFuture.runAsync(() -> {
                Object object = this.cbLock;
                synchronized (object) {
                    this.cbRootAdded = true;
                }
                this.completedRoot.complete(root);
            }, this.clientExecutor).exceptionally(ex -> {
                Msg.error((Object)this, (Object)"Error updating rootAdded before callback");
                return null;
            });
            this.completedRoot.completeAsync(() -> root, this.clientExecutor);
            ((DebuggerModelListener)this.listeners.fire).rootAdded(root);
        }
    }

    @Override
    public CompletableFuture<? extends TargetObject> fetchModelRoot() {
        return this.completedRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpiTargetObject getModelRoot() {
        Object object = this.lock;
        synchronized (object) {
            return this.root;
        }
    }

    protected void replayed(DebuggerModelListener listener, Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Listener " + listener + " caused unexpected exception"), (Throwable)t);
        }
    }

    protected void replayTreeEvents(DebuggerModelListener listener) {
        for (SpiTargetObject object : this.cbCreationLog.values()) {
            this.replayed(listener, () -> listener.created(object));
        }
        HashSet<SpiTargetObject> visited = new HashSet<SpiTargetObject>();
        for (SpiTargetObject object : this.cbCreationLog.values()) {
            this.replayAddEvents(listener, object, visited);
        }
        if (this.cbRootAdded) {
            this.replayed(listener, () -> listener.rootAdded(this.root));
        }
    }

    protected void replayAddEvents(DebuggerModelListener listener, SpiTargetObject object, Set<SpiTargetObject> visited) {
        Map<String, ? extends TargetObject> cbElements;
        if (!visited.add(object)) {
            return;
        }
        Map<String, ?> cbAttributes = object.getCallbackAttributes();
        if (cbAttributes != null) {
            for (Object val : cbAttributes.values()) {
                if (!(val instanceof TargetObject)) continue;
                assert (val instanceof SpiTargetObject);
                this.replayAddEvents(listener, (SpiTargetObject)val, visited);
            }
            if (!cbAttributes.isEmpty()) {
                this.replayed(listener, () -> listener.attributesChanged(object, List.of(), Map.copyOf(cbAttributes)));
            }
        }
        if ((cbElements = object.getCallbackElements()) != null) {
            for (TargetObject targetObject : cbElements.values()) {
                assert (targetObject instanceof SpiTargetObject);
                this.replayAddEvents(listener, (SpiTargetObject)targetObject, visited);
            }
            if (!cbElements.isEmpty()) {
                this.replayed(listener, () -> listener.elementsChanged(object, List.of(), Map.copyOf(cbElements)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModelListener(DebuggerModelListener listener, boolean replay) {
        Object object = this.lock;
        synchronized (object) {
            if (replay) {
                CompletableFuture.runAsync(() -> {
                    Object object = this.cbLock;
                    synchronized (object) {
                        this.replayTreeEvents(listener);
                        this.listeners.add((Object)listener);
                    }
                }, this.clientExecutor).exceptionally(ex -> {
                    listener.catastrophic((Throwable)ex);
                    return null;
                });
            } else {
                this.listeners.add((Object)listener);
            }
        }
    }

    @Override
    public void removeModelListener(DebuggerModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    public <T> CompletableFuture<T> gateFuture(CompletableFuture<T> future) {
        return future.whenCompleteAsync((t, ex) -> {}, (Executor)this.clientExecutor);
    }

    @Override
    public CompletableFuture<Void> flushEvents() {
        return CompletableFuture.supplyAsync(() -> null, this.clientExecutor);
    }

    @Override
    public CompletableFuture<Void> close() {
        this.clientExecutor.shutdown();
        return AsyncUtils.NIL;
    }

    public void removeExisting(List<String> path) {
        TargetObject existing = this.getModelObject(path);
        if (existing == null) {
            return;
        }
        TargetObject parent = existing.getParent();
        if (parent == null) {
            assert (existing == this.root);
            throw new IllegalStateException("Cannot replace the root");
        }
        if (!path.equals(existing.getPath())) {
            return;
        }
        if (!(parent instanceof SpiTargetObject)) {
            Msg.error((Object)this, (Object)("Could not remove existing object " + existing + ", because parent is not an SpiTargetObject"));
            return;
        }
        SpiTargetObject spiParent = (SpiTargetObject)parent;
        SpiTargetObject delegate = spiParent.getDelegate();
        if (!(delegate instanceof DefaultTargetObject)) {
            Msg.error((Object)this, (Object)("Could not remove existing object " + existing + ", because its parent's delegate is not a DefaultTargetObject"));
            return;
        }
        DefaultTargetObject dtoParent = (DefaultTargetObject)delegate;
        if (PathUtils.isIndex(path)) {
            dtoParent.changeElements(List.of(PathUtils.getIndex(path)), List.of(), "Replaced");
        } else {
            assert (PathUtils.isName(path));
            dtoParent.changeAttributes(List.of(PathUtils.getKey(path)), Map.of(), "Replaced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TargetObject getModelObject(List<String> path) {
        Object object = this.lock;
        synchronized (object) {
            if (path.isEmpty()) {
                return this.root;
            }
            return this.creationLog.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TargetObject> getModelObjects(Predicate<? super TargetObject> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.creationLog.values().stream().filter(predicate).collect(Collectors.toSet());
        }
    }
}

