/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.Span;
import java.util.Comparator;

public interface End<T> {
    public static <T> End<T> negativeInfinity() {
        return Unbound.NEG_INF;
    }

    public static <T> End<T> positiveInfinity() {
        return Unbound.POS_INF;
    }

    public static <T> End<T> lower(T value, boolean inclusive) {
        return new Point<T>(value, inclusive ? Epsilon.ZERO : Epsilon.POSITIVE);
    }

    public static <T> End<T> upper(T value, boolean inclusive) {
        return new Point<T>(value, inclusive ? Epsilon.ZERO : Epsilon.NEGATIVE);
    }

    public String toMinString();

    public String toMaxString();

    public End<T> inc();

    public End<T> dec();

    public int compareTo(End<T> var1, Comparator<T> var2);

    public boolean isValidMin();

    public boolean isValidMax();

    public boolean isInclusive();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Unbound implements End<Void>
    {
        NEG_INF{

            @Override
            public int compareTo(End<Void> that, Comparator<Void> comparator) {
                return that == NEG_INF ? 0 : -1;
            }

            @Override
            public End<Void> dec() {
                return NEG_INF;
            }

            @Override
            public String toMinString() {
                return "(-inf";
            }

            @Override
            public String toMaxString() {
                return "#ERROR-inf)";
            }

            @Override
            public boolean isValidMin() {
                return true;
            }

            @Override
            public boolean isValidMax() {
                return false;
            }
        }
        ,
        POS_INF{

            @Override
            public int compareTo(End<Void> that, Comparator<Void> comparator) {
                return that == POS_INF ? 0 : 1;
            }

            @Override
            public End<Void> inc() {
                return POS_INF;
            }

            @Override
            public String toMinString() {
                return "(#ERROR+inf";
            }

            @Override
            public String toMaxString() {
                return "+inf)";
            }

            @Override
            public boolean isValidMin() {
                return false;
            }

            @Override
            public boolean isValidMax() {
                return true;
            }
        };


        @Override
        public End<Void> inc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public End<Void> dec() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInclusive() {
            return false;
        }
    }

    public record Point<T>(T val, Epsilon epsilon) implements End<T>
    {
        @Override
        public String toMinString() {
            switch (this.epsilon) {
                case NEGATIVE: {
                    return "(#ERROR" + this.val;
                }
                case ZERO: {
                    return "[" + this.val;
                }
                case POSITIVE: {
                    return "(" + this.val;
                }
            }
            throw new AssertionError();
        }

        @Override
        public String toMaxString() {
            switch (this.epsilon) {
                case NEGATIVE: {
                    return this.val + ")";
                }
                case ZERO: {
                    return this.val + "]";
                }
                case POSITIVE: {
                    return "#ERROR" + this.val + ")";
                }
            }
            throw new AssertionError();
        }

        @Override
        public End<T> inc() {
            return new Point<T>(this.val, this.epsilon.inc());
        }

        @Override
        public End<T> dec() {
            return new Point<T>(this.val, this.epsilon.dec());
        }

        @Override
        public boolean isValidMin() {
            return this.epsilon != Epsilon.NEGATIVE;
        }

        @Override
        public boolean isValidMax() {
            return this.epsilon != Epsilon.POSITIVE;
        }

        @Override
        public boolean isInclusive() {
            return this.epsilon == Epsilon.ZERO;
        }

        @Override
        public int compareTo(End<T> that, Comparator<T> comparator) {
            if (that == Unbound.NEG_INF) {
                return 1;
            }
            if (that == Unbound.POS_INF) {
                return -1;
            }
            if (that instanceof Point) {
                Point point = (Point)that;
                int result = comparator.compare(this.val, point.val);
                if (result != 0) {
                    return result;
                }
                result = this.epsilon.compareTo(point.epsilon);
                if (result != 0) {
                    return result;
                }
                return 0;
            }
            throw new AssertionError();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Epsilon {
        NEGATIVE{

            @Override
            Epsilon inc() {
                return ZERO;
            }

            @Override
            Epsilon dec() {
                throw new UnsupportedOperationException();
            }
        }
        ,
        ZERO{

            @Override
            Epsilon inc() {
                return POSITIVE;
            }

            @Override
            Epsilon dec() {
                return NEGATIVE;
            }
        }
        ,
        POSITIVE{

            @Override
            Epsilon inc() {
                throw new UnsupportedOperationException();
            }

            @Override
            Epsilon dec() {
                return ZERO;
            }
        };


        abstract Epsilon inc();

        abstract Epsilon dec();
    }

    public static abstract class EndDomain<N, S extends EndSpan<N, S>>
    implements Span.Domain<End<N>, S> {
        private final Comparator<N> comparator;

        public EndDomain(Comparator<N> comparator) {
            this.comparator = comparator;
        }

        public String toMinString(End<N> min) {
            return min.toMinString();
        }

        public String toMaxString(End<N> max) {
            return max.toMaxString();
        }

        public int compare(End<N> n1, End<N> n2) {
            return n1.compareTo(n2, this.comparator);
        }

        public End<N> min() {
            return End.negativeInfinity();
        }

        public End<N> max() {
            return End.positiveInfinity();
        }

        public End<N> inc(End<N> n) {
            return n.inc();
        }

        public End<N> dec(End<N> n) {
            return n.dec();
        }
    }

    public static interface EndSpan<N, S extends EndSpan<N, S>>
    extends Span<End<N>, S> {
        default public boolean containsPoint(N n) {
            return this.contains(new Point<N>(n, Epsilon.ZERO));
        }
    }
}

