/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.python.GhidraPythonInterpreter;
import ghidra.python.PythonScriptExecutionThread;
import ghidra.util.exception.AssertException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class PythonScript
extends GhidraScript {
    static final String PYTHON_INTERPRETER = "ghidra.python.interpreter";
    private AtomicBoolean interpreterRunning = new AtomicBoolean();

    public void run() {
        GhidraPythonInterpreter interpreter = (GhidraPythonInterpreter)((Object)this.state.getEnvironmentVar(PYTHON_INTERPRETER));
        if (interpreter != null) {
            this.runInExistingEnvironment(interpreter);
        } else {
            this.runInNewEnvironment();
        }
    }

    public void runScript(String scriptName, GhidraState scriptState) throws Exception {
        GhidraPythonInterpreter interpreter = (GhidraPythonInterpreter)((Object)this.state.getEnvironmentVar(PYTHON_INTERPRETER));
        if (interpreter == null && (interpreter = GhidraPythonInterpreter.get()) == null) {
            throw new AssertException("Could not get Ghidra Python interpreter!");
        }
        ResourceFile scriptSource = GhidraScriptUtil.findScriptByName((String)scriptName);
        if (scriptSource != null) {
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider((ResourceFile)scriptSource);
            GhidraScript ghidraScript = provider.getScriptInstance(scriptSource, this.writer);
            if (ghidraScript == null) {
                throw new IllegalArgumentException("Script does not exist: " + scriptName);
            }
            if (scriptState == this.state) {
                this.updateStateFromVariables();
            }
            if (ghidraScript instanceof PythonScript) {
                ghidraScript.set(scriptState, this.monitor, this.writer);
                PythonScript pythonScript = (PythonScript)ghidraScript;
                interpreter.execFile(pythonScript.getSourceFile(), pythonScript);
            } else {
                ghidraScript.execute(scriptState, this.monitor, this.writer);
            }
            if (scriptState == this.state) {
                this.loadVariablesFromState();
            }
            return;
        }
        throw new IllegalArgumentException("Script does not exist: " + scriptName);
    }

    private void runInExistingEnvironment(GhidraPythonInterpreter interpreter) {
        interpreter.execFile(this.sourceFile, this);
    }

    private void runInNewEnvironment() {
        GhidraPythonInterpreter interpreter = GhidraPythonInterpreter.get();
        PrintWriter stdout = this.getStdOut();
        PrintWriter stderr = this.getStdErr();
        interpreter.setOut(stdout);
        interpreter.setErr(stderr);
        this.state.addEnvironmentVar(PYTHON_INTERPRETER, (Object)interpreter);
        PythonScriptExecutionThread executionThread = new PythonScriptExecutionThread(this, interpreter, this.interpreterRunning);
        this.interpreterRunning.set(true);
        executionThread.start();
        while (this.interpreterRunning.get() && !this.monitor.isCancelled()) {
            Thread.yield();
            this.sleep100millis();
        }
        if (this.interpreterRunning.get()) {
            interpreter.interrupt(executionThread);
        }
        stderr.flush();
        stdout.flush();
        interpreter.cleanup();
        this.state.removeEnvironmentVar(PYTHON_INTERPRETER);
    }

    private PrintWriter getStdOut() {
        ConsoleService console;
        PluginTool tool = this.state.getTool();
        if (tool != null && (console = (ConsoleService)tool.getService(ConsoleService.class)) != null) {
            return console.getStdOut();
        }
        return new PrintWriter(System.out, true);
    }

    private PrintWriter getStdErr() {
        ConsoleService console;
        PluginTool tool = this.state.getTool();
        if (tool != null && (console = (ConsoleService)tool.getService(ConsoleService.class)) != null) {
            return console.getStdErr();
        }
        return new PrintWriter(System.err, true);
    }

    private void sleep100millis() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getCategory() {
        return "Python";
    }
}

