/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.memory;

import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.search.memory.CodeUnitSearchInfo;
import ghidra.util.search.memory.MemSearchResult;
import ghidra.util.search.memory.MemorySearchAlgorithm;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.task.TaskMonitor;

public class MemSearcherAlgorithm
implements MemorySearchAlgorithm {
    private boolean forwardSearch;
    private SearchData searchData;
    private AddressSetView searchSet;
    protected int searchLimit;
    private Program program;
    private int alignment;
    private CodeUnitSearchInfo codeUnitSearchInfo;

    MemSearcherAlgorithm(SearchInfo searchInfo, AddressSetView searchSet, Program program) {
        this.searchData = searchInfo.getSearchData();
        this.forwardSearch = searchInfo.isSearchForward();
        this.alignment = searchInfo.getAlignment();
        this.searchSet = searchSet;
        this.searchLimit = searchInfo.getSearchLimit();
        this.program = program;
        this.codeUnitSearchInfo = searchInfo.getCodeUnitSearchInfo();
    }

    @Override
    public void search(Accumulator<MemSearchResult> accumulator, TaskMonitor monitor) {
        AddressRangeIterator addressRanges = this.searchSet.getAddressRanges(this.forwardSearch);
        monitor.initialize(this.searchSet.getNumAddresses());
        int progressCount = 0;
        while (addressRanges.hasNext() && !monitor.isCancelled()) {
            AddressRange range = (AddressRange)addressRanges.next();
            this.searchRange(accumulator, range, monitor, progressCount);
            progressCount = (int)((long)progressCount + range.getLength());
            monitor.setProgress((long)progressCount);
            if (accumulator.size() < this.searchLimit) continue;
            return;
        }
    }

    private void searchRange(Accumulator<MemSearchResult> accumulator, AddressRange range, TaskMonitor monitor, int progressCount) {
        Memory mem = this.program.getMemory();
        Address startAddress = this.forwardSearch ? range.getMinAddress() : range.getMaxAddress();
        Address endAddress = this.forwardSearch ? range.getMaxAddress() : range.getMinAddress();
        int length = this.searchData.getBytes().length;
        while (startAddress != null && !monitor.isCancelled()) {
            Address matchAddress = mem.findBytes(startAddress, endAddress, this.searchData.getBytes(), this.searchData.getMask(), this.forwardSearch, monitor);
            if (this.isMatchingAddress(matchAddress)) {
                MemSearchResult result = new MemSearchResult(matchAddress, length);
                accumulator.add((Object)result);
                if (accumulator.size() >= this.searchLimit) {
                    return;
                }
                monitor.setProgress((long)(progressCount + this.getRangeDifference(range, matchAddress)));
            }
            startAddress = this.getNextAddress(matchAddress, range);
        }
    }

    private boolean isMatchingAddress(Address address) {
        if (address == null) {
            return false;
        }
        if (address.getOffset() % (long)this.alignment != 0L) {
            return false;
        }
        if (this.codeUnitSearchInfo.searchAll()) {
            return true;
        }
        Listing listing = this.program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitContaining(address);
        if (codeUnit instanceof Instruction) {
            return this.codeUnitSearchInfo.isSearchInstructions();
        }
        if (codeUnit instanceof Data) {
            Data data = (Data)codeUnit;
            if (data.isDefined()) {
                return this.codeUnitSearchInfo.isSearchDefinedData();
            }
            return this.codeUnitSearchInfo.isSearchUndefinedData();
        }
        return true;
    }

    private int getRangeDifference(AddressRange range, Address address) {
        return (int)(this.forwardSearch ? address.subtract(range.getMinAddress()) : range.getMaxAddress().subtract(address));
    }

    private Address getNextAddress(Address currentAddress, AddressRange range) {
        if (currentAddress == null) {
            return null;
        }
        if (this.forwardSearch) {
            return currentAddress.equals((Object)range.getMaxAddress()) ? null : currentAddress.next();
        }
        return currentAddress.equals((Object)range.getMinAddress()) ? null : currentAddress.previous();
    }

    AddressSetView getSearchSet() {
        return this.searchSet;
    }
}

