/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DiffUtility;
import java.util.Iterator;

public class AddressRangeIteratorConverter
implements AddressRangeIterator {
    private AddressRangeIterator iterator;
    private Program program;
    AddressRange nextRange;

    public AddressRangeIteratorConverter(AddressRangeIterator iterator, Program program) {
        this.iterator = iterator;
        this.program = program;
    }

    public Iterator<AddressRange> iterator() {
        return this;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        if (this.nextRange != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            AddressRange range = (AddressRange)this.iterator.next();
            AddressRange convertedRange = DiffUtility.getCompatibleAddressRange(range, this.program);
            if (convertedRange == null) continue;
            this.nextRange = convertedRange;
            return true;
        }
        return false;
    }

    public AddressRange next() {
        if (this.nextRange != null) {
            AddressRange convertedRange = this.nextRange;
            this.nextRange = null;
            return convertedRange;
        }
        if (this.hasNext()) {
            return this.nextRange;
        }
        return null;
    }
}

