/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GColor;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public class FunctionRepeatableCommentFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Function Repeatable Comment";
    public static final GColor COLOR = new GColor("color.fg.listing.comment.repeatable");

    public FunctionRepeatableCommentFieldFactory() {
        super(FIELD_NAME);
    }

    public FunctionRepeatableCommentFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Function)) {
            return null;
        }
        int x = this.startX + varWidth;
        Function f = (Function)obj;
        Program program = f.getProgram();
        String[] commentArr = f.getRepeatableCommentAsArray();
        FieldElement[] fields = new FieldElement[commentArr.length];
        AttributedString prototype = new AttributedString("prototype", (Color)ListingColors.CommentColors.REPEATABLE, this.getMetrics());
        for (int i = 0; i < commentArr.length; ++i) {
            fields[i] = CommentUtils.parseTextForAnnotations(commentArr[i], program, prototype, i);
        }
        if (commentArr.length > 0) {
            return ListingTextField.createMultilineTextField(this, proxy, fields, x, this.width, Integer.MAX_VALUE, this.hlProvider);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Function function = functionProxy.getObject();
            return new FunctionRepeatableCommentFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), function.getRepeatableCommentAsArray(), row, col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof FunctionRepeatableCommentFieldLocation) {
            FunctionRepeatableCommentFieldLocation floc = (FunctionRepeatableCommentFieldLocation)loc;
            return new FieldLocation(index, fieldNum, floc.getRow(), floc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions options, ToolOptions fieldOptions) {
        return new FunctionRepeatableCommentFieldFactory(formatModel, provider, (Options)options, (Options)fieldOptions);
    }
}

