/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CreateExternalFunctionCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.FunctionRenameOption;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledTemplate;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DemangledFunction
extends DemangledObject {
    public static final String VOLATILE = "volatile";
    public static final String CONST = "const";
    public static final String PTR64 = "__ptr64";
    public static final String UNALIGNED = "__unaligned";
    public static final String RESTRICT = "__restrict";
    private static final String STD_NAMESPACE = "std";
    private static final String THIS_CALL = "__thiscall";
    protected DemangledDataType returnType;
    protected String callingConvention;
    protected boolean thisPassedOnStack = true;
    protected List<DemangledDataType> parameters = new ArrayList<DemangledDataType>();
    protected DemangledTemplate template;
    protected boolean isOverloadedOperator = false;
    private String templatedConstructorType;
    private boolean isTrailingConst;
    private boolean isTrailingVolatile;
    private boolean isTrailingPointer64;
    private boolean isTrailingUnaligned;
    private boolean isTrailingRestrict;
    private boolean isTypeCast;
    private String throwAttribute;

    public DemangledFunction(String mangled, String originalDemangled, String name) {
        super(mangled, originalDemangled);
        this.setName(name);
    }

    public void setReturnType(DemangledDataType returnType) {
        this.returnType = returnType;
    }

    public void setCallingConvention(String callingConvention) {
        this.callingConvention = callingConvention;
    }

    public void setTemplate(DemangledTemplate template) {
        this.template = template;
    }

    public DemangledTemplate getTemplate() {
        return this.template;
    }

    public void setOverloadedOperator(boolean isOverloadedOperator) {
        this.isOverloadedOperator = isOverloadedOperator;
    }

    public void addParameter(DemangledDataType parameter) {
        this.parameters.add(parameter);
    }

    public List<DemangledDataType> getParameters() {
        return new ArrayList<DemangledDataType>(this.parameters);
    }

    public DemangledDataType getReturnType() {
        return this.returnType;
    }

    public String getCallingConvention() {
        return this.callingConvention;
    }

    public void setTemplatedConstructorType(String type) {
        this.templatedConstructorType = type;
    }

    public boolean isTrailingConst() {
        return this.isTrailingConst;
    }

    public void setTrailingConst() {
        this.isTrailingConst = true;
    }

    public boolean isTrailingVolatile() {
        return this.isTrailingVolatile;
    }

    public void setTrailingVolatile() {
        this.isTrailingVolatile = true;
    }

    public boolean isTrailingPointer64() {
        return this.isTrailingPointer64;
    }

    public void setTrailingPointer64() {
        this.isTrailingPointer64 = true;
    }

    public boolean isTrailingUnaligned() {
        return this.isTrailingUnaligned;
    }

    public void setTrailingUnaligned() {
        this.isTrailingUnaligned = true;
    }

    public boolean isTrailingRestrict() {
        return this.isTrailingRestrict;
    }

    public void setTrailingRestrict() {
        this.isTrailingRestrict = true;
    }

    public boolean isTypeCast() {
        return this.isTypeCast;
    }

    public void setTypeCast() {
        this.isTypeCast = true;
    }

    public void setThrowAttribute(String throwAttribute) {
        this.throwAttribute = throwAttribute;
    }

    @Override
    public String getSignature(boolean format) {
        StringBuilder buffer = new StringBuilder();
        if (!(this.returnType instanceof DemangledFunctionPointer)) {
            buffer.append((String)(this.specialPrefix == null ? "" : this.specialPrefix + " "));
            if (this.isThunk) {
                buffer.append("[thunk]:");
            }
            buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
            if (this.isVirtual) {
                buffer.append("virtual ");
            }
            if (this.isStatic) {
                buffer.append("static ");
            }
            if (!this.isTypeCast()) {
                buffer.append((String)(this.returnType == null ? "" : this.returnType.getSignature() + " "));
            }
        }
        buffer.append((String)(this.callingConvention == null ? "" : this.callingConvention + " "));
        if (this.namespace != null) {
            buffer.append(this.namespace.getNamespaceString());
            buffer.append("::");
        }
        buffer.append(this.getDemangledName());
        if (this.isTypeCast()) {
            buffer.append((String)(this.returnType == null ? "" : " " + this.returnType.getSignature() + " "));
        }
        if (this.template != null) {
            buffer.append(this.template.toTemplate());
        }
        if (this.templatedConstructorType != null) {
            buffer.append('<').append(this.templatedConstructorType).append('>');
        }
        this.addParameters(buffer, format);
        buffer.append((String)(this.storageClass == null ? "" : " " + this.storageClass));
        if (this.returnType instanceof DemangledFunctionPointer) {
            DemangledFunctionPointer funcPtr = (DemangledFunctionPointer)this.returnType;
            String partialSig = funcPtr.toSignature(buffer.toString());
            buffer = new StringBuilder();
            buffer.append((String)(this.specialPrefix == null ? "" : this.specialPrefix + " "));
            buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
            if (this.isVirtual) {
                buffer.append("virtual ");
            }
            buffer.append(partialSig);
        }
        if (this.isTrailingConst()) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(CONST);
        }
        if (this.isTrailingVolatile()) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(VOLATILE);
        }
        if (this.isTrailingUnaligned) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(UNALIGNED);
        }
        if (this.isTrailingPointer64) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(PTR64);
        }
        if (this.isTrailingRestrict) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(RESTRICT);
        }
        if (this.throwAttribute != null) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(this.throwAttribute);
        }
        return buffer.toString();
    }

    protected void addParameters(StringBuilder buffer, boolean format) {
        Iterator<DemangledDataType> paramIterator = this.parameters.iterator();
        buffer.append('(');
        int padLength = format ? buffer.length() : 0;
        String pad = StringUtils.rightPad((String)"", (int)padLength);
        if (!paramIterator.hasNext()) {
            buffer.append("void");
        }
        while (paramIterator.hasNext()) {
            buffer.append(paramIterator.next().getSignature());
            if (!paramIterator.hasNext()) continue;
            buffer.append(',');
            if (format) {
                buffer.append('\n');
            }
            buffer.append(pad);
        }
        buffer.append(')');
    }

    @Override
    public String getNamespaceName() {
        return this.getName() + this.getParameterString();
    }

    public String getParameterString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        Iterator<DemangledDataType> dditer = this.parameters.iterator();
        while (dditer.hasNext()) {
            buffer.append(dditer.next().getSignature());
            if (!dditer.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected boolean isAlreadyDemangled(Program program, Address address) {
        Function f = program.getListing().getFunctionAt(address);
        if (f != null && f.getSymbol().getSource() == SourceType.USER_DEFINED) {
            return true;
        }
        if (f == null || f.getSignatureSource() == SourceType.DEFAULT || f.getSignatureSource() == SourceType.ANALYSIS) {
            return false;
        }
        return super.isAlreadyDemangled(program, address);
    }

    private boolean shouldDisassemble(Program program, Address address, DemanglerOptions options) {
        if (!address.isMemoryAddress() || program.getMemory().isExternalBlockAddress(address)) {
            return false;
        }
        CodeUnit codeUnit = program.getListing().getCodeUnitAt(address);
        return codeUnit instanceof Data;
    }

    private boolean passesPreconditions(Program program, Address address) throws Exception {
        if (!this.demangledNameSuccessfully()) {
            throw new DemangledException("Symbol did not demangle at address: " + address);
        }
        if (this.isAlreadyDemangled(program, address)) {
            return false;
        }
        if (address.isMemoryAddress()) {
            CodeUnit codeUnit = program.getListing().getCodeUnitAt(address);
            if (codeUnit == null) {
                throw new IllegalArgumentException("Address not in memory or is off-cut data/instruction: " + address);
            }
            if (codeUnit instanceof Data && ((Data)codeUnit).isDefined()) {
                throw new IllegalArgumentException("Defined data at address: " + address);
            }
        }
        return true;
    }

    @Override
    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        if (address.isMemoryAddress()) {
            address = PseudoDisassembler.setTargetContextForDisassembly((Program)program, (Address)address);
        }
        if (!this.passesPreconditions(program, address)) {
            return true;
        }
        if (!super.applyTo(program, address, options, monitor)) {
            return false;
        }
        boolean disassemble = this.shouldDisassemble(program, address, options);
        Function function = this.createFunction(program, address, disassemble, monitor);
        if (function == null) {
            return false;
        }
        if (function.isThunk()) {
            if (this.shouldThunkBePreserved(function)) {
                function.getSymbol().setName(null, SourceType.DEFAULT);
                return true;
            }
            function.setThunkedFunction(null);
        }
        boolean makePrimary = function.getSignatureSource() != SourceType.USER_DEFINED;
        Symbol demangledSymbol = this.applyDemangledName(function.getEntryPoint(), makePrimary, false, program);
        if (demangledSymbol == null) {
            return false;
        }
        if (!options.applySignature() || function.getSignatureSource() == SourceType.USER_DEFINED) {
            return true;
        }
        Structure classStructure = this.maybeUpdateCallingConventionAndCreateClass(program, function, options);
        FunctionDefinitionDataType signature = new FunctionDefinitionDataType(function, true);
        List<ParameterDefinitionImpl> args = this.convertMangledToParamDef(program);
        signature.setArguments(args.toArray(new ParameterDefinition[args.size()]));
        if (this.hasVarArgs()) {
            signature.setVarArgs(true);
        }
        if (!function.isExternal() && this.isParameterMismatch(function, (FunctionSignature)signature)) {
            this.bookmarkParameterMismatch(program, function.getEntryPoint());
            return true;
        }
        DataType resolvedReturnType = this.resolveReturnType(program, function, classStructure);
        if (resolvedReturnType != null) {
            signature.setReturnType(resolvedReturnType);
        }
        ApplyFunctionSignatureCmd cmd = new ApplyFunctionSignatureCmd(function.getEntryPoint(), (FunctionSignature)signature, SourceType.IMPORTED, true, FunctionRenameOption.RENAME_IF_DEFAULT);
        cmd.applyTo((DomainObject)program);
        return true;
    }

    private boolean shouldThunkBePreserved(Function thunkFunction) {
        Program program = thunkFunction.getProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        if (thunkFunction.getSymbol().isExternalEntryPoint()) {
            return false;
        }
        Symbol[] symbols = symbolTable.getSymbols(thunkFunction.getEntryPoint());
        if (symbols.length > 1) {
            return false;
        }
        Function thunkedFunction = thunkFunction.getThunkedFunction(true);
        if (this.mangled.equals(thunkedFunction.getName())) {
            return true;
        }
        if (thunkedFunction.isExternal()) {
            if (thunkedFunction.getParentNamespace() instanceof Library) {
                return false;
            }
            ExternalLocation externalLocation = program.getExternalManager().getExternalLocation(thunkedFunction.getSymbol());
            String originalImportedName = externalLocation.getOriginalImportedName();
            if (originalImportedName == null) {
                return false;
            }
            return this.mangled.equals(externalLocation.getOriginalImportedName());
        }
        return symbolTable.getSymbol(this.mangled, thunkedFunction.getEntryPoint(), program.getGlobalNamespace()) != null;
    }

    private boolean hasVarArgs() {
        if (this.parameters.isEmpty()) {
            return false;
        }
        DemangledDataType lastType = this.parameters.get(this.parameters.size() - 1);
        return lastType.isVarArgs();
    }

    private boolean hasVoidParams() {
        if (this.parameters.size() == 1) {
            DemangledDataType ddt = this.parameters.get(0);
            return ddt.isVoid() && !ddt.isPointer();
        }
        return false;
    }

    private void bookmarkParameterMismatch(Program program, Address address) {
        if (this.parameters.isEmpty()) {
            return;
        }
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(address, "Analysis", "Demangler", "Couldn't apply demangled signature - mismatch with existing signature");
    }

    static void maybeCreateUndefined(Program program, Address address) {
        Listing listing = program.getListing();
        Instruction instruction = listing.getInstructionContaining(address);
        if (instruction != null) {
            return;
        }
        Data data = listing.getDefinedDataContaining(address);
        if (data != null) {
            return;
        }
        DataType demangledDT = Undefined.getUndefinedDataType((int)1);
        try {
            listing.createData(address, demangledDT);
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
            // empty catch block
        }
    }

    private DataType resolveReturnType(Program program, Function function, Structure classDataType) {
        if (this.returnType != null) {
            return this.returnType.getDataType((DataTypeManager)program.getDataTypeManager());
        }
        if (THIS_CALL.equals(function.getCallingConventionName())) {
            String n = this.getName();
            if (n.equals(this.namespace.getName())) {
                return DataType.DEFAULT;
            }
            if (n.equals("~" + this.namespace.getName())) {
                return VoidDataType.dataType;
            }
        }
        return null;
    }

    private Structure maybeUpdateCallingConventionAndCreateClass(Program program, Function function, DemanglerOptions options) {
        String convention = this.validateCallingConvention(program, function, options);
        if (convention == null) {
            if (!this.isThisCall(function)) {
                return null;
            }
            convention = THIS_CALL;
        }
        try {
            function.setCallingConvention(convention);
            return this.maybeCreateClassStructure(program, function, convention);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)"Unexpected exception setting calling convention", (Throwable)e);
            return null;
        }
    }

    private String validateCallingConvention(Program program, Function function, DemanglerOptions options) {
        if (!options.applyCallingConvention()) {
            return null;
        }
        if (this.callingConvention == null) {
            return null;
        }
        if (program.getCompilerSpec().getCallingConvention(this.callingConvention) == null) {
            BookmarkManager bm = program.getBookmarkManager();
            Address entry = function.getEntryPoint();
            bm.setBookmark(entry, "Analysis", "Demangler", "Could not apply calling convention \"" + this.callingConvention + "\" not defined in Compiler Spec (.cspec)");
            return null;
        }
        return this.callingConvention;
    }

    private List<ParameterDefinitionImpl> convertMangledToParamDef(Program program) {
        ArrayList<ParameterDefinitionImpl> args = new ArrayList<ParameterDefinitionImpl>();
        for (DemangledDataType param : this.parameters) {
            if (param.isVoid() && !param.isPointer() || param.isVarArgs()) break;
            DataType dt = param.getDataType((DataTypeManager)program.getDataTypeManager());
            args.add(new ParameterDefinitionImpl(null, dt, null));
        }
        return args;
    }

    private boolean isParameterMismatch(Function func, FunctionSignature signature) {
        if (func.getSignatureSource() == SourceType.DEFAULT) {
            return false;
        }
        int existingParameterCount = func.getParameterCount();
        String callingConventionName = func.getCallingConventionName();
        if (existingParameterCount == 0 && THIS_CALL.equals(callingConventionName)) {
            return false;
        }
        if (this.isDefinedFunctionDataTypes(func)) {
            return true;
        }
        if (this.namespace == null || this.namespace.getName().startsWith("__")) {
            return false;
        }
        int mangledParamterCount = this.parameters.size();
        if (this.hasVoidParams()) {
            mangledParamterCount = 0;
        }
        boolean hasVarArgs = false;
        if (mangledParamterCount != 0 && (hasVarArgs = this.hasVarArgs())) {
            --mangledParamterCount;
        }
        if (hasVarArgs != func.hasVarArgs()) {
            return true;
        }
        if (existingParameterCount == 0 && mangledParamterCount > 0) {
            if (this.isOverloadedOperator && this.parameters.size() <= 2) {
                return false;
            }
            PrototypeModel[] specs = func.getProgram().getCompilerSpec().getCallingConventions();
            return specs != null && specs.length != 1;
        }
        return false;
    }

    protected boolean isDefinedFunctionDataTypes(Function func) {
        Parameter[] funcParams;
        for (Parameter parameter : funcParams = func.getParameters()) {
            if (parameter.isAutoParameter()) continue;
            DataType dt = parameter.getDataType();
            if ((dt = DataTypeUtilities.getBaseDataType((DataType)dt)) == null || Undefined.isUndefined((DataType)dt) || !parameter.getSource().isHigherPriorityThan(SourceType.ANALYSIS)) continue;
            return true;
        }
        DataType returnDT = func.getReturnType();
        return (returnDT = DataTypeUtilities.getBaseDataType((DataType)returnDT)) != null && !Undefined.isUndefined((DataType)returnDT) && this.getReturnType() != null;
    }

    private boolean isThisCall(Function func) {
        Function newfunc;
        if (this.namespace == null || StringUtils.isBlank((CharSequence)this.namespace.getName())) {
            return false;
        }
        if (this.isInStdNameSpace()) {
            return false;
        }
        int mangledParameterCount = this.parameters.size();
        if (this.isOverloadedOperator && mangledParameterCount <= 1) {
            return true;
        }
        if (this.isOverloadedOperator && mangledParameterCount == 2) {
            return false;
        }
        String n = this.getName();
        if (n.startsWith("~")) {
            return true;
        }
        if (n.startsWith(this.namespace.getName())) {
            return true;
        }
        Program program = func.getProgram();
        Data data = program.getListing().getDefinedDataAt(func.getEntryPoint());
        if (data != null && data.getAddress(0) != null && (newfunc = program.getFunctionManager().getFunctionAt(data.getAddress(0))) != null) {
            if (THIS_CALL.equals(newfunc.getCallingConventionName())) {
                return true;
            }
            func = newfunc;
        }
        return func.getParameterCount() == mangledParameterCount + 1;
    }

    private boolean isInStdNameSpace() {
        Demangled ns = this.namespace;
        if (ns == null) {
            return false;
        }
        return ns.getName().equalsIgnoreCase(STD_NAMESPACE);
    }

    protected Structure maybeCreateClassStructure(Program program, Function function, String convention) {
        if (!THIS_CALL.equals(convention)) {
            return null;
        }
        if (this.namespace == null) {
            return null;
        }
        String className = this.namespace.getName();
        Symbol parentSymbol = function.getSymbol().getParentSymbol();
        if (parentSymbol.getSymbolType() == SymbolType.NAMESPACE) {
            try {
                NamespaceUtils.convertNamespaceToClass((Namespace)((Namespace)parentSymbol.getObject()));
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
        }
        Demangled classNamespace = this.namespace.getNamespace();
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        DataType existingType = DemangledDataType.findDataType((DataTypeManager)dataTypeManager, classNamespace, className);
        if (existingType != null && !(existingType instanceof Structure)) {
            BookmarkManager bm = program.getBookmarkManager();
            Address entry = function.getEntryPoint();
            bm.setBookmark(entry, "Analysis", "Demangler", "Could not create class structure, data type already exists: " + existingType);
            return null;
        }
        Structure structure = (Structure)existingType;
        if (structure == null) {
            structure = DemangledDataType.createPlaceHolderStructure(className, classNamespace);
        }
        structure = (Structure)dataTypeManager.resolve((DataType)structure, DataTypeConflictHandler.DEFAULT_HANDLER);
        return structure;
    }

    protected Function createFunction(Program prog, Address addr, boolean doDisassembly, TaskMonitor monitor) throws DemangledException {
        Listing listing = prog.getListing();
        Function func = listing.getFunctionAt(addr);
        if (func != null) {
            return func;
        }
        if (addr.isExternalAddress()) {
            Symbol extSymbol = prog.getSymbolTable().getPrimarySymbol(addr);
            CreateExternalFunctionCmd cmd = new CreateExternalFunctionCmd(extSymbol);
            if (!cmd.applyTo((DomainObject)prog)) {
                throw new DemangledException("Unable to create function: " + cmd.getStatusMsg());
            }
        } else {
            CreateFunctionCmd cmd;
            AddressSetView execSet;
            if (doDisassembly && (execSet = prog.getMemory().getExecuteSet()).contains(addr)) {
                DisassembleCommand cmd2 = new DisassembleCommand(addr, null, true);
                cmd2.applyTo((DomainObject)prog, monitor);
            }
            if (!(cmd = new CreateFunctionCmd(addr)).applyTo((DomainObject)prog, monitor)) {
                throw new DemangledException("Unable to create function: " + cmd.getStatusMsg());
            }
        }
        return listing.getFunctionAt(addr);
    }
}

