/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeMarkupable;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CliAbstractTable
implements StructConverter,
PeMarkupable {
    public static final String PATH = "/PE/CLI/Metadata/Tables";
    protected long readerOffset;
    protected CliTypeTable tableType;
    protected int numRows;
    protected ArrayList<CliAbstractTableRow> rows;
    protected CliStreamMetadata metadataStream;
    protected List<Integer> strings = new ArrayList<Integer>();
    protected List<Integer> blobs = new ArrayList<Integer>();
    protected List<Integer> userStrings = new ArrayList<Integer>();

    public CliAbstractTable(BinaryReader reader, CliStreamMetadata metadataStream, CliTypeTable tableType) {
        this.readerOffset = reader.getPointerIndex();
        this.metadataStream = metadataStream;
        this.tableType = tableType;
        this.numRows = metadataStream.getNumberRowsForTable(tableType);
        this.rows = new ArrayList(this.numRows);
    }

    public CliTypeTable getTableType() {
        return this.tableType;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getRowSize() {
        return this.getRowDataType().getLength();
    }

    public int getTableSize() {
        return this.getRowSize() * this.getNumRows();
    }

    public CliAbstractTableRow getRow(int rowIndex) throws IndexOutOfBoundsException {
        return this.rows.get(rowIndex - 1);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException, MemoryAccessException {
    }

    public abstract DataType getRowDataType();

    @Override
    public DataType toDataType() {
        DataType rowDt = this.getRowDataType();
        int count = this.numRows == 0 ? 1 : this.numRows;
        ArrayDataType array = new ArrayDataType(rowDt, count, rowDt.getLength());
        try {
            array.setCategoryPath(new CategoryPath(PATH));
        }
        catch (DuplicateNameException e) {
            Msg.warn((Object)this, (Object)"Duplication category path: /PE/CLI/Metadata/Tables");
        }
        return array;
    }

    public String toString() {
        return this.tableType.toString();
    }

    protected int readBlobIndex(BinaryReader reader) throws IOException {
        return this.metadataStream.getBlobIndexDataType() == DWordDataType.dataType ? reader.readNextInt() : reader.readNextShort() & 0xFFFF;
    }

    protected int readStringIndex(BinaryReader reader) throws IOException {
        return this.metadataStream.getStringIndexDataType() == DWordDataType.dataType ? reader.readNextInt() : reader.readNextShort() & 0xFFFF;
    }

    protected int readGuidIndex(BinaryReader reader) throws IOException {
        return this.metadataStream.getGuidIndexDataType() == DWordDataType.dataType ? reader.readNextInt() : reader.readNextShort() & 0xFFFF;
    }

    protected int readTableIndex(BinaryReader reader, CliTypeTable table) throws IOException {
        return this.metadataStream.getTableIndexDataType(table) == DWordDataType.dataType ? reader.readNextInt() : reader.readNextShort() & 0xFFFF;
    }

    protected String getRowRepresentationSafe(CliTypeTable table, int index) {
        return this.metadataStream.getTable(table).getRow(index).getRepresentation();
    }

    protected String getRowShortRepSafe(CliTypeTable otherTable, int index) {
        return this.metadataStream.getTable(otherTable).getRow(index).getShortRepresentation();
    }
}

