/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfComdatExternalSymbol
extends OmfExternalSymbol {
    protected List<ExternalLookup> externalLookups = new ArrayList<ExternalLookup>();

    public OmfComdatExternalSymbol(BinaryReader reader) throws IOException {
        super(false);
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        while (reader.getPointerIndex() < max) {
            int nameIndex = OmfRecord.readIndex(reader);
            int type = OmfRecord.readIndex(reader);
            this.externalLookups.add(new ExternalLookup(nameIndex, type));
        }
        this.readCheckSumByte(reader);
    }

    public void loadNames(List<String> nameList) {
        for (ExternalLookup ext : this.externalLookups) {
            String name = nameList.get(ext.nameIndex - 1);
            this.symbols.add(new OmfSymbol(name, ext.type, 0L, 0, 0));
        }
    }

    public record ExternalLookup(int nameIndex, int type) {
    }
}

