/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo4
extends DyldCacheSlideInfoCommon {
    private static final int DYLD_CACHE_SLIDE4_PAGE_NO_REBASE = 65535;
    private static final int DYLD_CACHE_SLIDE4_PAGE_INDEX = Short.MAX_VALUE;
    private static final int DYLD_CACHE_SLIDE4_PAGE_USE_EXTRA = 32768;
    private static final int DYLD_CACHE_SLIDE4_PAGE_EXTRA_END = 32768;
    private static final int HEADERSIZE4 = 40;
    private int page_size;
    private int page_starts_offset;
    private int page_starts_count;
    private int page_extras_offset;
    private int page_extras_count;
    private long delta_mask;
    private long value_add;
    private short[] page_starts;
    private short[] page_extras;

    public int getPageSize() {
        return this.page_size;
    }

    public int getPageStartsOffset() {
        return this.page_starts_offset;
    }

    public int getPageStartsCount() {
        return this.page_starts_count;
    }

    public int getPageExtrasOffset() {
        return this.page_extras_offset;
    }

    public int getPageExtrasCount() {
        return this.page_extras_count;
    }

    public long getDeltaMask() {
        return this.delta_mask;
    }

    public long getValueAdd() {
        return this.value_add;
    }

    public short[] getPageStarts() {
        return this.page_starts;
    }

    public short[] getPageExtras() {
        return this.page_extras;
    }

    public DyldCacheSlideInfo4(BinaryReader reader) throws IOException {
        super(reader);
        this.page_size = reader.readNextInt();
        this.page_starts_offset = reader.readNextInt();
        this.page_starts_count = reader.readNextInt();
        this.page_extras_offset = reader.readNextInt();
        this.page_extras_count = reader.readNextInt();
        this.delta_mask = reader.readNextLong();
        this.value_add = reader.readNextLong();
        reader.setPointerIndex(this.page_starts_offset);
        this.page_starts = reader.readNextShortArray(this.page_starts_count);
        reader.setPointerIndex(this.page_extras_offset);
        this.page_extras = reader.readNextShortArray(this.page_extras_count);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info4", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "page_size", "");
        struct.add(DWORD, "page_starts_offset", "");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "page_extras_offset", "");
        struct.add(DWORD, "page_extras_count", "");
        struct.add(QWORD, "delta_mask", "");
        struct.add(QWORD, "value_add", "");
        if (this.page_starts_offset == 40) {
            struct.add((DataType)new ArrayDataType(WORD, this.page_starts_count, 1), "page_starts", "");
        }
        if (this.page_extras_offset == 40 + this.page_starts_count * 2) {
            struct.add((DataType)new ArrayDataType(WORD, this.page_extras_count, 1), "page_extras", "");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public void fixPageChains(Program program, DyldCacheHeader dyldCacheHeader, boolean addRelocations, MessageLog log, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        long fixedAddressCount = 0L;
        List<DyldCacheMappingInfo> mappingInfos = dyldCacheHeader.getMappingInfos();
        DyldCacheMappingInfo dyldCacheMappingInfo = mappingInfos.get(1);
        long dataPageStart = dyldCacheMappingInfo.getAddress();
        long pageSize = this.getPageSize();
        long pageStartsCount = this.getPageStartsCount();
        long deltaMask = this.getDeltaMask();
        long deltaShift = Long.numberOfTrailingZeros(deltaMask);
        long valueAdd = this.getValueAdd();
        short[] pageEntries = this.getPageStarts();
        short[] extraEntries = this.getPageExtras();
        monitor.setMessage("Fixing V4 chained data page pointers...");
        monitor.setMaximum(pageStartsCount);
        int index = 0;
        while ((long)index < pageStartsCount) {
            monitor.checkCancelled();
            long page = dataPageStart + pageSize * (long)index;
            monitor.setProgress((long)index);
            int pageEntry = pageEntries[index] & 0xFFFF;
            if (pageEntry != 65535) {
                List<Object> unchainedLocList;
                if ((pageEntry & 0x8000) != 0) {
                    int extraIndex = pageEntry & 0x3FFF;
                    unchainedLocList = new ArrayList(1024);
                    do {
                        pageEntry = extraEntries[extraIndex] & 0xFFFF;
                        long pageOffset = (pageEntry & 0x3FFF) * 4;
                        List<Address> subLocList = this.processPointerChain4(program, page, pageOffset, deltaMask, deltaShift, valueAdd, addRelocations, monitor);
                        unchainedLocList.addAll(subLocList);
                        ++extraIndex;
                    } while ((pageEntry & 0x8000) == 0);
                } else {
                    long pageOffset = pageEntry * 4;
                    unchainedLocList = this.processPointerChain4(program, page, pageOffset, deltaMask, deltaShift, valueAdd, addRelocations, monitor);
                }
                fixedAddressCount += (long)unchainedLocList.size();
                this.createChainPointers(program, unchainedLocList, monitor);
            }
            ++index;
        }
        log.appendMsg("Fixed " + fixedAddressCount + " chained pointers.");
    }

    private List<Address> processPointerChain4(Program program, long page, long nextOff, long deltaMask, long deltaShift, long valueAdd, boolean addRelocations, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Address chainStart = program.getLanguage().getDefaultSpace().getAddress(page);
        Memory memory = program.getMemory();
        ArrayList<Address> unchainedLocList = new ArrayList<Address>(1024);
        int valueMask = -1 >>> (int)(32L - deltaShift);
        long delta = -1L;
        while (delta != 0L) {
            monitor.checkCancelled();
            Address chainLoc = chainStart.add(nextOff);
            int chainValue = memory.getInt(chainLoc);
            delta = ((long)chainValue & deltaMask) >> (int)deltaShift;
            if (((chainValue &= valueMask) & Short.MIN_VALUE) != 0) {
                chainValue = (chainValue & 0x3FFF8000) == 1073709056 ? (chainValue |= 0xC0000000) : (int)((long)chainValue + valueAdd);
            }
            if (addRelocations) {
                this.addRelocationTableEntry(program, chainLoc, 4, chainValue, 4, null);
            }
            memory.setInt(chainLoc, chainValue);
            unchainedLocList.add(chainLoc);
            nextOff += delta * 4L;
        }
        return unchainedLocList;
    }
}

