/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName="runtime.slicetype")
public class GoSliceType
extends GoType {
    @FieldMapping
    @MarkupReference(value="element")
    private long elem;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        int arrayPtrComponentIndex = 0;
        Structure genericSliceDT = this.programContext.getGenericSliceDT();
        DataTypeComponent arrayDTC = genericSliceDT.getComponent(arrayPtrComponentIndex);
        GoType elementType = this.getElement();
        DataType elementDT = elementType.recoverDataType();
        Pointer elementPtrDT = this.programContext.getDTM().getPointer(elementDT);
        StructureDataType sliceDT = new StructureDataType(this.programContext.getRecoveredTypesCp(), this.typ.getNameString(), 0, this.programContext.getDTM());
        sliceDT.replaceWith((DataType)genericSliceDT);
        sliceDT.replace(arrayPtrComponentIndex, (DataType)elementPtrDT, -1, arrayDTC.getFieldName(), arrayDTC.getComment());
        return sliceDT;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType elementType = this.getElement();
        if (elementType != null) {
            elementType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

