/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@StructureMapping(structureName="runtime.slice")
public class GoSlice {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoSlice> context;
    @FieldMapping
    private long array;
    @FieldMapping
    private long len;
    @FieldMapping
    private long cap;

    public GoSlice() {
    }

    public GoSlice(long array, long len, long cap) {
        this.array = array;
        this.len = len;
        this.cap = cap;
    }

    public GoSlice(long array, long len, long cap, GoRttiMapper programContext) {
        this(array, len, cap);
        this.programContext = programContext;
    }

    public GoSlice getSubSlice(long startElement, long elementCount, long elementSize) {
        return new GoSlice(this.array + startElement * elementSize, elementCount, elementCount, this.programContext);
    }

    public boolean isValid(int elementSize) {
        try {
            Memory memory = this.programContext.getProgram().getMemory();
            Address arrayAddr = this.getArrayAddress();
            return memory.contains(arrayAddr) && memory.contains(arrayAddr.addNoWrap(this.len * (long)elementSize));
        }
        catch (AddressOutOfBoundsException | AddressOverflowException e) {
            return false;
        }
    }

    public long getArrayOffset() {
        return this.array;
    }

    public Address getArrayAddress() {
        return this.programContext.getDataAddress(this.array);
    }

    public long getLen() {
        return this.len;
    }

    public long getCap() {
        return this.cap;
    }

    public boolean isFull() {
        return this.len == this.cap;
    }

    public boolean isOffsetWithinData(long offset, int sizeofElement) {
        return this.array <= offset && offset < this.array + this.cap * (long)sizeofElement;
    }

    public <T> List<T> readList(Class<T> clazz) throws IOException {
        return this.readList((BinaryReader reader) -> this.programContext.readStructure(clazz, reader));
    }

    public <T> List<T> readList(BinaryReader.ReaderFunction<T> readFunc) throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        long elementSize = 0L;
        BinaryReader reader = this.programContext.getReader(this.array);
        int i = 0;
        while ((long)i < this.len) {
            T t = readFunc.get(reader);
            result.add(t);
            if (i == 0) {
                elementSize = reader.getPointerIndex() - this.array;
            } else if (elementSize > 0L && reader.getPointerIndex() != this.array + (long)(i + 1) * elementSize) {
                Msg.warn((Object)this, (Object)"Bad element size when reading slice element (size: %d) at %d".formatted(elementSize, reader.getPointerIndex()));
                elementSize = 0L;
            }
            ++i;
        }
        return result;
    }

    public long[] readUIntList(int intSize) throws IOException {
        BinaryReader reader = this.programContext.getReader(this.array);
        return GoSlice.readUIntList(reader, this.array, intSize, (int)this.len);
    }

    public void markupArray(String sliceName, Class<?> elementClazz, boolean ptr) throws IOException {
        Structure dt = this.programContext.getStructureDataType(elementClazz);
        this.markupArray(sliceName, (DataType)dt, ptr);
    }

    public void markupArray(String sliceName, DataType elementType, boolean ptr) throws IOException {
        if (this.len == 0L) {
            return;
        }
        DataTypeManager dtm = this.programContext.getDTM();
        if (ptr) {
            elementType = new PointerDataType(elementType, this.programContext.getPtrSize(), dtm);
        }
        ArrayDataType arrayDT = new ArrayDataType(elementType, (int)this.cap, -1, dtm);
        Address addr = this.programContext.getDataAddress(this.array);
        this.programContext.markupAddress(addr, (DataType)arrayDT);
        if (sliceName != null) {
            this.programContext.labelAddress(addr, sliceName);
        }
    }

    public <T> List<T> markupArrayElements(Class<T> clazz) throws IOException {
        if (this.len == 0L) {
            return List.of();
        }
        List<T> elementList = this.readList(clazz);
        this.programContext.markup(elementList, true);
        return elementList;
    }

    public void markupElementReferences(int elementSize, List<Address> targetAddrs) throws IOException {
        if (!targetAddrs.isEmpty()) {
            ReferenceManager refMgr = this.programContext.getProgram().getReferenceManager();
            Address srcAddr = this.programContext.getDataAddress(this.array);
            for (Address targetAddr : targetAddrs) {
                if (targetAddr != null) {
                    refMgr.addMemoryReference(srcAddr, targetAddr, RefType.DATA, SourceType.IMPORTED, 0);
                }
                srcAddr = srcAddr.add((long)elementSize);
            }
        }
    }

    private static long[] readUIntList(BinaryReader reader, long index, int intSize, int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            long l;
            result[i] = l = reader.readUnsignedValue(index, intSize);
            index += (long)intSize;
        }
        return result;
    }
}

