/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PEGoBuildId
implements ElfInfoItem {
    private static final byte[] GO_BUILDID_MAGIC = "\u00ff Go build ID: \"".getBytes(StandardCharsets.ISO_8859_1);
    private static final int BUILDID_STR_LEN = 83;
    private final String buildId;

    public static ElfInfoItem.ItemWithAddress<PEGoBuildId> findBuildId(Program program) {
        ElfInfoItem.ItemWithAddress<PEGoBuildId> wrappedItem = ElfInfoItem.readItemFromSection(program, ".text", PEGoBuildId::read);
        return wrappedItem;
    }

    public static PEGoBuildId read(BinaryReader br, Program program_notused) {
        try {
            byte[] magic = br.readNextByteArray(GO_BUILDID_MAGIC.length);
            if (!Arrays.equals(magic, GO_BUILDID_MAGIC)) {
                return null;
            }
            String buildIdStr = br.readNextAsciiString(83);
            return new PEGoBuildId(buildIdStr);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static PEGoBuildId read(InputStream is) {
        byte[] buffer = new byte[GO_BUILDID_MAGIC.length + 83];
        try {
            int bytesRead = is.read(buffer);
            if (bytesRead == buffer.length) {
                ByteArrayProvider bap = new ByteArrayProvider(buffer);
                return PEGoBuildId.read(new BinaryReader(bap, false), null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public PEGoBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    @Override
    public void markupProgram(Program program, Address address) {
        program.getOptions("Program Information").setString("Golang BuildId", this.getBuildId());
        try {
            StructureDataType struct = this.toStructure((DataTypeManager)program.getDataTypeManager());
            if (struct != null) {
                DataUtilities.createData((Program)program, (Address)address, (DataType)struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Failed to markup PEGoBuildId at %s: %s".formatted(address, this));
        }
    }

    private StructureDataType toStructure(DataTypeManager dtm) {
        StructureDataType result = new StructureDataType(GoConstants.GOLANG_CATEGORYPATH, "GoBuildId", 0, dtm);
        result.add((DataType)StringDataType.dataType, GO_BUILDID_MAGIC.length, "magic", null);
        result.add((DataType)StringDataType.dataType, 83, "buildId", null);
        return result;
    }
}

