/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class DWARFDataInstanceHelper {
    private Program program;
    private Listing listing;

    public DWARFDataInstanceHelper(Program program) {
        this.program = program;
        this.listing = program.getListing();
    }

    private boolean isArrayDataTypeCompatibleWithExistingData(Array arrayDT, Data existingData) {
        DataType existingElementDT;
        DataType existingDataDT = existingData.getBaseDataType();
        if (existingDataDT.isEquivalent((DataType)arrayDT)) {
            return true;
        }
        DataType elementDT = arrayDT.getDataType();
        if (elementDT instanceof TypeDef) {
            TypeDef typedef = (TypeDef)elementDT;
            elementDT = typedef.getBaseDataType();
        }
        if (existingDataDT instanceof Array) {
            Array existingArrayDT = (Array)existingDataDT;
            v0 = existingArrayDT.getDataType();
        } else {
            v0 = existingElementDT = null;
        }
        if (elementDT instanceof CharDataType && existingDataDT instanceof StringDataType) {
            existingElementDT = elementDT;
        }
        if (existingElementDT instanceof TypeDef) {
            TypeDef typedef = (TypeDef)existingElementDT;
            existingElementDT = typedef.getBaseDataType();
        }
        if (existingDataDT instanceof Array || existingDataDT instanceof StringDataType) {
            if (!existingElementDT.isEquivalent(elementDT)) {
                return false;
            }
            if (arrayDT.getLength() <= existingData.getLength()) {
                return true;
            }
            return this.hasTrailingUndefined(existingData, (DataType)arrayDT);
        }
        Address address = existingData.getAddress();
        for (int i = 0; i < arrayDT.getNumElements(); ++i) {
            Address elementAddress = address.add((long)(arrayDT.getElementLength() * i));
            Data data = this.listing.getDataAt(elementAddress);
            if (data == null || this.isDataTypeCompatibleWithExistingData(elementDT, data)) continue;
            return false;
        }
        return true;
    }

    private boolean hasTrailingUndefined(Data data, DataType replacementDT) {
        Address address = data.getAddress();
        return DataUtilities.isUndefinedRange((Program)this.program, (Address)address.add((long)data.getLength()), (Address)address.add((long)(replacementDT.getLength() - 1)));
    }

    private boolean isStructDataTypeCompatibleWithExistingData(Structure structDT, Data existingData) {
        DataType existingDataDT = existingData.getBaseDataType();
        if (existingDataDT instanceof Structure) {
            return existingDataDT.isEquivalent((DataType)structDT);
        }
        Address address = existingData.getAddress();
        for (DataTypeComponent dtc : structDT.getDefinedComponents()) {
            Address memberAddress = address.add((long)dtc.getOffset());
            Data data = this.listing.getDataAt(memberAddress);
            if (data == null || this.isDataTypeCompatibleWithExistingData(dtc.getDataType(), data)) continue;
            return false;
        }
        return true;
    }

    private boolean isPointerDataTypeCompatibleWithExistingData(Pointer pdt, Data existingData) {
        DataType existingDT = existingData.getBaseDataType();
        boolean isRightType = existingDT instanceof Pointer || existingDT instanceof AbstractIntegerDataType;
        return isRightType && existingDT.getLength() == pdt.getLength();
    }

    private boolean isSimpleDataTypeCompatibleWithExistingData(DataType simpleDT, Data existingData) {
        DataType existingDT = existingData.getBaseDataType();
        if (simpleDT instanceof CharDataType && existingDT instanceof StringDataType) {
            return true;
        }
        if (!simpleDT.getClass().isInstance(existingDT)) {
            return false;
        }
        int dataTypeLen = simpleDT.getLength();
        return dataTypeLen <= 0 || dataTypeLen == existingData.getLength();
    }

    private boolean isEnumDataTypeCompatibleWithExistingData(Enum enumDT, Data existingData) {
        DataType existingDT = existingData.getBaseDataType();
        if (!(existingDT instanceof Enum) && !(existingDT instanceof AbstractIntegerDataType)) {
            return false;
        }
        if (existingDT instanceof BooleanDataType) {
            return false;
        }
        return existingDT.getLength() == enumDT.getLength();
    }

    private boolean isDataTypeCompatibleWithExistingData(DataType dataType, Data existingData) {
        if (existingData == null || !existingData.isDefined()) {
            return true;
        }
        if (dataType instanceof Array) {
            return this.isArrayDataTypeCompatibleWithExistingData((Array)dataType, existingData);
        }
        if (dataType instanceof Pointer) {
            return this.isPointerDataTypeCompatibleWithExistingData((Pointer)dataType, existingData);
        }
        if (dataType instanceof Structure) {
            return this.isStructDataTypeCompatibleWithExistingData((Structure)dataType, existingData);
        }
        if (dataType instanceof TypeDef) {
            return this.isDataTypeCompatibleWithExistingData(((TypeDef)dataType).getBaseDataType(), existingData);
        }
        if (dataType instanceof Enum) {
            return this.isEnumDataTypeCompatibleWithExistingData((Enum)dataType, existingData);
        }
        if (dataType instanceof AbstractIntegerDataType || dataType instanceof AbstractFloatDataType || dataType instanceof StringDataType || dataType instanceof WideCharDataType || dataType instanceof WideChar16DataType || dataType instanceof WideChar32DataType) {
            return this.isSimpleDataTypeCompatibleWithExistingData(dataType, existingData);
        }
        return false;
    }

    public boolean isDataTypeCompatibleWithAddress(DataType dataType, Address address) {
        if (DataUtilities.isUndefinedRange((Program)this.program, (Address)address, (Address)address.add((long)(dataType.getLength() - 1)))) {
            return true;
        }
        Data data = this.listing.getDataAt(address);
        return data == null || this.isDataTypeCompatibleWithExistingData(dataType, data);
    }
}

