/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.funcfixup;

import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.program.model.listing.Function;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=999)
public class StorageVerificationDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc, Function gfunc) {
        boolean storageIsGood = true;
        for (DWARFVariable param : dfunc.params) {
            if (param.isMissingStorage() && !param.isZeroByte()) {
                storageIsGood = false;
                break;
            }
            if (param.isLocationValidOnEntry()) continue;
            storageIsGood = false;
            break;
        }
        if (!storageIsGood) {
            dfunc.signatureCommitMode = DWARFFunction.CommitMode.FORMAL;
        }
    }
}

