/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.funcfixup;

import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.program.model.listing.Function;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=2000)
public class SanityCheckDWARFFunctionFixup
implements DWARFFunctionFixup,
DWARFAttributeValue {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc, Function gfunc) throws DWARFException {
        if (dfunc.params.isEmpty() && dfunc.localVarErrors) {
            Msg.error((Object)this, (Object)String.format("Inconsistent function signature information, leaving undefined: %s@%s", gfunc.getName(), gfunc.getEntryPoint()));
            throw new DWARFException("Failed sanity check");
        }
    }
}

