/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import ghidra.app.plugin.core.searchmem.SearchData;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExSearchData
extends SearchData {
    private Pattern pattern;

    public static RegExSearchData createRegExSearchData(String inputString) {
        RegExSearchData regExSearchData = new RegExSearchData(inputString);
        if (regExSearchData.errorMessage != null) {
            throw new IllegalArgumentException("Problem creating search data: " + regExSearchData.errorMessage);
        }
        return regExSearchData;
    }

    public RegExSearchData(String inputString) {
        super(inputString, new byte[0], null);
        try {
            this.pattern = Pattern.compile(inputString, 32);
        }
        catch (PatternSyntaxException pse) {
            this.errorMessage = pse.getMessage();
        }
    }

    @Override
    public boolean isValidSearchData() {
        return this.pattern != null;
    }

    public Pattern getRegExPattern() {
        return this.pattern;
    }
}

