/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.actions.KeyBindingUtils;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.Gui;
import generic.util.WindowUtilities;
import ghidra.app.plugin.core.progmgr.MultiTabPlugin;
import ghidra.app.plugin.core.progmgr.ProgramListPanel;
import ghidra.framework.model.ProjectLocator;
import ghidra.program.model.listing.Program;
import ghidra.util.layout.HorizontalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import resources.Icons;

public class MultiTabPanel
extends JPanel {
    private static final String FONT_TABS_ID = "font.plugin.tabs";
    private static final String FONT_TABS_LIST_ID = "font.plugin.tabs.list";
    private static final Color SELECTED_TAB_COLOR = new GColor("color.bg.listing.tabs.selected");
    private static final Color HIGHLIGHTED_TAB_BG_COLOR = new GColor("color.bg.listing.tabs.highlighted");
    private static final Icon EMPTY16_ICON = Icons.EMPTY_ICON;
    private static final Icon EMPTY8_ICON = new GIcon("icon.plugin.programmanager.empty.small");
    private static final Icon CLOSE_ICON = new GIcon("icon.plugin.programmanager.close");
    private static final Icon HIGHLIGHT_CLOSE_ICON = new GIcon("icon.plugin.programmanager.close.highlight");
    private static final Icon LIST_ICON = new GIcon("icon.plugin.programmanager.list");
    private static final Icon TRANSIENT_ICON = new GIcon("icon.plugin.programmanager.transient");
    private static final Color TEXT_SELECTION_COLOR = new GColor("color.fg.listing.tabs.text.selected");
    private static final Color TEXT_NON_SELECTION_COLOR = new GColor("color.fg.listing.tabs.text.unselected");
    private static final Color BG_SELECTION_COLOR = SELECTED_TAB_COLOR;
    private static final Color BG_NON_SELECTION_COLOR = new GColor("color.bg.listing.tabs.unselected");
    private static final Color BG_COLOR_MORE_TABS_HOVER = new GColor("color.bg.listing.tabs.more.tabs.hover");
    private static final String DEFAULT_HIDDEN_COUNT_STR = "99";
    private List<TabPanel> hiddenTabList;
    private List<TabPanel> visibleTabList;
    private Map<Program, TabPanel> linkedProgramMap;
    private Program currentProgram;
    private Program highlightedProgram;
    private MultiTabPlugin multiTabPlugin;
    private ProgramListPanel programListPanel;
    private Border defaultListLabelBorder;
    private JLabel showHiddenListLabel;
    private JDialog listWindow;
    private JTextField filterField;
    private boolean ignoreFocus;

    MultiTabPanel(MultiTabPlugin multiTabPlugin) {
        this.multiTabPlugin = multiTabPlugin;
        this.setLayout((LayoutManager)new HorizontalLayout(0));
        this.linkedProgramMap = new LinkedHashMap<Program, TabPanel>();
        this.hiddenTabList = new ArrayList<TabPanel>();
        this.visibleTabList = new ArrayList<TabPanel>();
        MatteBorder outerBorder = new MatteBorder(0, 0, 3, 0, SELECTED_TAB_COLOR);
        BottomOnlyBevelBorder innerBorder = new BottomOnlyBevelBorder();
        this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        this.showHiddenListLabel = this.createLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MultiTabPanel.this.hideListWindow();
                MultiTabPanel.this.packTabs(MultiTabPanel.this.currentProgram);
            }
        });
        this.setMinimumSize(new Dimension(30, 20));
    }

    void addProgram(Program program) {
        if (this.linkedProgramMap.containsKey(program)) {
            return;
        }
        TabPanel panel = this.createProgramTab(program, false);
        this.add(panel);
        this.packTabs(this.currentProgram);
    }

    @Override
    public void removeAll() {
        this.currentProgram = null;
        ArrayList<Program> list = new ArrayList<Program>(this.linkedProgramMap.keySet());
        for (Program element : list) {
            this.doRemoveProgram(element);
        }
        this.linkedProgramMap.clear();
        this.visibleTabList.clear();
        this.hiddenTabList.clear();
        this.hideListWindow();
    }

    Program getSelectedProgram() {
        return this.currentProgram;
    }

    void refresh(Program program) {
        TabPanel panel = this.linkedProgramMap.get(program);
        if (panel == null) {
            return;
        }
        panel.refresh();
        this.packTabs(this.currentProgram);
    }

    void setSelectedProgram(Program program) {
        if (this.currentProgram == program || !this.linkedProgramMap.containsKey(program)) {
            return;
        }
        TabPanel panel = this.linkedProgramMap.get(program);
        panel = this.createProgramTab(program, true);
        this.linkedProgramMap.put(program, panel);
        this.clearSelectedProgram();
        this.currentProgram = program;
        this.setTabVisible(program);
        this.repaint();
        this.multiTabPlugin.programSelected(this.currentProgram);
    }

    int getTabCount() {
        return this.linkedProgramMap.size();
    }

    boolean containsProgram(Program program) {
        return this.linkedProgramMap.get(program) != null;
    }

    int getVisibleTabCount() {
        return this.visibleTabList.size();
    }

    int getHiddenCount() {
        return this.hiddenTabList.size();
    }

    JPanel getTab(Object obj) {
        return this.linkedProgramMap.get(obj);
    }

    boolean isHidden(Object obj) {
        JPanel panel = this.linkedProgramMap.get(obj);
        if (panel != null) {
            return this.hiddenTabList.contains(panel);
        }
        return false;
    }

    private TabPanel createProgramTab(Program program, boolean isSelected) {
        JPanel labelPanel = new JPanel(new FlowLayout(0, 0, 1));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        GDLabel nameLabel = new GDLabel();
        nameLabel.setIconTextGap(1);
        nameLabel.setName("objectName");
        Gui.registerFont((Component)nameLabel, (String)FONT_TABS_ID);
        Color foregroundColor = isSelected ? TEXT_SELECTION_COLOR : TEXT_NON_SELECTION_COLOR;
        nameLabel.setForeground(foregroundColor);
        labelPanel.add((Component)nameLabel);
        GIconLabel iconLabel = new GIconLabel(isSelected ? CLOSE_ICON : EMPTY16_ICON);
        iconLabel.setToolTipText("Close");
        iconLabel.setName("Close");
        iconLabel.setOpaque(true);
        MouseAdapter iconSwitcherMouseListener = new MouseAdapter((JLabel)iconLabel, program){
            final /* synthetic */ JLabel val$iconLabel;
            final /* synthetic */ Program val$program;
            {
                this.val$iconLabel = jLabel;
                this.val$program = program;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == this.val$iconLabel) {
                    this.val$iconLabel.setIcon(HIGHLIGHT_CLOSE_ICON);
                } else {
                    this.val$iconLabel.setIcon(CLOSE_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.val$program == MultiTabPanel.this.currentProgram) {
                    this.val$iconLabel.setIcon(CLOSE_ICON);
                } else {
                    this.val$iconLabel.setIcon(EMPTY16_ICON);
                }
            }
        };
        Color backgroundColor = isSelected ? BG_SELECTION_COLOR : BG_NON_SELECTION_COLOR;
        labelPanel.setBackground(backgroundColor);
        iconLabel.setBackground(backgroundColor);
        TabPanel tabPanel = null;
        tabPanel = isSelected ? new SelectedPanel(backgroundColor, program, (JLabel)nameLabel, labelPanel, (JLabel)iconLabel) : new TabPanel(backgroundColor, program, (JLabel)nameLabel, labelPanel, (JLabel)iconLabel);
        tabPanel.refresh();
        GridBagLayout gbl = new GridBagLayout();
        tabPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbl.setConstraints(labelPanel, gbc);
        tabPanel.add(labelPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbl.setConstraints((Component)iconLabel, gbc);
        tabPanel.add((Component)iconLabel);
        tabPanel.setBorder(new BottomlessBevelBorder());
        MouseAdapter tabSelectionMouseListener = new MouseAdapter((JLabel)iconLabel, program){
            final /* synthetic */ JLabel val$iconLabel;
            final /* synthetic */ Program val$program;
            {
                this.val$iconLabel = jLabel;
                this.val$program = program;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!(e.getSource() instanceof JList)) {
                    MultiTabPanel.this.hideListWindow();
                }
                if (e.isPopupTrigger()) {
                    return;
                }
                if (e.getSource() == this.val$iconLabel) {
                    MultiTabPanel.this.doRemoveProgram(this.val$program);
                    return;
                }
                if (!MultiTabPanel.this.linkedProgramMap.containsKey(this.val$program) || MultiTabPanel.this.currentProgram == this.val$program) {
                    return;
                }
                MultiTabPanel.this.clearSelectedProgram();
                MultiTabPanel.this.setSelectedProgram(this.val$program);
                MultiTabPanel.this.hideListWindow();
                MultiTabPanel.this.multiTabPlugin.programSelected(MultiTabPanel.this.currentProgram);
            }
        };
        this.addMouseListener(tabPanel, tabSelectionMouseListener);
        this.addMouseListener(tabPanel, iconSwitcherMouseListener);
        this.linkedProgramMap.put(program, tabPanel);
        tabPanel.setMinimumSize(new Dimension(20, 20));
        return tabPanel;
    }

    private void clearSelectedProgram() {
        if (this.currentProgram == null) {
            return;
        }
        TabPanel panel = this.linkedProgramMap.get(this.currentProgram);
        panel = this.createProgramTab(this.currentProgram, false);
        this.linkedProgramMap.put(this.currentProgram, panel);
    }

    private void doRemoveProgram(Program program) {
        JPanel panel = this.linkedProgramMap.get(program);
        if (panel == null) {
            return;
        }
        if (!this.multiTabPlugin.removeProgram(program)) {
            return;
        }
        this.removeProgram(program);
    }

    void removeProgram(Program program) {
        this.highlightedProgram = null;
        JPanel panel = this.linkedProgramMap.get(program);
        if (panel == null) {
            return;
        }
        this.remove(panel);
        this.linkedProgramMap.remove(program);
        this.visibleTabList.remove(panel);
        this.hiddenTabList.remove(panel);
        if (program == this.currentProgram) {
            this.currentProgram = null;
        }
        this.packTabs(this.currentProgram);
        this.revalidate();
        this.repaint();
        this.hideListWindow();
    }

    void showProgramList() {
        this.showListFromKeyboardAction(this.currentProgram);
    }

    void highlightNextProgram(boolean forwardDirection) {
        if (this.highlightedProgram != null) {
            this.highlightedProgram = this.getNextProgram(this.highlightedProgram, forwardDirection);
        } else if (this.listWindowIsShowing()) {
            this.highlightedProgram = this.getFirstProgramForDirection(forwardDirection);
            this.hideListWindow();
        } else {
            this.highlightedProgram = this.getNextProgram(this.currentProgram, forwardDirection);
        }
        if (this.highlightedProgram == null) {
            this.showList(this.showHiddenListLabel);
        }
        this.setHighlightedTab(this.highlightedProgram);
        this.repaint();
    }

    void selectHighlightedProgram() {
        this.setHighlightedTab(null);
        if (this.highlightedProgram == null) {
            return;
        }
        this.setSelectedProgram(this.highlightedProgram);
        this.repaint();
    }

    private Program getFirstProgramForDirection(boolean forwardDirection) {
        int index = 0;
        if (!forwardDirection) {
            index = this.visibleTabList.size() - 1;
        }
        TabPanel panel = this.visibleTabList.get(index);
        return this.getProgramForPanel(panel);
    }

    private Program getNextProgram(Program startProgram, boolean forwardDirection) {
        TabPanel tabPanel = this.linkedProgramMap.get(startProgram);
        int index = this.getNextProgramIndex(this.visibleTabList.indexOf(tabPanel), forwardDirection);
        if (index >= 0) {
            TabPanel panel = this.visibleTabList.get(index);
            return this.getProgramForPanel(panel);
        }
        return null;
    }

    private int getNextProgramIndex(int visibleListIndex, boolean forwardDirection) {
        boolean hasHiddenPrograms;
        boolean bl = hasHiddenPrograms = this.hiddenTabList.size() != 0;
        if (forwardDirection) {
            if (++visibleListIndex == this.visibleTabList.size()) {
                return hasHiddenPrograms ? -1 : 0;
            }
            return visibleListIndex;
        }
        if (--visibleListIndex < 0) {
            return hasHiddenPrograms ? -1 : this.visibleTabList.size() - 1;
        }
        return visibleListIndex;
    }

    private Program getProgramForPanel(TabPanel panel) {
        Set<Map.Entry<Program, TabPanel>> entrySet = this.linkedProgramMap.entrySet();
        for (Map.Entry<Program, TabPanel> entry : entrySet) {
            if (entry.getValue() != panel) continue;
            return entry.getKey();
        }
        return null;
    }

    private void setHighlightedTab(Program highlightedProgram) {
        Collection<TabPanel> values = this.linkedProgramMap.values();
        for (TabPanel tabPanel : values) {
            tabPanel.paintHighlightedColor(false);
        }
        TabPanel tabPanel = this.linkedProgramMap.get(highlightedProgram);
        if (tabPanel != null) {
            tabPanel.paintHighlightedColor(true);
        }
    }

    private void hideListWindow() {
        if (this.listWindow != null) {
            this.listWindow.setVisible(false);
            this.filterField.setText("");
        }
    }

    private void hideListWindowDueToFocusChange() {
        if (!this.ignoreFocus) {
            this.hideListWindow();
        }
    }

    void setIgnoreFocus(boolean ignoreFocus) {
        this.ignoreFocus = ignoreFocus;
    }

    private void setTabVisible(Program program) {
        JPanel panel = this.linkedProgramMap.get(program);
        if (this.visibleTabList.contains(panel)) {
            return;
        }
        this.packTabs(program);
    }

    private void packTabs(Program selectedProgram) {
        List<TabPanel> newVisibleTabList = this.getTabsThatFitInView();
        newVisibleTabList = this.ensureCurrentProgramTabInView(selectedProgram, newVisibleTabList);
        Collection<TabPanel> allTabPanels = this.linkedProgramMap.values();
        ArrayList<TabPanel> newHiddenTabList = new ArrayList<TabPanel>(allTabPanels);
        newHiddenTabList.removeAll(newVisibleTabList);
        this.visibleTabList = newVisibleTabList;
        this.hiddenTabList = newHiddenTabList;
        this.highlightedProgram = null;
        super.removeAll();
        this.setVisible(allTabPanels.size() > 1);
        if (this.isVisible()) {
            for (JPanel jPanel : newVisibleTabList) {
                this.add(jPanel);
            }
            this.updateListLabel();
        }
        this.revalidate();
        this.repaint();
    }

    private List<TabPanel> getTabsThatFitInView() {
        int availableWidth = this.getWidth() - this.showHiddenListLabel.getPreferredSize().width;
        ArrayList<TabPanel> newVisibleTabList = new ArrayList<TabPanel>();
        ArrayList<TabPanel> allTabsList = new ArrayList<TabPanel>(this.linkedProgramMap.values());
        int usedWidth = 0;
        for (TabPanel panel : allTabsList) {
            int currentTabWidth = panel.getPreferredSize().width;
            if (availableWidth > 0 && usedWidth + currentTabWidth > availableWidth) break;
            usedWidth += currentTabWidth;
            newVisibleTabList.add(panel);
        }
        if (allTabsList.size() - newVisibleTabList.size() == 1) {
            TabPanel lastPanel = (TabPanel)allTabsList.get(allTabsList.size() - 1);
            if (usedWidth + lastPanel.getPreferredSize().width < this.getWidth()) {
                newVisibleTabList.add(lastPanel);
            }
        }
        return newVisibleTabList;
    }

    private List<TabPanel> ensureCurrentProgramTabInView(Program activeProgram, List<TabPanel> newVisibleTabList) {
        TabPanel currentTabPanel = this.linkedProgramMap.get(activeProgram);
        if (currentTabPanel == null) {
            return newVisibleTabList;
        }
        if (newVisibleTabList.contains(currentTabPanel)) {
            return newVisibleTabList;
        }
        int availablePanelWidth = this.getWidth();
        int currentTabWidth = currentTabPanel.getPreferredSize().width;
        if (currentTabWidth > (availablePanelWidth -= this.showHiddenListLabel.getWidth())) {
            newVisibleTabList.clear();
            return newVisibleTabList;
        }
        int usedWidth = 0;
        for (JPanel jPanel : newVisibleTabList) {
            usedWidth += jPanel.getPreferredSize().width;
        }
        for (int i = newVisibleTabList.size() - 1; i >= 0; --i) {
            TabPanel tabPanel = newVisibleTabList.remove(i);
            int width = tabPanel.getPreferredSize().width;
            int newAvailableWidth = availablePanelWidth - (usedWidth -= width);
            if (newAvailableWidth < currentTabWidth) continue;
            newVisibleTabList.add(currentTabPanel);
            break;
        }
        return newVisibleTabList;
    }

    private void updateListLabel() {
        int hiddenCnt = this.hiddenTabList.size();
        if (hiddenCnt == 0) {
            this.remove(this.showHiddenListLabel);
            return;
        }
        this.remove(this.showHiddenListLabel);
        this.add(this.showHiddenListLabel);
        this.showHiddenListLabel.setText(Integer.toString(hiddenCnt));
    }

    private boolean listWindowIsShowing() {
        return this.listWindow != null && this.listWindow.isShowing();
    }

    private JLabel createLabel() {
        GDLabel newLabel = new GDLabel(DEFAULT_HIDDEN_COUNT_STR, LIST_ICON, 2);
        newLabel.setIconTextGap(0);
        Gui.registerFont((Component)newLabel, (String)FONT_TABS_LIST_ID);
        newLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        newLabel.setToolTipText("Show Tab List");
        newLabel.setName("showList");
        newLabel.setBackground(BG_COLOR_MORE_TABS_HOVER);
        this.defaultListLabelBorder = newLabel.getBorder();
        Border hoverBorder = BorderFactory.createBevelBorder(0);
        newLabel.addMouseListener(new MouseAdapter((JLabel)newLabel, hoverBorder){
            final /* synthetic */ JLabel val$newLabel;
            final /* synthetic */ Border val$hoverBorder;
            {
                this.val$newLabel = jLabel;
                this.val$hoverBorder = border;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MultiTabPanel.this.listWindowIsShowing()) {
                    MultiTabPanel.this.hideListWindow();
                    return;
                }
                MultiTabPanel.this.showList(e.getComponent());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (MultiTabPanel.this.listWindowIsShowing()) {
                    return;
                }
                this.val$newLabel.setBorder(this.val$hoverBorder);
                this.val$newLabel.setOpaque(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MultiTabPanel.this.resetListLabelAppearance();
            }
        });
        newLabel.setPreferredSize(newLabel.getPreferredSize());
        return newLabel;
    }

    private void resetListLabelAppearance() {
        this.showHiddenListLabel.setBorder(this.defaultListLabelBorder);
        this.showHiddenListLabel.setOpaque(false);
    }

    private void showListFromKeyboardAction(Program startProgram) {
        if (!this.listWindowIsShowing()) {
            this.showList(null);
        }
        this.programListPanel.selectProgram(startProgram);
    }

    private void showList(Component source) {
        if (this.listWindow == null) {
            this.createListWindow();
        } else {
            this.programListPanel.setProgramLists(this.getProgramList(false), this.getProgramList(true));
        }
        this.listWindow.pack();
        this.setListLocationBelowLabel((JLabel)source);
        this.listWindow.setVisible(true);
        this.resetListLabelAppearance();
        this.programListPanel.requestFocus();
    }

    private void setListLocationBelowLabel(JLabel label) {
        Rectangle bounds = this.listWindow.getBounds();
        if (label == null) {
            Point centerPoint = WindowUtilities.centerOnComponent((Component)this.getParent(), (Component)this.listWindow);
            bounds.setLocation(centerPoint);
            WindowUtilities.ensureOnScreen((Component)this.getParent(), (Rectangle)bounds);
            this.listWindow.setBounds(bounds);
            return;
        }
        Point p = label.getLocationOnScreen();
        int x = p.x;
        int y = p.y + label.getHeight() + 3;
        bounds.setLocation(x, y);
        WindowUtilities.ensureOnScreen((Component)label, (Rectangle)bounds);
        this.listWindow.setBounds(bounds);
    }

    private void createListWindow() {
        Window parent = this.findParent();
        this.listWindow = parent instanceof Dialog ? new JDialog((Dialog)parent) : new JDialog((Frame)parent);
        this.listWindow.setUndecorated(true);
        this.listWindow.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                MultiTabPanel.this.hideListWindowDueToFocusChange();
            }
        });
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MultiTabPanel.this.multiTabPlugin.keyTypedFromListWindow(e);
            }
        };
        this.programListPanel = new ProgramListPanel(this.getProgramList(false), this.getProgramList(true), this.multiTabPlugin);
        final JList<Program> list = this.programListPanel.getList();
        this.filterField = this.programListPanel.getFilterField();
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MultiTabPanel.this.processWindowSelection();
            }
        });
        list.addKeyListener(listener);
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MultiTabPanel.this.processWindowSelection();
                } else if (e.getKeyCode() == 27) {
                    MultiTabPanel.this.hideListWindow();
                }
            }
        });
        list.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != MultiTabPanel.this.filterField) {
                    MultiTabPanel.this.hideListWindowDueToFocusChange();
                }
            }
        });
        this.filterField.addKeyListener(listener);
        this.filterField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    focusManager.redispatchEvent(list, e);
                }
            }
        });
        this.listWindow.getContentPane().add(this.programListPanel);
        parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (e.getOppositeWindow() != MultiTabPanel.this.listWindow) {
                    MultiTabPanel.this.hideListWindowDueToFocusChange();
                }
            }
        });
        parent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                MultiTabPanel.this.hideListWindow();
            }
        });
        this.setActionMap();
    }

    private void processWindowSelection() {
        Program selectedProgram = this.programListPanel.getSelectedProgram();
        if (selectedProgram == null) {
            return;
        }
        this.hideListWindow();
        if (selectedProgram == this.currentProgram) {
            return;
        }
        this.setSelectedProgram(selectedProgram);
    }

    private List<Program> getProgramList(boolean getVisiblePrograms) {
        ArrayList<TabPanel> panelList = null;
        panelList = getVisiblePrograms ? new ArrayList<TabPanel>(this.visibleTabList) : new ArrayList<TabPanel>(this.hiddenTabList);
        ArrayList<Program> list = new ArrayList<Program>();
        Set<Map.Entry<Program, TabPanel>> entrySet = this.linkedProgramMap.entrySet();
        for (Map.Entry<Program, TabPanel> entry : entrySet) {
            JPanel panel = entry.getValue();
            if (!panelList.contains(panel)) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    private Window findParent() {
        Container parent = this.getParent();
        while (!(parent instanceof Window) && !(parent instanceof JFrame)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    private void addMouseListener(Container c, MouseListener listener) {
        Component[] children;
        c.addMouseListener(listener);
        for (Component element : children = c.getComponents()) {
            if (element instanceof Container) {
                this.addMouseListener((Container)element, listener);
                continue;
            }
            element.addMouseListener(listener);
        }
    }

    private void setActionMap() {
        AbstractAction escAction = new AbstractAction("Exit Window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiTabPanel.this.hideListWindow();
            }
        };
        JRootPane rootPane = this.listWindow.getRootPane();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        KeyBindingUtils.registerAction((JComponent)rootPane, (KeyStroke)ks, (Action)escAction, (int)2);
    }

    private String getProgramName(Program program) {
        Object name = program.toString();
        if (this.multiTabPlugin != null) {
            name = (this.multiTabPlugin.isChanged(program) ? "*" : " ") + this.multiTabPlugin.getName(program);
        }
        return name;
    }

    class BottomOnlyBevelBorder
    extends BevelBorder {
        public BottomOnlyBevelBorder() {
            super(0);
        }

        @Override
        protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.setColor(this.getShadowInnerColor(c));
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private class TabPanel
    extends JPanel {
        private Color defaultBgColor;
        private Color defaultFgColor;
        protected final JLabel nameLabel;
        protected final JPanel labelPanel;
        protected final JLabel iconLabel;
        private final Program program;

        private TabPanel(Color backgroundColor, Program program, JLabel nameLabel, JPanel labelPanel, JLabel iconLabel) {
            this.defaultBgColor = backgroundColor;
            this.defaultFgColor = nameLabel.getForeground();
            this.program = program;
            this.nameLabel = nameLabel;
            this.labelPanel = labelPanel;
            this.iconLabel = iconLabel;
            this.setBackground(backgroundColor);
        }

        void refresh() {
            String name = MultiTabPanel.this.getProgramName(this.program);
            ProjectLocator projectLocator = this.program.getDomainFile().getProjectLocator();
            if (projectLocator != null && projectLocator.isTransient()) {
                this.nameLabel.setIcon(TRANSIENT_ICON);
            } else {
                this.nameLabel.setIcon(EMPTY8_ICON);
            }
            this.nameLabel.setText(name);
            String toolTip = MultiTabPanel.this.multiTabPlugin != null ? MultiTabPanel.this.multiTabPlugin.getToolTip(this.program) : null;
            this.nameLabel.setToolTipText(toolTip);
        }

        void paintHighlightedColor(boolean paintHighlight) {
            Color newBgColor = this.defaultBgColor;
            Color newFgColor = this.defaultFgColor;
            if (paintHighlight) {
                newBgColor = HIGHLIGHTED_TAB_BG_COLOR;
                newFgColor = TEXT_SELECTION_COLOR;
            }
            this.setBackground(newBgColor);
            this.nameLabel.setBackground(newBgColor);
            this.nameLabel.setForeground(newFgColor);
            this.labelPanel.setBackground(newBgColor);
            this.iconLabel.setBackground(newBgColor);
        }
    }

    private class SelectedPanel
    extends TabPanel {
        private SelectedPanel(Color backgroundColor, Program program, JLabel nameLabel, JPanel labelPanel, JLabel iconLabel) {
            super(backgroundColor, program, nameLabel, labelPanel, iconLabel);
            this.setBorder(new BottomlessBevelBorder());
            this.setBackground(BG_SELECTION_COLOR);
            labelPanel.setBackground(BG_SELECTION_COLOR);
            nameLabel.setForeground(TEXT_SELECTION_COLOR);
            iconLabel.setBackground(BG_SELECTION_COLOR);
            iconLabel.setIcon(CLOSE_ICON);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Shape saveClip = g.getClip();
            Color oldColor = g.getColor();
            Rectangle bounds = saveClip.getBounds();
            g.setClip(bounds.x, bounds.y, bounds.width, this.getHeight() + 2);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight() + 2);
            g.setColor(oldColor);
            g.setClip(saveClip);
            super.paintComponent(g);
        }

        @Override
        void paintHighlightedColor(boolean paintHighlight) {
            super.paintHighlightedColor(paintHighlight);
            Color foreground = TEXT_NON_SELECTION_COLOR;
            if (paintHighlight) {
                foreground = TEXT_SELECTION_COLOR;
            }
            this.nameLabel.setForeground(foreground);
        }
    }

    class BottomlessBevelBorder
    extends BevelBorder {
        public BottomlessBevelBorder() {
            super(0);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets borderInsets = super.getBorderInsets(c);
            borderInsets.bottom = 0;
            return borderInsets;
        }

        @Override
        protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            Shape saveClip = g.getClip();
            Rectangle bounds = saveClip.getBounds();
            g.setClip(bounds.x, bounds.y, bounds.width, MultiTabPanel.this.getHeight() + 2);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(0, 0, 0, h);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(1, 0, w - 2, 0);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(1, 1, 1, h);
            g.drawLine(2, 1, w - 3, 1);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(w - 1, 0, w - 1, h);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(w - 2, 1, w - 2, h);
            g.setClip(saveClip);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

