/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import ghidra.app.plugin.core.overview.AbstractColorOverviewAction;
import ghidra.app.plugin.core.overview.OverviewColorComponent;
import ghidra.app.plugin.core.overview.OverviewColorLegendDialog;
import ghidra.app.plugin.core.overview.OverviewColorService;
import ghidra.app.plugin.core.overview.entropy.EntropyOverviewOptionsManager;
import ghidra.app.plugin.core.overview.entropy.KnotRecord;
import ghidra.app.plugin.core.overview.entropy.LegendPanel;
import ghidra.app.plugin.core.overview.entropy.OverviewPalette;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EntropyOverviewColorService
implements OverviewColorService {
    private static DecimalFormat formatter = new DecimalFormat("#0.0");
    private Program program;
    private int chunkSize;
    private byte[] chunkBuffer;
    private double[] logtable;
    private int[] histogram = new int[256];
    private OverviewPalette palette;
    private EntropyOverviewOptionsManager entropyOptionsManager;
    private OverviewColorComponent overviewComponent;

    @Override
    public String getName() {
        return "Entropy";
    }

    @Override
    public Color getColor(Address address) {
        if (this.program == null) {
            return this.palette.getColor(0);
        }
        int entropy = this.computeEntropy(address);
        return this.palette.getColor(entropy);
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("OverviewPlugin", "EntropyOverviewBar");
    }

    @Override
    public void initialize(PluginTool tool) {
        this.entropyOptionsManager = new EntropyOverviewOptionsManager(tool, this);
        this.chunkSize = this.entropyOptionsManager.getChunkSize();
        this.chunkBuffer = new byte[this.chunkSize];
        this.palette = this.entropyOptionsManager.getPalette();
    }

    @Override
    public void setOverviewComponent(OverviewColorComponent component) {
        this.overviewComponent = component;
    }

    @Override
    public String getToolTipText(Address address) {
        if (address == null) {
            return null;
        }
        int entropyScaled = this.computeEntropy(address);
        double entropy = (double)entropyScaled * 8.0 / 255.0;
        StringBuilder buffer = new StringBuilder();
        buffer.append("<b>");
        buffer.append(HTMLUtilities.escapeHTML((String)this.getName()));
        buffer.append("</b>\n");
        buffer.append(" ");
        buffer.append(formatter.format(entropy));
        buffer.append(" ");
        buffer.append(HTMLUtilities.escapeHTML((String)this.getKnotName(entropyScaled)));
        buffer.append(" ");
        buffer.append(" &nbsp&nbsp&nbsp(");
        buffer.append(HTMLUtilities.escapeHTML((String)this.getBlockName(address)));
        buffer.append(" ");
        buffer.append(HTMLUtilities.escapeHTML((String)address.toString()));
        buffer.append(" )");
        return HTMLUtilities.toWrappedHTML((String)buffer.toString(), (int)0);
    }

    private String getKnotName(int entropy) {
        ArrayList<KnotRecord> knots = this.palette.getKnots();
        for (KnotRecord knotRecord : knots) {
            if (!knotRecord.contains(entropy)) continue;
            return knotRecord.getName();
        }
        return "";
    }

    private String getBlockName(Address address) {
        MemoryBlock block = this.program.getMemory().getBlock(address);
        if (block != null) {
            return block.getName();
        }
        return "";
    }

    private int computeEntropy(Address address) {
        if (address == null) {
            return 0;
        }
        MemoryBlock block = this.program.getMemory().getBlock(address);
        if (block == null) {
            return 0;
        }
        Address chunkStartAddress = this.getChunkStartAddress(block, address);
        try {
            int bytesRead = block.getBytes(chunkStartAddress, this.chunkBuffer);
            this.computeHistogram(bytesRead);
            return this.quantizeChunk();
        }
        catch (MemoryAccessException e) {
            return 0;
        }
    }

    private int quantizeChunk() {
        if (this.logtable == null) {
            this.buildLogTable();
        }
        double sum = 0.0;
        for (int i = 0; i < 256; ++i) {
            sum += this.logtable[this.histogram[i]];
        }
        int val = (int)Math.floor(sum = sum / 8.0 * 256.0);
        if (val > 255) {
            val = 255;
        }
        return val;
    }

    private void computeHistogram(int byteCount) {
        Arrays.fill(this.histogram, 0);
        for (int i = 0; i < byteCount; ++i) {
            int n = 128 + this.chunkBuffer[i];
            this.histogram[n] = this.histogram[n] + 1;
        }
    }

    private Address getChunkStartAddress(MemoryBlock block, Address address) {
        long offset = address.subtract(block.getStart());
        long chunk = offset / (long)this.chunkSize;
        return block.getStart().add(chunk * (long)this.chunkSize);
    }

    @Override
    public void setProgram(Program program) {
        this.program = program;
    }

    private void buildLogTable() {
        this.logtable = new double[this.chunkSize + 1];
        double logtwo = Math.log(2.0);
        double chunkfloat = this.chunkSize;
        for (int i = 1; i < this.chunkSize; ++i) {
            double prob = (double)i / chunkfloat;
            this.logtable[i] = -prob * (Math.log(prob) / logtwo);
        }
        this.logtable[0] = 0.0;
        this.logtable[this.chunkSize] = 0.0;
    }

    public void paletteChanged() {
        if (this.overviewComponent != null) {
            this.overviewComponent.refreshAll();
        }
    }

    @Override
    public List<DockingActionIf> getActions() {
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        actions.add((DockingActionIf)new AbstractColorOverviewAction("Show Legend", this.getName(), this.overviewComponent, this.getHelpLocation()){

            public void actionPerformed(ActionContext context) {
                PluginTool tool = EntropyOverviewColorService.this.overviewComponent.getTool();
                tool.showDialog(EntropyOverviewColorService.this.getLegendDialog());
            }
        });
        return actions;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    private DialogComponentProvider getLegendDialog() {
        LegendPanel legendPanel = new LegendPanel();
        legendPanel.setPalette(this.palette);
        OverviewColorLegendDialog legendDialog = new OverviewColorLegendDialog("Entropy Legend", legendPanel, this.getHelpLocation());
        return legendDialog;
    }
}

