/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;

public class ProgramStartingLocationOptions
implements OptionsChangeListener {
    static final String NAVIGATION_TOPIC = "Navigation";
    public static final String START_LOCATION_SUB_OPTION = "Starting Program Location";
    public static final String START_LOCATION_TYPE_OPTION = "Starting Program Location.Start At: ";
    public static final String START_SYMBOLS_OPTION = "Starting Program Location.Start Symbols: ";
    public static final String UNDERSCORE_OPTION = "Starting Program Location.Use Underscores:";
    public static final String AFTER_ANALYSIS_SUB_OPTION = "After Initial Analysis";
    public static final String ASK_TO_MOVE_OPTION = "After Initial Analysis.Ask To Reposition Program";
    public static final String AUTO_MOVE_OPTION = "After Initial Analysis.Auto Reposition If Not Moved";
    private static final String START_LOCATION_DESCRIPTION = "Determines the start location for newly opened programs.\nEither lowest address, lowest code address, preferred starting symbol name, or thelocation when last closed.\nEach higher option will revert to the next lower option if that option can't be satisfied.";
    private static final String STARTING_SYSMBOLS_DESCRIPTION = "A comma separated list of symbol names in preference order. (Used when option above is set to \"Preferred Symbol Name\")";
    private static final String SYMBOL_PREFIX_DESCRIPTION = "When searching for symbols, also search for the names prepended with \"_\" and \"__\".";
    public static final String ASK_TO_MOVE_DESCRIPTION = "When initial analysis completed, asks the user if they want to reposition the program to a newly discovered starting symbol.";
    public static final String AUTO_MOVE_DESCRIPTION = "When initial analysis is completed, automatically repositions the program to a newly discovered starting symbol, provided the user hasn't manually moved.";
    private static final String DEFAULT_STARTING_SYMBOLS = "main, WinMain, libc_start_main, WinMainStartup, start, entry, main.main";
    private StartLocationType startLocationType;
    private List<String> startSymbols;
    private boolean useUnderscorePrefixes;
    private ToolOptions options;
    private boolean askToMove;
    private boolean autoMove;

    public ProgramStartingLocationOptions(PluginTool tool) {
        this.options = tool.getOptions(NAVIGATION_TOPIC);
        HelpLocation help = new HelpLocation(NAVIGATION_TOPIC, "Starting_Program_Location");
        Options subOptions = this.options.getOptions(START_LOCATION_SUB_OPTION);
        subOptions.setOptionsHelpLocation(help);
        this.options.registerOption(START_LOCATION_TYPE_OPTION, (Object)StartLocationType.LAST_LOCATION, help, START_LOCATION_DESCRIPTION);
        this.options.registerOption(START_SYMBOLS_OPTION, (Object)DEFAULT_STARTING_SYMBOLS, help, STARTING_SYSMBOLS_DESCRIPTION);
        this.options.registerOption(UNDERSCORE_OPTION, (Object)true, help, SYMBOL_PREFIX_DESCRIPTION);
        help = new HelpLocation(NAVIGATION_TOPIC, "After_Initial_Analysis");
        subOptions = this.options.getOptions(AFTER_ANALYSIS_SUB_OPTION);
        subOptions.setOptionsHelpLocation(help);
        this.options.registerOption(ASK_TO_MOVE_OPTION, (Object)true, help, ASK_TO_MOVE_DESCRIPTION);
        this.options.registerOption(AUTO_MOVE_OPTION, (Object)true, help, AUTO_MOVE_DESCRIPTION);
        this.startLocationType = (StartLocationType)this.options.getEnum(START_LOCATION_TYPE_OPTION, (Enum)StartLocationType.SYMBOL_NAME);
        String symbolNames = this.options.getString(START_SYMBOLS_OPTION, DEFAULT_STARTING_SYMBOLS);
        this.startSymbols = this.parse(symbolNames);
        this.useUnderscorePrefixes = this.options.getBoolean(UNDERSCORE_OPTION, true);
        this.askToMove = this.options.getBoolean(ASK_TO_MOVE_OPTION, true);
        this.autoMove = this.options.getBoolean(AUTO_MOVE_OPTION, true);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    private List<String> parse(String symbolNames) {
        String[] split;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : split = symbolNames.split(",")) {
            String trimmed = string.trim();
            if (trimmed.isBlank()) continue;
            names.add(trimmed);
        }
        return names;
    }

    public StartLocationType getStartLocationType() {
        return this.startLocationType;
    }

    public List<String> getStartingSymbolNames() {
        return this.startSymbols;
    }

    public boolean useUnderscorePrefixes() {
        return this.useUnderscorePrefixes;
    }

    public void dispose() {
        this.options.removeOptionsChangeListener((OptionsChangeListener)this);
    }

    public boolean shouldAskToRepostionAfterAnalysis() {
        return this.askToMove;
    }

    public boolean shouldAutoRepositionIfNotMoved() {
        return this.autoMove;
    }

    public void optionsChanged(ToolOptions toolOptions, String optionName, Object oldValue, Object newValue) {
        if (START_LOCATION_TYPE_OPTION.equals(optionName)) {
            this.startLocationType = (StartLocationType)((Object)newValue);
        } else if (START_SYMBOLS_OPTION.equals(optionName)) {
            this.startSymbols = this.parse((String)newValue);
        } else if (UNDERSCORE_OPTION.equals(optionName)) {
            this.useUnderscorePrefixes = (Boolean)newValue;
        } else if (ASK_TO_MOVE_OPTION.equals(optionName)) {
            this.askToMove = (Boolean)newValue;
        } else if (AUTO_MOVE_OPTION.equals(optionName)) {
            this.autoMove = (Boolean)newValue;
        }
    }

    public static enum StartLocationType {
        LOWEST_ADDRESS("Lowest Address"),
        LOWEST_CODE_BLOCK("Lowest Code Block Address"),
        SYMBOL_NAME("Preferred Symbol Name"),
        LAST_LOCATION("Location When Last Closed");

        private String label;

        private StartLocationType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

