/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class CompEditorModel
extends CompositeEditorModel {
    private volatile boolean consideringReplacedDataType = false;

    CompEditorModel(CompositeEditorProvider provider) {
        super(provider);
    }

    @Override
    public boolean hasChanges() {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (originalDTM != null && !originalDTM.contains((DataType)this.originalComposite)) {
            return true;
        }
        return super.hasChanges();
    }

    @Override
    public void load(Composite dataType) {
        super.load(dataType);
        this.fixSelection();
        this.selectionChanged();
    }

    @Override
    protected String getTypeName() {
        if (this.viewComposite instanceof Structure) {
            return "Structure";
        }
        if (this.viewComposite instanceof Union) {
            return "Union";
        }
        return super.getTypeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply() throws InvalidDataTypeException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldSelection saveSelection = new FieldSelection(this.selection);
        Composite originalDt = this.getOriginalComposite();
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (originalDt == null || originalDTM == null) {
            throw new IllegalStateException("Can't apply edits without a data type or data type manager.");
        }
        int transactionID = originalDTM.startTransaction("Edit " + this.getCompositeName());
        try {
            if (originalDTM.contains((DataType)originalDt)) {
                String editName;
                String origName = originalDt.getName();
                if (!origName.equals(editName = this.getCompositeName())) {
                    try {
                        originalDt.setName(editName);
                    }
                    catch (InvalidNameException e) {
                        String msg = "Apply failed. The data type name \"" + editName + "\" is not valid.";
                        throw new InvalidDataTypeException(msg);
                    }
                    catch (DuplicateNameException e) {
                        String msg = "Apply failed. A data type named \"" + editName + "\" already exists.";
                        throw new InvalidDataTypeException(msg);
                    }
                }
                originalDt.setDescription(this.getDescription());
                this.replaceOriginalComponents();
                this.updateOriginalComponentSettings(this.viewComposite, originalDt);
                this.load(originalDt);
            } else {
                Composite dt = (Composite)originalDTM.resolve((DataType)this.viewComposite, null);
                this.load(dt);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.provider.updateTitle();
            this.setSelection(saveSelection);
            originalDTM.endTransaction(transactionID, true);
        }
    }

    boolean isBlankLastLineSelected() {
        return this.selection.contains(new FieldLocation(this.getNumComponents(), 0, 0, 0));
    }

    protected abstract int getNumBytesInRange(FieldRange var1);

    @Override
    public void setSelection(int[] rows) {
        int numComponents;
        if (this.updatingSelection) {
            return;
        }
        FieldSelection tmpSelection = new FieldSelection();
        if (rows.length == 1) {
            tmpSelection.addRange(rows[0], rows[0] + 1);
        } else {
            numComponents = this.getNumComponents();
            for (int r : rows) {
                if (r >= numComponents) continue;
                tmpSelection.addRange(r, r + 1);
            }
        }
        if (tmpSelection.getNumRanges() == 0) {
            numComponents = this.getNumComponents();
            tmpSelection.addRange(numComponents, numComponents + 1);
        }
        if (this.selection.equals((Object)tmpSelection)) {
            this.selectionChanged();
            return;
        }
        this.endFieldEditing();
        this.selection = tmpSelection;
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    @Override
    public void setSelection(FieldSelection selection) {
        if (this.updatingSelection) {
            return;
        }
        if (this.selection.equals((Object)selection)) {
            return;
        }
        this.endFieldEditing();
        this.selection.clear();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = selection.getFieldRange(i);
            this.selection.addRange(range.getStart().getIndex().intValue(), range.getEnd().getIndex().intValue());
        }
        this.fixSelection();
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    boolean fixSelection() {
        int numComps = this.getNumComponents();
        FieldSelection allRows = new FieldSelection();
        allRows.addRange(0, numComps + 1);
        this.selection.intersect(allRows);
        if (this.selection.getNumRanges() == 0) {
            this.selection.addRange(numComps, numComps + 1);
        } else if (this.isBlankLastLineSelected() && this.getNumSelectedComponentRows() > 0) {
            this.selection.removeRange(numComps, numComps + 1);
        } else {
            return false;
        }
        this.adjustCurrentRow();
        return true;
    }

    protected void setDataType(int rowIndex, DataType dt, int length) throws UsrException {
        if (rowIndex < this.getNumComponents()) {
            this.replace(rowIndex, dt, length);
        } else {
            this.insert(rowIndex, dt, length);
        }
    }

    @Override
    public DataTypeInstance validateComponentDataType(int rowIndex, String dtString) throws UsrException {
        if (((dtString = DataTypeHelper.stripWhiteSpace(dtString)) == null || dtString.length() < 1) && rowIndex == this.getNumComponents()) {
            return null;
        }
        return super.validateComponentDataType(rowIndex, dtString);
    }

    @Override
    public boolean isAddAllowed(DataType dataType) {
        int rowIndex = this.getMinIndexSelected();
        if (rowIndex == -1) {
            return false;
        }
        return this.isAddAllowed(rowIndex, dataType);
    }

    @Override
    public boolean isClearAllowed() {
        return this.getNumSelectedRows() > 0 && !this.isBlankLastLineSelected();
    }

    @Override
    public boolean isCycleAllowed(CycleGroup cycleGroup) {
        return this.getNumSelectedRows() == 1;
    }

    public boolean isInsertAllowed(DataType dataType) {
        int rowIndex = this.getMinIndexSelected();
        if (rowIndex == -1) {
            return false;
        }
        return this.isInsertAllowed(rowIndex, dataType);
    }

    @Override
    public boolean isInsertAllowed(int rowIndex, DataType datatype) {
        return true;
    }

    public boolean isReplaceAllowed(DataType dataType) {
        if (this.getNumSelectedComponentRows() != 1) {
            return false;
        }
        int rowIndex = this.getMinIndexSelected();
        return this.isReplaceAllowed(rowIndex, dataType);
    }

    void delete(int componentOrdinal) {
        this.doDelete(componentOrdinal);
        this.selection.removeRange(componentOrdinal, componentOrdinal + 1);
        this.adjustSelection(componentOrdinal + 1, -1);
        this.notifyCompositeChanged();
    }

    private void doDelete(int componentOrdinal) {
        this.viewComposite.delete(componentOrdinal);
        if (componentOrdinal < this.row) {
            --this.row;
        }
    }

    private void delete(int[] rows) throws CancelledException {
        int n = rows.length;
        Arrays.sort(rows);
        HashSet<Integer> rowSet = new HashSet<Integer>();
        for (int i = n - 1; i >= 0; --i) {
            int rowIndex = rows[i];
            int componentOrdinal = this.convertRowToOrdinal(rowIndex);
            if (componentOrdinal < this.row) {
                --this.row;
            }
            rowSet.add(componentOrdinal);
        }
        this.viewComposite.delete(rowSet);
        if (rows.length > 0) {
            this.setSelection(new int[]{rows[0]});
        }
        this.notifyCompositeChanged();
    }

    @Override
    protected void deleteComponent(int rowIndex) {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        int componentOrdinal = this.convertRowToOrdinal(rowIndex);
        this.delete(componentOrdinal);
        this.fixSelection();
        this.componentEdited();
        this.selectionChanged();
    }

    void deleteComponentRange(int startRowIndex, int endRowIndex, TaskMonitor monitor) throws CancelledException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        int entries = endRowIndex - startRowIndex + 1;
        HashSet<Integer> ordinals = new HashSet<Integer>();
        monitor.initialize((long)entries);
        for (int rowIndex = endRowIndex; rowIndex >= startRowIndex; --rowIndex) {
            monitor.checkCancelled();
            int componentOrdinal = this.convertRowToOrdinal(rowIndex);
            ordinals.add(componentOrdinal);
            if (componentOrdinal < this.row) {
                --this.row;
            }
            this.selection.removeRange(componentOrdinal, componentOrdinal + 1);
            this.adjustSelection(componentOrdinal + 1, -1);
            monitor.incrementProgress(1L);
        }
        this.viewComposite.delete(ordinals);
        this.fixSelection();
        this.componentEdited();
        this.notifyCompositeChanged();
        this.selectionChanged();
    }

    @Override
    public void deleteSelectedComponents() throws UsrException {
        if (!this.isDeleteAllowed()) {
            throw new UsrException("Deleting is not allowed.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        int[] selectedComponents = this.getSelectedComponentRows();
        int firstRowIndex = !this.selection.isEmpty() ? selectedComponents[0] : this.getRowCount();
        try {
            this.delete(selectedComponents);
        }
        finally {
            this.componentEdited();
        }
        this.selection.addRange(firstRowIndex, firstRowIndex + 1);
        this.fixSelection();
        this.selectionChanged();
    }

    protected abstract DataTypeComponent insert(int var1, DataType var2, int var3, String var4, String var5) throws InvalidDataTypeException;

    protected abstract void insert(int var1, DataType var2, int var3, int var4, TaskMonitor var5) throws InvalidDataTypeException, CancelledException;

    protected void insertMultiple(int rowIndex, DataType dataType, int dtLen, int multiple, TaskMonitor monitor) throws NoSuchElementException, InvalidDataTypeException, CancelledException {
        if (multiple < 1) {
            return;
        }
        this.insert(rowIndex, dataType, dtLen, multiple, monitor);
    }

    @Override
    public DataTypeComponent insert(DataType dataType) throws UsrException {
        if (this.hasSelection()) {
            return this.insert(this.getMinIndexSelected(), dataType);
        }
        return null;
    }

    @Override
    public DataTypeComponent insert(int rowIndex, DataType dt) throws UsrException {
        return this.insert(rowIndex, dt, dt.getLength());
    }

    @Override
    public DataTypeComponent insert(int rowIndex, DataType datatype, int length) throws InvalidDataTypeException, UsrException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.checkIsAllowableDataType(datatype);
        if (length < 1) {
            DataTypeInstance dti = DataTypeHelper.getSizedDataType(this.getProvider(), datatype, this.lastNumBytes, Integer.MAX_VALUE);
            if (dti == null) {
                return null;
            }
            datatype = dti.getDataType();
            length = dti.getLength();
        }
        DataTypeComponent dtc = this.insert(rowIndex, datatype, length, null, null);
        this.fixSelection();
        this.componentEdited();
        this.selectionChanged();
        return dtc;
    }

    protected void insertComponentMultiple(int rowIndex, DataType dataType, int dtLen, int multiple, TaskMonitor monitor) throws NoSuchElementException, InvalidDataTypeException, CancelledException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.checkIsAllowableDataType(dataType);
        this.insertMultiple(rowIndex, dataType, dtLen, multiple, monitor);
        this.fixSelection();
        this.componentEdited();
        this.selectionChanged();
    }

    @Override
    public DataTypeComponent add(DataType dataType) throws UsrException {
        if (this.isContiguousSelection()) {
            return this.add(this.getMinIndexSelected(), dataType);
        }
        return null;
    }

    @Override
    public DataTypeComponent add(int rowIndex, DataType dt) throws UsrException {
        dt = this.viewDTM.resolve(dt, DataTypeConflictHandler.DEFAULT_HANDLER);
        try {
            DataTypeInstance dti = this.getDropDataType(rowIndex, dt);
            return this.add(rowIndex, dti.getDataType(), dti.getLength());
        }
        catch (CancelledException e) {
            return null;
        }
    }

    @Override
    public DataTypeComponent add(int rowIndex, DataType dt, int dtLength) throws UsrException {
        FieldRange range;
        DataTypeComponent dtc = null;
        dtc = rowIndex < this.getNumComponents() ? ((range = this.getSelectedRangeContaining(rowIndex)) == null || range.getStart().getIndex().intValue() == range.getEnd().getIndex().intValue() - 1 ? this.replace(rowIndex, dt, dtLength) : this.replaceComponentRange(range.getStart().getIndex().intValue(), range.getEnd().getIndex().intValue() - 1, dt, dtLength)) : this.insert(rowIndex, dt, dtLength);
        return dtc;
    }

    public DataTypeComponent replace(DataType dataType) throws UsrException {
        if (this.isContiguousComponentSelection()) {
            return this.replace(this.getMinIndexSelected(), dataType);
        }
        return null;
    }

    public DataTypeComponent replace(int rowIndex, DataType dt) throws UsrException {
        DataTypeInstance dti = DataTypeHelper.getFixedLength(this, rowIndex, dt);
        if (dti == null) {
            return null;
        }
        DataTypeComponent dtc = null;
        if (rowIndex < this.getNumComponents()) {
            FieldRange range = this.getSelectedRangeContaining(rowIndex);
            dtc = range == null || range.getStart().getIndex().intValue() == range.getEnd().getIndex().intValue() - 1 ? this.replace(rowIndex, dti.getDataType(), dti.getLength()) : this.replaceComponentRange(range.getStart().getIndex().intValue(), range.getEnd().getIndex().intValue() - 1, dti.getDataType(), dti.getLength());
        }
        return dtc;
    }

    protected abstract DataTypeComponent replace(int var1, DataType var2, int var3, String var4, String var5) throws InvalidDataTypeException;

    protected abstract boolean replaceRange(int var1, int var2, DataType var3, int var4, TaskMonitor var5) throws InvalidDataTypeException, InsufficientBytesException, CancelledException;

    @Override
    public DataTypeComponent replace(int rowIndex, DataType datatype, int length) throws UsrException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if (rowIndex == this.getNumComponents()) {
            return this.insert(rowIndex, datatype, length);
        }
        DataTypeComponent oldDtc = this.getComponent(rowIndex);
        if (oldDtc == null) {
            return null;
        }
        this.checkIsAllowableDataType(datatype);
        int oldCompSize = oldDtc.getLength();
        int newCompSize = length;
        int sizeDiff = newCompSize - oldCompSize;
        if (sizeDiff > 0 && !this.checkForReplace(rowIndex, datatype)) {
            throw new InvalidDataTypeException(datatype.getDisplayName() + " doesn't fit.");
        }
        DataTypeComponent dtc = this.replace(rowIndex, datatype, newCompSize, oldDtc.getFieldName(), oldDtc.getComment());
        this.fixSelection();
        this.componentEdited();
        this.selectionChanged();
        return dtc;
    }

    protected DataTypeComponent replaceComponentRange(int startRowIndex, int endRowIndex, DataType datatype, int length) throws UsrException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if (!this.isShowingUndefinedBytes() && startRowIndex == this.getNumComponents()) {
            return this.insert(startRowIndex, datatype, length);
        }
        DataTypeComponent oldDtc = this.getComponent(startRowIndex);
        if (oldDtc == null) {
            throw new AssertException();
        }
        this.checkIsAllowableDataType(datatype);
        TaskMonitor monitor = TaskMonitor.DUMMY;
        this.replaceRange(startRowIndex, endRowIndex, datatype, length, monitor);
        DataTypeComponent dtc = this.getComponent(startRowIndex);
        try {
            dtc.setFieldName(oldDtc.getFieldName());
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, null, (String)"Unexcected Exception", (Object)"Exception applying field name", (Throwable)e);
        }
        dtc.setComment(oldDtc.getComment());
        this.fixSelection();
        this.componentEdited();
        this.selectionChanged();
        return dtc;
    }

    boolean checkForReplace(int rowIndex, DataType datatype) {
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc == null) {
            return false;
        }
        if (!this.isShowingUndefinedBytes()) {
            return true;
        }
        DataTypeComponent comp = this.getComponent(rowIndex);
        int currentCompSize = comp.getLength();
        int newCompSize = datatype.getLength();
        int sizeDiff = newCompSize - currentCompSize;
        int numUndefs = 0;
        if (sizeDiff > 0) {
            if (this.isAtEnd(rowIndex) || this.onlyUndefinedsUntilEnd(rowIndex + 1)) {
                return true;
            }
            numUndefs = this.getNumUndefinedBytesAt(rowIndex + 1);
        }
        return sizeDiff <= numUndefs;
    }

    protected abstract void replaceOriginalComponents();

    @Override
    protected void checkIsAllowableDataType(DataType datatype) throws InvalidDataTypeException {
        super.checkIsAllowableDataType(datatype);
        if (datatype.equals(this.viewComposite)) {
            String msg = "Data type \"" + datatype.getDisplayName() + "\" can't contain itself.";
            throw new InvalidDataTypeException(msg);
        }
        if (DataTypeUtilities.isSecondPartOfFirst((DataType)datatype, (DataType)this.viewComposite)) {
            String msg = "Data type \"" + datatype.getDisplayName() + "\" has \"" + this.viewComposite.getDisplayName() + "\" within it.";
            throw new InvalidDataTypeException(msg);
        }
    }

    private boolean shiftComponentsUp(int startRowIndex, int endRowIndex) {
        int numComps = this.getNumComponents();
        if (startRowIndex > endRowIndex || startRowIndex <= 0 || startRowIndex >= numComps || endRowIndex <= 0 || endRowIndex >= numComps) {
            return false;
        }
        DataTypeComponent comp = this.getComponent(startRowIndex - 1);
        this.deleteComponent(startRowIndex - 1);
        try {
            this.insert(endRowIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        return true;
    }

    private boolean shiftComponentsDown(int startRowIndex, int endRowIndex) {
        int numComps = this.getNumComponents();
        if (startRowIndex > endRowIndex || startRowIndex < 0 || startRowIndex >= numComps - 1 || endRowIndex < 0 || endRowIndex >= numComps - 1) {
            return false;
        }
        DataTypeComponent comp = this.getComponent(endRowIndex + 1);
        this.deleteComponent(endRowIndex + 1);
        try {
            this.insert(startRowIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean moveUp() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startIndex = range.getStart().getIndex().intValue();
        int endIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endIndex - startIndex + 1;
        boolean moved = false;
        int newIndex = startIndex - 1;
        moved = this.shiftComponentsUp(startIndex, endIndex);
        if (moved) {
            this.componentEdited();
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public boolean moveDown() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startIndex = range.getStart().getIndex().intValue();
        int endIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endIndex - startIndex + 1;
        boolean moved = false;
        int newIndex = startIndex + 1;
        moved = this.shiftComponentsDown(startIndex, endIndex);
        if (moved) {
            this.componentEdited();
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public void duplicateMultiple(int rowIndex, int multiple, TaskMonitor monitor) throws UsrException {
        DataTypeComponent originalComp = this.getComponent(rowIndex);
        DataType dt = originalComp.getDataType();
        int dtLen = originalComp.getLength();
        this.insertComponentMultiple(rowIndex + 1, dt, dtLen, multiple, monitor);
        this.setSelection(new int[]{rowIndex + multiple});
        this.componentEdited();
        this.lastNumDuplicates = multiple;
    }

    @Override
    public abstract void clearComponents(int[] var1) throws UsrException;

    @Override
    protected void createArray(int numElements) throws InvalidDataTypeException, UsrException {
        if (this.selection.getNumRanges() != 1) {
            throw new UsrException("Can only create arrays on a contiguous selection.");
        }
        int rowIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        DataTypeComponent comp = this.getComponent(rowIndex);
        if (comp == null) {
            throw new UsrException("A component must be selected.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        DataType dt = comp.getDataType();
        ArrayDataType array = new ArrayDataType(dt, numElements, comp.getLength(), this.viewDTM);
        if (this.getNumSelectedComponentRows() > 1) {
            this.replaceComponentRange(rowIndex, this.selection.getFieldRange(0).getEnd().getIndex().intValue() - 1, (DataType)array, array.getLength());
        } else {
            this.replace(rowIndex, (DataType)array, array.getLength());
        }
    }

    protected int getNumUndefinedBytesAt(int rowIndex) {
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex >= numRowComponents) {
            return 0;
        }
        DataTypeComponent startComponent = this.getComponent(rowIndex);
        int previousOffset = startComponent != null ? startComponent.getOffset() : 0;
        for (int currentRowIndex = rowIndex; currentRowIndex < numRowComponents; ++currentRowIndex) {
            DataTypeComponent comp = this.getComponent(currentRowIndex);
            DataType dt = comp.getDataType();
            int currentOffset = comp.getOffset();
            if (dt.equals(DataType.DEFAULT)) continue;
            return currentOffset - previousOffset;
        }
        return this.viewComposite.getLength() - previousOffset;
    }

    protected boolean isAtEnd(int rowIndex) {
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0) {
            return false;
        }
        if (rowIndex >= numRowComponents) {
            return true;
        }
        return rowIndex + 1 == numRowComponents;
    }

    protected boolean onlyUndefinedsUntilEnd(int rowIndex) {
        if (!this.isShowingUndefinedBytes()) {
            return false;
        }
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0) {
            return false;
        }
        if (rowIndex >= numRowComponents) {
            return false;
        }
        for (int i = rowIndex; i < numRowComponents; ++i) {
            DataTypeComponent comp = this.getComponent(i);
            DataType dt = comp.getDataType();
            if (dt.equals(DataType.DEFAULT)) continue;
            return false;
        }
        return true;
    }

    protected int consumeByComponent(int rowIndex) {
        int numComps = this.viewComposite.getNumComponents();
        if (rowIndex >= 0 && rowIndex < numComps) {
            DataTypeComponent comp = this.viewComposite.getComponent(rowIndex);
            int compLen = comp.getLength();
            DataType dt = comp.getDataType();
            int dtLen = dt.getLength();
            if (dtLen > compLen) {
                this.viewComposite.dataTypeSizeChanged(dt);
                comp = this.viewComposite.getComponent(rowIndex);
                int diff = comp.getLength() - compLen;
                if (diff > 0) {
                    int first = rowIndex + 1;
                    int last = rowIndex + diff;
                    this.selection.removeRange(first, last);
                    this.adjustSelection(first, 0 - diff);
                }
                return diff;
            }
        }
        return 0;
    }

    protected int consumeUndefinedBytes(int rowIndex, int numDesired) throws NoSuchElementException, InvalidDataTypeException {
        if (numDesired <= 0) {
            return 0;
        }
        int numRowComponents = this.getNumComponents();
        int numAvailable = this.getNumUndefinedBytesAt(rowIndex);
        int numIndicesRemoved = 0;
        if (numDesired > numAvailable) {
            throw new InvalidDataTypeException("Not enough undefined bytes.");
        }
        int numBytesNeeded = numDesired;
        if (rowIndex >= numRowComponents) {
            throw new NoSuchElementException();
        }
        for (int i = rowIndex; i < numRowComponents; ++i) {
            DataTypeComponent comp = this.viewComposite.getComponent(rowIndex);
            DataType dt = comp.getDataType();
            int compLength = 0;
            if (dt != DataType.DEFAULT) {
                throw new InvalidDataTypeException("Not enough undefined bytes.");
            }
            compLength = comp.getLength();
            if (compLength < numBytesNeeded) {
                numBytesNeeded -= compLength;
                this.deleteComponent(rowIndex);
                ++numIndicesRemoved;
                continue;
            }
            int leftOverBytes = compLength - numBytesNeeded;
            this.deleteComponent(rowIndex);
            ++numIndicesRemoved;
            if (leftOverBytes == 1) {
                this.insert(rowIndex, DataType.DEFAULT, 1, null, null);
                --numIndicesRemoved;
                break;
            }
            if (leftOverBytes <= 1) break;
            ArrayDataType newDt = new ArrayDataType(DataType.DEFAULT, leftOverBytes, 1, this.viewDTM);
            this.insert(rowIndex, (DataType)newDt, leftOverBytes, null, null);
            --numIndicesRemoved;
            break;
        }
        return numIndicesRemoved;
    }

    @Override
    public int getRowCount() {
        int numRows = 0;
        if (this.viewComposite != null) {
            numRows = this.viewComposite.getNumComponents();
        }
        if (!this.isShowingUndefinedBytes()) {
            ++numRows;
        }
        return numRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int modelColumnIndex) {
        try {
            this.settingValueAt = true;
            if (this.fieldEdited(aValue, rowIndex, modelColumnIndex)) {
                this.componentEdited();
            }
        }
        finally {
            this.settingValueAt = false;
        }
    }

    @Override
    public void setComponentDataTypeInstance(int rowIndex, DataType dt, int length) throws UsrException {
        if (this.getComponent(rowIndex) == null) {
            this.insert(rowIndex, dt, length);
        } else {
            this.replace(rowIndex, dt, length);
        }
    }

    @Override
    public void validateComponentName(int rowIndex, String name) throws UsrException {
        if (this.nameExistsElsewhere(name, rowIndex)) {
            throw new InvalidNameException("Name \"" + name + "\" already exists.");
        }
    }

    @Override
    public boolean setComponentName(int rowIndex, String name) throws InvalidNameException {
        String oldName = this.getComponent(rowIndex).getFieldName();
        if (Objects.equals(oldName, name)) {
            return false;
        }
        if (this.nameExistsElsewhere(name, rowIndex)) {
            throw new InvalidNameException("Name \"" + name + "\" already exists.");
        }
        try {
            this.getComponent(rowIndex).setFieldName(name);
            return true;
        }
        catch (DuplicateNameException exc) {
            throw new InvalidNameException(exc.getMessage());
        }
    }

    @Override
    public boolean setComponentComment(int rowIndex, String comment) {
        String oldComment = this.getComponent(rowIndex).getComment();
        String newComment = comment;
        if (newComment.equals("")) {
            newComment = null;
        }
        if (Objects.equals(oldComment, newComment)) {
            return false;
        }
        this.getComponent(rowIndex).setComment(newComment);
        this.fireTableCellUpdated(rowIndex, this.getCommentColumn());
        this.componentDataChanged();
        return true;
    }

    @Override
    public boolean isMoveUpAllowed() {
        if (!this.isContiguousSelection()) {
            return false;
        }
        int start = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        return start > 0 && start < this.getNumComponents();
    }

    @Override
    public boolean isMoveDownAllowed() {
        return this.isContiguousSelection() && this.selection.getFieldRange(0).getEnd().getIndex().intValue() < this.getNumComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
        block21: {
            try {
                DataTypeManager originalDTM = this.getOriginalDataTypeManager();
                if (originalDTM == null) {
                    return;
                }
                if (dtm instanceof CompositeViewerDataTypeManager) {
                    this.componentEdited();
                    return;
                }
                if (dtm != originalDTM) {
                    return;
                }
                if (!this.isLoaded()) {
                    return;
                }
                String oldName = path.getDataTypeName();
                if (path.equals((Object)this.originalDataTypePath)) {
                    if (this.consideringReplacedDataType) {
                        return;
                    }
                    if (this.originalIsChanging) {
                        return;
                    }
                    this.originalIsChanging = true;
                    try {
                        if (this.hadChanges) {
                            String message = "<html>" + HTMLUtilities.escapeHTML((String)oldName) + " has changed outside the editor.<br>Discard edits & reload the " + this.getTypeName() + "?";
                            String title = "Reload " + this.getTypeName() + " Editor?";
                            int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)message);
                            if (response == 1) {
                                this.load(this.getOriginalComposite());
                            }
                        } else {
                            Composite changedComposite = this.getOriginalComposite();
                            if (changedComposite != null && !this.viewComposite.isEquivalent((DataType)changedComposite)) {
                                this.load(this.getOriginalComposite());
                                this.setStatus(this.viewComposite.getPathName() + " changed outside the editor.", false);
                            }
                        }
                        break block21;
                    }
                    finally {
                        this.originalIsChanging = false;
                    }
                }
                DataType viewDt = this.viewDTM.getDataType(path);
                if (viewDt == null) {
                    return;
                }
                int origDtLen = viewDt.getLength();
                DataType changedDt = dtm.getDataType(path);
                if (changedDt != null) {
                    if (viewDt instanceof Composite && changedDt instanceof Composite) {
                        Composite comp = (Composite)changedDt;
                        Composite origDt = this.getOriginalComposite();
                        if (origDt != null && comp.isPartOf((DataType)origDt)) {
                            this.removeDtFromComponents(comp);
                        }
                        ((Composite)viewDt).setDescription(((Composite)changedDt).getDescription());
                    }
                    if (origDtLen != (viewDt = this.viewDTM.resolve(changedDt, DataTypeConflictHandler.REPLACE_HANDLER)).getLength()) {
                        this.viewComposite.dataTypeSizeChanged(viewDt);
                    }
                }
                this.fireTableDataChanged();
                this.componentDataChanged();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (!this.isLoaded()) {
            return;
        }
        String dtName = oldPath.getDataTypeName();
        DataTypePath dtPath = new DataTypePath(newDataType.getCategoryPath(), dtName);
        if (!dtPath.equals((Object)this.originalDataTypePath)) {
            DataType dt = this.viewDTM.getDataType(dtPath);
            if (dt == null) return;
            if (this.hasSubDt(this.viewComposite, dtPath)) {
                String msg = "Replaced data type \"" + dtPath + "\", which is a sub-component of \"" + this.getOriginalDataTypeName() + "\".";
                this.setStatus(msg, true);
            }
            try {
                this.viewDTM.replaceDataType(dt, newDataType, true);
            }
            catch (DataTypeDependencyException e) {
                throw new AssertException((Throwable)e);
            }
            this.fireTableDataChanged();
            this.componentDataChanged();
            return;
        }
        if (this.hadChanges) {
            if (this.originalDataTypePath.equals((Object)oldPath)) {
                if (this.hadChanges) {
                    this.consideringReplacedDataType = true;
                    try {
                        String message = "<html>" + HTMLUtilities.escapeHTML((String)oldPath.getPath()) + " has changed outside the editor.<br>Discard edits & reload the " + this.getTypeName() + "?";
                        String title = "Reload " + this.getTypeName() + " Editor?";
                        int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)message);
                        if (response != 1) return;
                        this.load(this.getOriginalComposite());
                        return;
                    }
                    finally {
                        this.consideringReplacedDataType = false;
                    }
                } else {
                    this.load(this.getOriginalComposite());
                    this.setStatus(this.viewComposite.getPathName() + " changed outside the editor.", false);
                }
                return;
            } else {
                String msg = "\"" + oldPath.getPath() + "\" was replaced with " + newDataType.getPathName() + " in the data type manager.";
                this.setStatus(msg, true);
            }
            return;
        } else {
            this.load((Composite)newDataType);
        }
    }

    abstract void removeDtFromComponents(Composite var1);

    @Override
    public void fireTableDataChanged() {
        this.updatingSelection(() -> {
            super.fireTableDataChanged();
            this.selectionChanged();
        });
    }

    @Override
    public int getMaxDuplicates(int rowIndex) {
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex >= numRowComponents) {
            return 0;
        }
        if (rowIndex + 1 == numRowComponents) {
            return Integer.MAX_VALUE;
        }
        DataType dt = this.getComponent(rowIndex).getDataType();
        int maxDups = Integer.MAX_VALUE;
        if (this.isShowingUndefinedBytes() && dt != DataType.DEFAULT) {
            int numBytes = this.getNumUndefinedBytesAt(rowIndex + 1);
            maxDups = numBytes / dt.getLength();
        }
        return maxDups;
    }

    @Override
    public int getMaxElements() {
        if (!this.isContiguousSelection()) {
            return 0;
        }
        int rowIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        if (rowIndex < this.getNumComponents()) {
            boolean singleLineSelection;
            DataTypeComponent comp = this.getComponent(rowIndex);
            DataType dt = comp.getDataType();
            int len = dt.getLength() > 0 ? dt.getLength() : comp.getLength();
            FieldRange range = this.getSelectedRangeContaining(rowIndex);
            boolean bl = singleLineSelection = this.getNumSelectedComponentRows() == 1;
            if (range != null && !singleLineSelection) {
                int numBytesInRange = this.getNumBytesInRange(range);
                return numBytesInRange / len;
            }
            if (!this.isShowingUndefinedBytes() || this.isAtEnd(rowIndex) || this.onlyUndefinedsUntilEnd(rowIndex + 1)) {
                return Integer.MAX_VALUE;
            }
            int numBytes = this.getNumUndefinedBytesAt(rowIndex + 1);
            return 1 + numBytes / len;
        }
        return 0;
    }

    @Override
    public int getLastNumDuplicates() {
        return this.lastNumDuplicates;
    }

    void componentEdited() {
        this.updateAndCheckChangeState();
        this.fireTableDataChanged();
        this.componentDataChanged();
    }

    protected int convertRowToOrdinal(int rowIndex) {
        return rowIndex;
    }

    protected boolean isSizeEditable() {
        return false;
    }

    @Override
    public boolean updateAndCheckChangeState() {
        if (this.originalIsChanging) {
            return false;
        }
        boolean compositeChanged = super.updateAndCheckChangeState();
        if (compositeChanged) {
            return true;
        }
        Composite oldComposite = this.getOriginalComposite();
        if (oldComposite == null) {
            this.hadChanges = false;
            return this.hadChanges;
        }
        PackingType packingType = this.getPackingType();
        AlignmentType alignmentType = this.getAlignmentType();
        this.hadChanges = packingType != oldComposite.getPackingType() || alignmentType != oldComposite.getAlignmentType() || packingType == PackingType.EXPLICIT && this.getExplicitPackingValue() != oldComposite.getExplicitPackingValue() || alignmentType == AlignmentType.EXPLICIT && this.getExplicitMinimumAlignment() != oldComposite.getExplicitMinimumAlignment();
        return this.hadChanges;
    }

    public AlignmentType getAlignmentType() {
        return this.viewComposite.getAlignmentType();
    }

    public int getExplicitMinimumAlignment() {
        return this.viewComposite.getExplicitMinimumAlignment();
    }

    public void setAlignmentType(AlignmentType alignmentType, int explicitValue) {
        AlignmentType currentAlignType = this.getAlignmentType();
        if (alignmentType == AlignmentType.DEFAULT) {
            if (currentAlignType == AlignmentType.DEFAULT) {
                return;
            }
            this.viewComposite.setToDefaultAligned();
        } else if (alignmentType == AlignmentType.MACHINE) {
            if (currentAlignType == AlignmentType.MACHINE) {
                return;
            }
            this.viewComposite.setToMachineAligned();
        } else {
            if (currentAlignType == AlignmentType.EXPLICIT && explicitValue == this.viewComposite.getExplicitMinimumAlignment()) {
                return;
            }
            this.viewComposite.setExplicitMinimumAlignment(explicitValue);
        }
        if (this.fixSelection()) {
            this.selectionChanged();
        }
        this.notifyCompositeChanged();
    }

    public boolean isPackingEnabled() {
        return this.viewComposite.isPackingEnabled();
    }

    public PackingType getPackingType() {
        return this.viewComposite.getPackingType();
    }

    public int getExplicitPackingValue() {
        return this.viewComposite.getExplicitPackingValue();
    }

    public void setPackingType(PackingType packingType, int explicitValue) {
        PackingType currentPacktype = this.getPackingType();
        if (packingType == PackingType.DISABLED) {
            if (currentPacktype == PackingType.DISABLED) {
                return;
            }
            this.viewComposite.setPackingEnabled(false);
        } else if (packingType == PackingType.DEFAULT) {
            if (currentPacktype == PackingType.DEFAULT) {
                return;
            }
            this.viewComposite.setToDefaultPacking();
        } else {
            if (currentPacktype == PackingType.EXPLICIT && explicitValue == this.viewComposite.getExplicitPackingValue()) {
                return;
            }
            this.viewComposite.setExplicitPackingValue(explicitValue);
        }
        if (this.fixSelection()) {
            this.selectionChanged();
        }
        this.notifyCompositeChanged();
    }

    public int getActualAlignment() {
        return this.viewComposite.getAlignment();
    }
}

