/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import javax.swing.JComponent;

public class FunctionNameListingHover
extends AbstractConfigurableHover
implements ListingHoverService {
    private static final String NAME = "Function Name Display";
    private static final String DESCRIPTION = "Toggle whether the full symbol name is shown as a tooltip.  This only applies when displaying namespaces.";
    private static final int PRIORITY = 20;

    public FunctionNameListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getOptionsCategory() {
        return "Listing Popups";
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        if (!(programLocation instanceof LabelFieldLocation)) {
            return null;
        }
        Symbol symbol = ((LabelFieldLocation)programLocation).getSymbol();
        if (this.isLocalFunctionSymbol(program, symbol)) {
            return this.createTooltipComponent(symbol.getName(true));
        }
        return null;
    }

    private boolean isLocalFunctionSymbol(Program program, Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        Namespace parentScope = symbol.getParentNamespace();
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType != SymbolType.LABEL) {
            return false;
        }
        if (parentScope.getID() == 0L) {
            return false;
        }
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionContaining(symbol.getAddress());
        if (function == null) {
            return false;
        }
        return function.getName().equals(parentScope.getName());
    }
}

