/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.GhidraOptions;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPluginInterface;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.CodeFormatService;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.CoordinatedListingPanelListener;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.services.ViewManagerService;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.ProgramDropProvider;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.options.ListingDisplayOptionsEditor;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.ManualViewerCommandEditor;
import ghidra.util.ManualViewerCommandWrappedOption;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.beans.PropertyEditor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractCodeBrowserPlugin<P extends CodeViewerProvider>
extends Plugin
implements CodeViewerService,
CodeFormatService,
OptionsChangeListener,
FormatModelListener,
DomainObjectListener,
CodeBrowserPluginInterface {
    private static final String CURSOR_COLOR_OPTIONS_NAME = "Cursor.Cursor Color - Focused";
    private static final String UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME = "Cursor.Cursor Color - Unfocused";
    private static final String BLINK_CURSOR_OPTIONS_NAME = "Cursor.Blink Cursor";
    private static final String MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME = "Mouse.Horizontal Scrolling";
    private static final GColor FOCUSED_CURSOR_COLOR = new GColor("color.cursor.focused.listing");
    private static final GColor UNFOCUSED_CURSOR_COLOR = new GColor("color.cursor.unfocused.listing");
    private static final GColor CURRENT_LINE_HIGHLIGHT_COLOR = new GColor("color.bg.currentline.listing");
    private static final Icon CURSOR_LOC_ICON = new GIcon("icon.plugin.codebrowser.cursor.location");
    protected final P connectedProvider;
    protected List<P> disconnectedProviders = new ArrayList<P>();
    protected FormatManager formatMgr;
    protected ViewManagerService viewManager;
    private MarkerService markerService;
    protected AddressSetView currentView;
    protected Program currentProgram;
    private boolean selectionChanging;
    private MarkerSet currentSelectionMarkers;
    private MarkerSet currentHighlightMarkers;
    private MarkerSet currentCursorMarkers;
    private ChangeListener markerChangeListener;
    private Color cursorHighlightColor;
    private boolean isHighlightCursorLine;
    private ProgramDropProvider dndProvider;

    public AbstractCodeBrowserPlugin(PluginTool tool) {
        super(tool);
        ToolOptions displayOptions = tool.getOptions("Listing Display");
        ToolOptions fieldOptions = tool.getOptions("Listing Fields");
        displayOptions.registerOptionsEditor((OptionsEditor)new ListingDisplayOptionsEditor((Options)displayOptions));
        displayOptions.setOptionsHelpLocation(new HelpLocation(this.getName(), "Listing Display"));
        fieldOptions.setOptionsHelpLocation(new HelpLocation(this.getName(), "Listing Display"));
        this.formatMgr = new FormatManager(displayOptions, fieldOptions);
        this.formatMgr.addFormatModelListener(this);
        this.formatMgr.setServiceProvider((ServiceProvider)tool);
        this.connectedProvider = this.createProvider(this.formatMgr, true);
        tool.showComponentProvider(this.connectedProvider, true);
        this.initOptions((Options)fieldOptions);
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().setTextBackgroundColor((Color)ListingColors.BACKGROUND);
        this.initMiscellaneousOptions();
        displayOptions.addOptionsChangeListener((OptionsChangeListener)this);
        fieldOptions.addOptionsChangeListener((OptionsChangeListener)this);
        tool.setDefaultComponent(this.connectedProvider);
        this.markerChangeListener = new MarkerChangeListener((CodeViewerProvider)this.connectedProvider);
    }

    protected abstract P createProvider(FormatManager var1, boolean var2);

    protected void viewChanged(AddressSetView addrSet) {
        ProgramLocation currLoc = this.getCurrentLocation();
        this.currentView = addrSet;
        if (addrSet != null && !addrSet.isEmpty()) {
            ((CodeViewerProvider)this.connectedProvider).setView(addrSet);
            if (currLoc != null && addrSet.contains(currLoc.getAddress())) {
                this.goTo(currLoc, true);
            }
        } else {
            ((CodeViewerProvider)this.connectedProvider).setView((AddressSetView)new AddressSet());
        }
        this.updateBackgroundColorModel();
        this.setHighlight(((CodeViewerProvider)this.connectedProvider).getHighlight());
        this.setSelection(((CodeViewerProvider)this.connectedProvider).getSelection());
    }

    protected void init() {
        ClipboardService clipboardService;
        this.markerService = (MarkerService)this.tool.getService(MarkerService.class);
        if (this.markerService != null) {
            this.markerService.addChangeListener(this.markerChangeListener);
        }
        this.updateBackgroundColorModel();
        if (this.viewManager == null) {
            this.viewManager = (ViewManagerService)this.tool.getService(ViewManagerService.class);
        }
        if ((clipboardService = (ClipboardService)this.tool.getService(ClipboardService.class)) != null) {
            ((CodeViewerProvider)this.connectedProvider).setClipboardService(clipboardService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.setClipboardService(clipboardService);
            }
        }
    }

    protected void updateBackgroundColorModel() {
        ListingPanel listingPanel = ((CodeViewerProvider)this.connectedProvider).getListingPanel();
        if (this.markerService != null) {
            AddressIndexMap indexMap = ((CodeViewerProvider)this.connectedProvider).getListingPanel().getAddressIndexMap();
            listingPanel.setBackgroundColorModel(new MarkerServiceBackgroundColorModel(this.markerService, indexMap));
        } else {
            listingPanel.setBackgroundColorModel(null);
        }
    }

    public P createNewDisconnectedProvider() {
        ListingHoverService[] hoverServices;
        P newProvider = this.createProvider(this.formatMgr.createClone(), false);
        ((CodeViewerProvider)newProvider).setClipboardService((ClipboardService)this.tool.getService(ClipboardService.class));
        this.disconnectedProviders.add(newProvider);
        if (this.dndProvider != null) {
            ((CodeViewerProvider)newProvider).addProgramDropProvider(this.dndProvider);
        }
        this.tool.showComponentProvider(newProvider, true);
        for (ListingHoverService hoverService : hoverServices = (ListingHoverService[])this.tool.getServices(ListingHoverService.class)) {
            ((CodeViewerProvider)newProvider).getListingPanel().addHoverService(hoverService);
        }
        return newProvider;
    }

    protected void setHighlight(FieldSelection highlight) {
        MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
        if (highlight != null && !highlight.isEmpty()) {
            ListingPanel listingPanel = ((CodeViewerProvider)this.connectedProvider).getListingPanel();
            ProgramSelection programHighlight = listingPanel.getProgramSelection(highlight);
            ((CodeViewerProvider)this.connectedProvider).setHighlight(programHighlight);
            this.firePluginEvent(new ProgramHighlightPluginEvent(this.getName(), programHighlight, this.currentProgram));
            if (highlightMarkers != null) {
                highlightMarkers.clearAll();
                highlightMarkers.add(programHighlight);
            }
        } else {
            ((CodeViewerProvider)this.connectedProvider).setHighlight(new ProgramSelection());
            if (highlightMarkers != null) {
                highlightMarkers.clearAll();
            }
        }
    }

    protected void removeProvider(CodeViewerProvider provider) {
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == ViewManagerService.class && this.viewManager == null) {
            this.viewManager = (ViewManagerService)service;
            this.viewChanged(this.viewManager.getCurrentView());
        }
        if (interfaceClass == MarkerService.class && this.markerService == null) {
            this.markerService = (MarkerService)this.tool.getService(MarkerService.class);
            this.markerService.addChangeListener(this.markerChangeListener);
            this.updateBackgroundColorModel();
            if (this.viewManager != null) {
                this.viewChanged(this.viewManager.getCurrentView());
            }
        }
        if (interfaceClass == ListingHoverService.class) {
            ListingHoverService hoverService = (ListingHoverService)service;
            ((CodeViewerProvider)this.connectedProvider).getListingPanel().addHoverService(hoverService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.getListingPanel().addHoverService(hoverService);
            }
            ListingPanel otherPanel = ((CodeViewerProvider)this.connectedProvider).getOtherPanel();
            if (otherPanel != null) {
                otherPanel.addHoverService(hoverService);
            }
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (service == this.viewManager && this.currentProgram != null) {
            this.viewManager = null;
            this.viewChanged((AddressSetView)this.currentProgram.getMemory());
        }
        if (service == this.markerService) {
            this.markerService.removeChangeListener(this.markerChangeListener);
            this.clearMarkers(this.currentProgram);
            this.markerService = null;
            this.updateBackgroundColorModel();
        }
        if (interfaceClass == ListingHoverService.class) {
            ListingHoverService hoverService = (ListingHoverService)service;
            ((CodeViewerProvider)this.connectedProvider).getListingPanel().removeHoverService(hoverService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.getListingPanel().removeHoverService(hoverService);
            }
            ListingPanel otherPanel = ((CodeViewerProvider)this.connectedProvider).getOtherPanel();
            if (otherPanel != null) {
                otherPanel.removeHoverService(hoverService);
            }
        }
    }

    @Override
    public void addOverviewProvider(OverviewProvider overviewProvider) {
        ((CodeViewerProvider)this.connectedProvider).addOverviewProvider(overviewProvider);
    }

    @Override
    public void addMarginProvider(MarginProvider marginProvider) {
        ((CodeViewerProvider)this.connectedProvider).addMarginProvider(marginProvider);
    }

    @Override
    public void removeOverviewProvider(OverviewProvider overviewProvider) {
        ((CodeViewerProvider)this.connectedProvider).removeOverviewProvider(overviewProvider);
    }

    @Override
    public void removeMarginProvider(MarginProvider marginProvider) {
        ((CodeViewerProvider)this.connectedProvider).removeMarginProvider(marginProvider);
    }

    @Override
    public void addLocalAction(DockingAction action) {
        this.tool.addLocalAction(this.connectedProvider, (DockingActionIf)action);
    }

    @Override
    public void removeLocalAction(DockingAction action) {
        if (this.tool != null) {
            this.tool.removeLocalAction(this.connectedProvider, (DockingActionIf)action);
        }
    }

    @Override
    public void addProgramDropProvider(ProgramDropProvider dnd) {
        this.dndProvider = dnd;
        ((CodeViewerProvider)this.connectedProvider).addProgramDropProvider(dnd);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            provider.addProgramDropProvider(dnd);
        }
    }

    @Override
    public void addButtonPressedListener(ButtonPressedListener listener) {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().addButtonPressedListener(listener);
    }

    @Override
    public void removeButtonPressedListener(ButtonPressedListener listener) {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().removeButtonPressedListener(listener);
    }

    @Override
    public void removeHighlightProvider(ListingHighlightProvider highlightProvider, Program highlightProgram) {
        ((CodeViewerProvider)this.connectedProvider).removeHighlightProvider(highlightProvider, highlightProgram);
    }

    @Override
    public void setHighlightProvider(ListingHighlightProvider highlightProvider, Program highlightProgram) {
        ((CodeViewerProvider)this.connectedProvider).setHighlightProvider(highlightProvider, highlightProgram);
    }

    protected void updateHighlightProvider() {
        ((CodeViewerProvider)this.connectedProvider).updateHighlightProvider();
    }

    @Override
    public void setListingPanel(ListingPanel lp) {
        ((CodeViewerProvider)this.connectedProvider).setPanel(lp);
        this.viewChanged(this.currentView);
    }

    @Override
    public void setCoordinatedListingPanelListener(CoordinatedListingPanelListener listener) {
        ((CodeViewerProvider)this.connectedProvider).setCoordinatedListingPanelListener(listener);
    }

    @Override
    public void setNorthComponent(JComponent comp) {
        ((CodeViewerProvider)this.connectedProvider).setNorthComponent(comp);
    }

    @Override
    public void removeListingPanel(ListingPanel lp) {
        if (this.isDisposed()) {
            return;
        }
        if (((CodeViewerProvider)this.connectedProvider).getOtherPanel() == lp) {
            ((CodeViewerProvider)this.connectedProvider).clearPanel();
            this.viewChanged(this.currentView);
        }
    }

    protected void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.clearMarkers(this.currentProgram);
        this.formatMgr.dispose();
        this.removeProvider((CodeViewerProvider)this.connectedProvider);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            this.removeProvider(provider);
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        ListingPanel listingPanel = ((CodeViewerProvider)this.connectedProvider).getListingPanel();
        if (options.getName().equals("Listing Fields")) {
            FieldPanel fieldPanel = listingPanel.getFieldPanel();
            if (optionName.equals("Selection Colors.Selection Color")) {
                ListingPanel otherPanel;
                Color color = (Color)newValue;
                fieldPanel.setSelectionColor(color);
                MarkerSet selectionMarkers = this.getSelectionMarkers(this.currentProgram);
                if (selectionMarkers != null) {
                    selectionMarkers.setMarkerColor(color);
                }
                if ((otherPanel = ((CodeViewerProvider)this.connectedProvider).getOtherPanel()) != null) {
                    otherPanel.getFieldPanel().setSelectionColor(color);
                }
            } else if (optionName.equals("Selection Colors.Highlight Color")) {
                Color color = (Color)newValue;
                fieldPanel.setHighlightColor(color);
                MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
                if (highlightMarkers != null) {
                    highlightMarkers.setMarkerColor(color);
                }
            } else if (optionName.equals(CURSOR_COLOR_OPTIONS_NAME)) {
                Color color = (Color)newValue;
                fieldPanel.setFocusedCursorColor(color);
            } else if (optionName.equals(UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME)) {
                Color color = (Color)newValue;
                fieldPanel.setNonFocusCursorColor(color);
            } else if (optionName.equals(BLINK_CURSOR_OPTIONS_NAME)) {
                Boolean isBlinkCursor = (Boolean)newValue;
                fieldPanel.setBlinkCursor(isBlinkCursor);
            } else if (optionName.equals("Cursor.Highlight Cursor Line Color")) {
                this.cursorHighlightColor = (Color)newValue;
                if (this.currentCursorMarkers != null) {
                    this.currentCursorMarkers.setMarkerColor(this.cursorHighlightColor);
                }
            } else if (optionName.equals("Cursor.Highlight Cursor Line")) {
                this.isHighlightCursorLine = (Boolean)newValue;
                if (this.currentCursorMarkers != null) {
                    this.currentCursorMarkers.setColoringBackground(this.isHighlightCursorLine);
                }
            } else if (optionName.equals(MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME)) {
                fieldPanel.setHorizontalScrollingEnabled(((Boolean)newValue).booleanValue());
            }
            ((CodeViewerProvider)this.connectedProvider).fieldOptionChanged(optionName, newValue);
        }
    }

    @Override
    public void selectionChanged(CodeViewerProvider provider, ProgramSelection selection) {
        if (provider == this.connectedProvider) {
            MarkerSet selectionMarkers = this.getSelectionMarkers(this.currentProgram);
            if (selectionMarkers != null) {
                selectionMarkers.clearAll();
            }
            if (selection != null && selectionMarkers != null) {
                selectionMarkers.add(selection);
            }
            if (!this.selectionChanging) {
                this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), selection, ((CodeViewerProvider)this.connectedProvider).getProgram()));
            }
        }
    }

    protected void setHighlight(ProgramSelection highlight) {
        ((CodeViewerProvider)this.connectedProvider).setHighlight(highlight);
    }

    protected void setSelection(ProgramSelection sel) {
        this.selectionChanging = true;
        ((CodeViewerProvider)this.connectedProvider).setSelection(sel);
        this.selectionChanging = false;
    }

    protected void clearMarkers(Program program) {
        if (this.markerService == null) {
            return;
        }
        if (program == null) {
            return;
        }
        if (this.currentSelectionMarkers != null) {
            this.markerService.removeMarker(this.currentSelectionMarkers, program);
            this.currentSelectionMarkers = null;
        }
        if (this.currentHighlightMarkers != null) {
            this.markerService.removeMarker(this.currentHighlightMarkers, program);
            this.currentHighlightMarkers = null;
        }
        if (this.currentCursorMarkers != null) {
            this.markerService.removeMarker(this.currentCursorMarkers, program);
            this.currentCursorMarkers = null;
        }
    }

    private MarkerSet getSelectionMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.currentSelectionMarkers != null) {
            return this.currentSelectionMarkers;
        }
        FieldPanel fp = ((CodeViewerProvider)this.connectedProvider).getListingPanel().getFieldPanel();
        this.currentSelectionMarkers = this.markerService.createAreaMarker("Selection", "Selection Display", program, 100, false, true, false, fp.getSelectionColor());
        return this.currentSelectionMarkers;
    }

    protected MarkerSet getHighlightMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.currentHighlightMarkers != null) {
            return this.currentHighlightMarkers;
        }
        FieldPanel fp = ((CodeViewerProvider)this.connectedProvider).getListingPanel().getFieldPanel();
        this.currentHighlightMarkers = this.markerService.createAreaMarker("Highlight", "Highlight Display ", program, 50, false, true, false, fp.getHighlightColor());
        return this.currentHighlightMarkers;
    }

    protected MarkerSet getCursorMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.currentCursorMarkers != null) {
            return this.currentCursorMarkers;
        }
        this.currentCursorMarkers = this.markerService.createPointMarker("Cursor", "Cursor Location", program, 200, true, true, this.isHighlightCursorLine, this.cursorHighlightColor, CURSOR_LOC_ICON);
        return this.currentCursorMarkers;
    }

    private void initOptions(Options fieldOptions) {
        HelpLocation helpLocation = new HelpLocation(this.getName(), "Selection Colors");
        fieldOptions.getOptions("Selection Colors").setOptionsHelpLocation(helpLocation);
        fieldOptions.registerThemeColorBinding("Selection Colors.Selection Color", GhidraOptions.DEFAULT_SELECTION_COLOR.getId(), helpLocation, "The selection color in the browser.");
        fieldOptions.registerThemeColorBinding("Selection Colors.Highlight Color", GhidraOptions.DEFAULT_HIGHLIGHT_COLOR.getId(), helpLocation, "The highlight color in the browser.");
        fieldOptions.registerThemeColorBinding(CURSOR_COLOR_OPTIONS_NAME, FOCUSED_CURSOR_COLOR.getId(), helpLocation, "The color of the cursor in the browser.");
        fieldOptions.registerThemeColorBinding(UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME, UNFOCUSED_CURSOR_COLOR.getId(), helpLocation, "The color of the cursor in the browser when the browser does not have focus.");
        fieldOptions.registerOption(BLINK_CURSOR_OPTIONS_NAME, (Object)true, helpLocation, "When selected, the cursor will blink when the containing window is focused.");
        fieldOptions.registerThemeColorBinding("Cursor.Highlight Cursor Line Color", CURRENT_LINE_HIGHLIGHT_COLOR.getId(), helpLocation, "The background color of the line where the cursor is located");
        fieldOptions.registerOption("Cursor.Highlight Cursor Line", (Object)true, helpLocation, "Toggles highlighting background color of line containing the cursor");
        helpLocation = new HelpLocation(this.getName(), "Keyboard_Controls_Shift");
        fieldOptions.registerOption(MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME, (Object)true, helpLocation, "Enables horizontal scrolling by holding the Shift key while using the mouse scroll wheel");
        Color color = fieldOptions.getColor("Selection Colors.Selection Color", (Color)GhidraOptions.DEFAULT_SELECTION_COLOR);
        FieldPanel fieldPanel = ((CodeViewerProvider)this.connectedProvider).getListingPanel().getFieldPanel();
        fieldPanel.setSelectionColor(color);
        MarkerSet selectionMarkers = this.getSelectionMarkers(this.currentProgram);
        if (selectionMarkers != null) {
            selectionMarkers.setMarkerColor(color);
        }
        color = fieldOptions.getColor("Selection Colors.Highlight Color", (Color)GhidraOptions.DEFAULT_HIGHLIGHT_COLOR);
        MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
        fieldPanel.setHighlightColor(color);
        if (highlightMarkers != null) {
            highlightMarkers.setMarkerColor(color);
        }
        color = fieldOptions.getColor(CURSOR_COLOR_OPTIONS_NAME, (Color)FOCUSED_CURSOR_COLOR);
        fieldPanel.setFocusedCursorColor(color);
        color = fieldOptions.getColor(UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME, (Color)UNFOCUSED_CURSOR_COLOR);
        fieldPanel.setNonFocusCursorColor(color);
        Boolean isBlinkCursor = fieldOptions.getBoolean(BLINK_CURSOR_OPTIONS_NAME, true);
        fieldPanel.setBlinkCursor(isBlinkCursor);
        boolean horizontalScrollingEnabled = fieldOptions.getBoolean(MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME, true);
        fieldPanel.setHorizontalScrollingEnabled(horizontalScrollingEnabled);
        this.cursorHighlightColor = fieldOptions.getColor("Cursor.Highlight Cursor Line Color", (Color)CURRENT_LINE_HIGHLIGHT_COLOR);
        this.isHighlightCursorLine = fieldOptions.getBoolean("Cursor.Highlight Cursor Line", true);
    }

    private void initMiscellaneousOptions() {
        HelpLocation helpLocation = new HelpLocation("ShowInstructionInfoPlugin", "Processor_Manual_Options");
        ToolOptions options = this.tool.getOptions("Processor Manuals");
        options.registerOption("Manual Viewer Options", OptionType.CUSTOM_TYPE, (Object)ManualViewerCommandWrappedOption.getDefaultBrowserLoaderOptions(), helpLocation, "Options for running manual viewer", (PropertyEditor)new ManualViewerCommandEditor());
    }

    @Override
    public void updateDisplay() {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().updateDisplay(false);
    }

    @Override
    public FieldPanel getFieldPanel() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getFieldPanel();
    }

    @Override
    public Navigatable getNavigatable() {
        return this.connectedProvider;
    }

    public void updateNow() {
        SystemUtilities.runSwingNow(() -> ((CodeViewerProvider)this.connectedProvider).getListingPanel().updateDisplay(true));
    }

    public boolean goToField(Address address, String fieldName, int row, int col) {
        return this.goToField(address, fieldName, 0, row, col, true);
    }

    public boolean goToField(Address addr, String fieldName, int occurrence, int row, int col) {
        return this.goToField(addr, fieldName, occurrence, row, col, true);
    }

    public boolean goToField(Address a, String fieldName, int occurrence, int row, int col, boolean scroll) {
        return (Boolean)Swing.runNow(() -> this.doGoToField(a, fieldName, occurrence, row, col, scroll));
    }

    private boolean doGoToField(Address a, String fieldName, int occurrence, int row, int col, boolean scroll) {
        FieldPanel fieldPanel;
        BigInteger index;
        int fieldNum;
        Swing.assertSwingThread((String)"'Go To' must be performed on the Swing thread");
        this.updateNow();
        ListingPanel panel = ((CodeViewerProvider)this.connectedProvider).getListingPanel();
        if (a == null) {
            a = this.getCurrentAddress();
        }
        if ((fieldNum = this.getFieldNumber(fieldName, occurrence, index = panel.getAddressIndexMap().getIndex(a), fieldPanel = panel.getFieldPanel())) < 0) {
            return false;
        }
        if (scroll) {
            fieldPanel.goTo(index, fieldNum, row, col, true);
        } else {
            fieldPanel.setCursorPosition(index, fieldNum, row, col);
        }
        return true;
    }

    private int getFieldNumber(String fieldName, int occurrence, BigInteger index, FieldPanel fieldPanel) {
        if (fieldName == null) {
            return -1;
        }
        int fieldNum = -1;
        LayoutModel model = fieldPanel.getLayoutModel();
        Layout layout = model.getLayout(index);
        if (layout == null) {
            return -1;
        }
        int instanceNum = 0;
        for (int i = 0; i < layout.getNumFields(); ++i) {
            ListingField bf = (ListingField)layout.getField(i);
            if (!bf.getFieldFactory().getFieldName().equals(fieldName) || instanceNum++ != occurrence) continue;
            fieldNum = i;
            break;
        }
        return fieldNum;
    }

    public Address getCurrentAddress() {
        ProgramLocation loc = this.getCurrentLocation();
        if (loc == null) {
            return null;
        }
        return this.getCurrentLocation().getAddress();
    }

    @Override
    public ProgramSelection getCurrentSelection() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getProgramSelection();
    }

    Program getCurrentProgram() {
        return this.currentProgram;
    }

    public CodeViewerProvider getProvider() {
        return this.connectedProvider;
    }

    public boolean goTo(ProgramLocation location) {
        return this.goTo(location, true);
    }

    @Override
    public boolean goTo(ProgramLocation location, boolean centerOnScreen) {
        return (Boolean)Swing.runNow(() -> ((CodeViewerProvider)this.connectedProvider).getListingPanel().goTo(location, centerOnScreen));
    }

    @Override
    public ProgramLocation getCurrentLocation() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getProgramLocation();
    }

    public FieldLocation getCurrentFieldLoction() {
        return this.getFieldPanel().getCursorLocation();
    }

    @Override
    public String getCurrentFieldTextSelection() {
        return ((CodeViewerProvider)this.connectedProvider).getStringSelection();
    }

    @Override
    public ListingField getCurrentField() {
        Field f = this.getFieldPanel().getCurrentField();
        if (f instanceof ListingField) {
            return (ListingField)f;
        }
        return null;
    }

    @Override
    public void addListingDisplayListener(AddressSetDisplayListener listener) {
        ((CodeViewerProvider)this.connectedProvider).addDisplayListener(listener);
    }

    @Override
    public void removeListingDisplayListener(AddressSetDisplayListener listener) {
        ((CodeViewerProvider)this.connectedProvider).removeDisplayListener(listener);
    }

    public String getCurrentFieldText() {
        ListingField lf = this.getCurrentField();
        if (lf instanceof ListingTextField) {
            return ((ListingTextField)lf).getText();
        }
        return "";
    }

    @Override
    public AddressSetView getView() {
        return this.currentView;
    }

    @Override
    public FormatManager getFormatManager() {
        return this.formatMgr;
    }

    public void toggleOpen(Data data) {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().getListingModel().toggleOpen(data);
    }

    @Override
    public AddressIndexMap getAddressIndexMap() {
        return this.getListingPanel().getAddressIndexMap();
    }

    @Override
    public ListingPanel getListingPanel() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel();
    }

    Address getAddressTopOfScreen() {
        BigInteger index = this.getFieldPanel().getViewerPosition().getIndex();
        return this.getAddressIndexMap().getAddress(index);
    }

    @Override
    public void formatModelAdded(FieldFormatModel model) {
    }

    @Override
    public void formatModelRemoved(FieldFormatModel model) {
    }

    @Override
    public void formatModelChanged(FieldFormatModel model) {
        this.tool.setConfigChanged(true);
    }

    @Override
    public ListingModel getListingModel() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getListingModel().copy();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(2)) {
            ((CodeViewerProvider)this.connectedProvider).updateTitle();
        }
        if (this.viewManager != null) {
            return;
        }
        if (ev.containsEvent(4)) {
            this.viewChanged((AddressSetView)this.currentProgram.getMemory());
        }
    }

    @Override
    public void providerClosed(CodeViewerProvider codeViewerProvider) {
        this.removeProvider(codeViewerProvider);
        if (!codeViewerProvider.isConnected()) {
            this.disconnectedProviders.remove(codeViewerProvider);
        }
    }

    static class MarkerChangeListener
    implements ChangeListener {
        private FieldPanel fieldPanel;

        MarkerChangeListener(CodeViewerProvider provider) {
            this.fieldPanel = provider.getListingPanel().getFieldPanel();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fieldPanel.repaint();
        }
    }
}

