/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;

public class CreateDataBackgroundCmd
extends BackgroundCommand {
    private static final int EVENT_LIMIT = 1000;
    private AddressSetView addrSet;
    private DataType newDataType;
    private int bytesApplied = 0;
    private int numDataCreated = 0;
    private boolean stackPointers;

    public CreateDataBackgroundCmd(AddressSetView addrSet, DataType dataType) {
        this(addrSet, dataType, false);
    }

    public CreateDataBackgroundCmd(AddressSetView addrSet, DataType dataType, boolean stackPointers) {
        super("Create " + dataType.getDisplayName() + "(s)", true, true, true);
        this.newDataType = dataType;
        this.addrSet = addrSet;
        this.stackPointers = stackPointers;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        return this.doApplyTo(obj, monitor);
    }

    public boolean doApplyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        Listing listing = program.getListing();
        InstructionIterator iter = listing.getInstructions(this.addrSet, true);
        if (iter.hasNext()) {
            this.setStatusMsg("Can't create data because the current selection contains instructions");
            return false;
        }
        Address addr = this.addrSet.getMinAddress();
        Data data = listing.getDataAt(addr);
        if (data == null) {
            this.setStatusMsg("Can not create Data at address " + addr);
            return false;
        }
        DataType existingDT = data.getDataType();
        this.newDataType = this.newDataType.clone((DataTypeManager)program.getDataTypeManager());
        this.newDataType = DataUtilities.reconcileAppliedDataType((DataType)existingDT, (DataType)this.newDataType, (boolean)this.stackPointers);
        monitor.initialize(this.addrSet.getNumAddresses());
        AddressRangeIterator it = this.addrSet.getAddressRanges();
        while (it.hasNext() && !monitor.isCancelled()) {
            AddressRange range = (AddressRange)it.next();
            try {
                this.createData(range.getMinAddress(), range.getMaxAddress(), this.newDataType, program, monitor);
            }
            catch (Exception e) {
                this.setStatusMsg(e.getMessage());
                if (this.numDataCreated != 0) continue;
                return false;
            }
        }
        if (this.numDataCreated == 0) {
            this.setStatusMsg("Not Enough space to create Data");
            return false;
        }
        return true;
    }

    private void createData(Address start, Address end, DataType dataType, Program p, TaskMonitor monitor) throws CodeUnitInsertionException {
        Address nextAddr = start;
        Listing listing = p.getListing();
        listing.clearCodeUnits(start, end, false);
        int initialProgress = this.bytesApplied;
        int length = (int)end.subtract(nextAddr) + 1;
        while (nextAddr != null && nextAddr.compareTo((Object)end) <= 0) {
            if (monitor.isCancelled()) {
                return;
            }
            Data d = listing.createData(nextAddr, dataType, length);
            int dataLength = d.getLength();
            this.bytesApplied = initialProgress + dataLength;
            try {
                nextAddr = nextAddr.addNoWrap((long)dataLength);
                length -= dataLength;
            }
            catch (AddressOverflowException e) {
                return;
            }
            monitor.setProgress((long)this.bytesApplied);
            if (++this.numDataCreated % 10000 != 0) continue;
            monitor.setMessage("Created " + this.numDataCreated);
            Swing.allowSwingToProcessEvents();
        }
    }
}

