/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.PcodeOpBank;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.program.model.pcode.VarnodeBank;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PcodeSyntaxTree
implements PcodeFactory {
    private AddressFactory addrFactory;
    private PcodeDataTypeManager datatypeManager;
    private HashMap<Integer, Varnode> refmap;
    private HashMap<Integer, PcodeOp> oprefmap;
    private HashMap<Integer, VariableStorage> joinToStorage;
    private HashMap<VariableStorage, Integer> storageToJoin;
    private int joinAllocate;
    private PcodeOpBank opbank;
    private VarnodeBank vbank;
    private ArrayList<PcodeBlockBasic> bblocks;
    private int uniqId;

    public PcodeSyntaxTree(AddressFactory afact, PcodeDataTypeManager dtmanage) {
        this.addrFactory = afact;
        this.datatypeManager = dtmanage;
        this.refmap = null;
        this.oprefmap = null;
        this.joinToStorage = null;
        this.storageToJoin = null;
        this.joinAllocate = 0;
        this.opbank = new PcodeOpBank();
        this.vbank = new VarnodeBank();
        this.bblocks = new ArrayList();
        this.uniqId = 0;
    }

    public void clear() {
        this.refmap = null;
        this.oprefmap = null;
        this.joinToStorage = null;
        this.storageToJoin = null;
        this.joinAllocate = 0;
        this.vbank.clear();
        this.opbank.clear();
        this.bblocks = new ArrayList();
        this.uniqId = 0;
    }

    @Override
    public Address getJoinAddress(VariableStorage storage) {
        if (this.storageToJoin == null) {
            return null;
        }
        Integer off = this.storageToJoin.get(storage);
        if (off == null) {
            return null;
        }
        AddressSpace spc = AddressSpace.VARIABLE_SPACE;
        return spc.getAddress(off.longValue());
    }

    @Override
    public VariableStorage getJoinStorage(Varnode[] pieces) throws InvalidInputException {
        Integer offObject;
        VariableStorage storage;
        try {
            storage = new VariableStorage((ProgramArchitecture)this.datatypeManager.getProgram(), pieces);
        }
        catch (InvalidInputException e) {
            storage = null;
        }
        if (storage == null) {
            int sz = 0;
            for (Varnode piece : pieces) {
                sz += piece.getSize();
            }
            Address uniqaddr = this.addrFactory.getUniqueSpace().getAddress(0x20000000L);
            storage = new VariableStorage((ProgramArchitecture)this.datatypeManager.getProgram(), uniqaddr, sz);
        }
        if (this.joinToStorage == null) {
            this.joinToStorage = new HashMap();
        }
        if (this.storageToJoin == null) {
            this.storageToJoin = new HashMap();
        }
        if ((offObject = this.storageToJoin.get(storage)) != null) {
            return this.joinToStorage.get(offObject);
        }
        int roundsize = storage.size() + 15 & 0xFFFFFFF0;
        offObject = this.joinAllocate;
        this.joinAllocate += roundsize;
        this.joinToStorage.put(offObject, storage);
        this.storageToJoin.put(storage, offObject);
        return storage;
    }

    private VariableStorage findJoinStorage(long offset) {
        if (this.joinToStorage == null) {
            return null;
        }
        return this.joinToStorage.get((int)offset);
    }

    @Override
    public VariableStorage buildStorage(Varnode vn) throws InvalidInputException {
        Address addr = vn.getAddress();
        if (addr.getAddressSpace().getType() == 11) {
            VariableStorage store = this.findJoinStorage(addr.getOffset());
            if (store == null) {
                throw new InvalidInputException("Missing description of pieces for a varnode in the join address space");
            }
            return store;
        }
        return new VariableStorage((ProgramArchitecture)this.datatypeManager.getProgram(), vn);
    }

    public Iterator<VarnodeAST> locRange() {
        return this.vbank.locRange();
    }

    public Iterator<VarnodeAST> getVarnodes(AddressSpace spc) {
        return this.vbank.locRange(spc);
    }

    public Iterator<VarnodeAST> getVarnodes(Address addr) {
        return this.vbank.locRange(addr);
    }

    public Iterator<VarnodeAST> getVarnodes(int sz, Address addr) {
        return this.vbank.locRange(sz, addr);
    }

    public Varnode findVarnode(int sz, Address addr, Address pc) {
        return this.vbank.find(sz, addr, pc, -1);
    }

    public Varnode findVarnode(int sz, Address addr, SequenceNumber sq) {
        return this.vbank.find(sz, addr, sq.getTarget(), sq.getTime());
    }

    public Varnode findInputVarnode(int sz, Address addr) {
        return this.vbank.findInput(sz, addr);
    }

    public int getNumVarnodes() {
        return this.vbank.size();
    }

    public Iterator<PcodeOpAST> getPcodeOps() {
        return this.opbank.allOrdered();
    }

    public Iterator<PcodeOpAST> getPcodeOps(Address addr) {
        return this.opbank.allOrdered(addr);
    }

    public PcodeOp getPcodeOp(SequenceNumber sq) {
        return this.opbank.findOp(sq);
    }

    public ArrayList<PcodeBlockBasic> getBasicBlocks() {
        return this.bblocks;
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addrFactory;
    }

    @Override
    public PcodeDataTypeManager getDataTypeManager() {
        return this.datatypeManager;
    }

    @Override
    public Varnode newVarnode(int sz, Address addr) {
        Varnode vn = this.vbank.create(sz, addr, this.uniqId);
        ++this.uniqId;
        return vn;
    }

    @Override
    public Varnode newVarnode(int sz, Address addr, int id) {
        Varnode vn = this.vbank.create(sz, addr, id);
        if (this.uniqId <= id) {
            this.uniqId = id + 1;
        }
        if (this.refmap != null) {
            this.refmap.put(id, vn);
        }
        return vn;
    }

    @Override
    public Varnode setInput(Varnode vn, boolean val) {
        if (!vn.isInput() && val) {
            return this.vbank.setInput(vn);
        }
        if (vn.isInput() && !val) {
            this.vbank.makeFree(vn);
        }
        return vn;
    }

    private void buildVarnodeRefs() {
        this.refmap = new HashMap((int)(1.5 * (double)this.vbank.size()));
        Iterator<VarnodeAST> iter = this.vbank.locRange();
        while (iter.hasNext()) {
            VarnodeAST vn = iter.next();
            this.refmap.put(vn.getUniqueId(), vn);
        }
    }

    @Override
    public Varnode getRef(int id) {
        if (this.refmap == null) {
            return null;
        }
        return this.refmap.get(id);
    }

    @Override
    public HighSymbol getSymbol(long symbolId) {
        return null;
    }

    @Override
    public void setDataType(Varnode vn, DataType type) {
    }

    @Override
    public void setAddrTied(Varnode vn, boolean val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setAddrtied(val);
    }

    @Override
    public void setPersistent(Varnode vn, boolean val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setPersistent(val);
    }

    @Override
    public void setUnaffected(Varnode vn, boolean val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setUnaffected(val);
    }

    @Override
    public void setVolatile(Varnode vn, boolean val) {
    }

    @Override
    public void setMergeGroup(Varnode vn, short val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setMergeGroup(val);
    }

    private void buildOpRefs() {
        this.oprefmap = new HashMap((int)(1.5 * (double)this.opbank.size()));
        Iterator<PcodeOpAST> iter = this.opbank.allOrdered();
        while (iter.hasNext()) {
            PcodeOp op = iter.next();
            this.oprefmap.put(op.getSeqnum().getTime(), op);
        }
    }

    @Override
    public PcodeOp getOpRef(int id) {
        if (this.oprefmap == null) {
            this.buildOpRefs();
        }
        return this.oprefmap.get(id);
    }

    public void insertBefore(PcodeOp newop, PcodeOp follow) {
        PcodeOpAST newopast = (PcodeOpAST)newop;
        PcodeOpAST followast = (PcodeOpAST)follow;
        PcodeBlockBasic bblock = followast.getParent();
        bblock.insertBefore(followast.getBasicIter(), newopast);
        this.opbank.markAlive(newopast);
    }

    public void insertAfter(PcodeOp newop, PcodeOp prev) {
        PcodeOpAST newopast = (PcodeOpAST)newop;
        PcodeOpAST prevast = (PcodeOpAST)prev;
        PcodeBlockBasic bblock = prevast.getParent();
        bblock.insertAfter(prevast.getBasicIter(), newopast);
        this.opbank.markAlive(newopast);
    }

    public void setOpcode(PcodeOp op, int opc) {
        this.opbank.changeOpcode(op, opc);
    }

    public void setOutput(PcodeOp op, Varnode vn) {
        if (vn == op.getOutput()) {
            return;
        }
        if (op.getOutput() != null) {
            this.unSetOutput(op);
        }
        if (vn.getDef() != null) {
            this.unSetOutput(vn.getDef());
        }
        vn = this.vbank.setDef(vn, op);
        op.setOutput(vn);
    }

    public void unSetOutput(PcodeOp op) {
        Varnode vn = op.getOutput();
        if (vn == null) {
            return;
        }
        op.setOutput(null);
        this.vbank.makeFree(vn);
    }

    public void setInput(PcodeOp op, Varnode vn, int slot) {
        if (slot >= op.getNumInputs()) {
            op.setInput(null, slot);
        }
        if (op.getInput(slot) != null) {
            this.unSetInput(op, slot);
        }
        if (vn != null) {
            VarnodeAST vnast = (VarnodeAST)vn;
            vnast.addDescendant(op);
            op.setInput(vnast, slot);
        }
    }

    public void unSetInput(PcodeOp op, int slot) {
        VarnodeAST vn = (VarnodeAST)op.getInput(slot);
        vn.removeDescendant(op);
        op.setInput(null, slot);
    }

    public void unInsert(PcodeOp op) {
        this.opbank.markDead(op);
        op.getParent().remove(op);
    }

    public void delete(PcodeOp op) {
        this.opbank.destroy(op);
    }

    public void unlink(PcodeOpAST op) {
        this.unSetOutput(op);
        for (int i = 0; i < op.getNumInputs(); ++i) {
            this.unSetInput(op, i);
        }
        if (op.getParent() != null) {
            this.unInsert(op);
        }
    }

    @Override
    public PcodeOp newOp(SequenceNumber sq, int opc, ArrayList<Varnode> inputs, Varnode output) {
        PcodeOp op = this.opbank.create(opc, inputs.size(), sq);
        if (output != null) {
            this.setOutput(op, output);
        }
        for (int i = 0; i < inputs.size(); ++i) {
            this.setInput(op, inputs.get(i), i);
        }
        if (this.oprefmap != null) {
            this.oprefmap.put(sq.getTime(), op);
        }
        return op;
    }

    private void decodeVarnode(Decoder decoder) throws DecoderException {
        int subId;
        int el = decoder.openElement(ElementId.ELEM_VARNODES);
        while ((subId = decoder.peekElement()) != 0) {
            Varnode.decode(decoder, this);
        }
        decoder.closeElement(el);
    }

    private void decodeBasicBlock(Decoder decoder, BlockMap resolver) throws DecoderException {
        int subel;
        int el = decoder.openElement(ElementId.ELEM_BLOCK);
        int order = 0;
        PcodeBlockBasic bl = new PcodeBlockBasic();
        bl.decodeHeader(decoder);
        bl.decodeBody(decoder, resolver);
        while ((subel = decoder.peekElement()) != 0) {
            PcodeOp op = PcodeOp.decode(decoder, this);
            op.setOrder(order);
            ++order;
            bl.insertEnd(op);
        }
        int index = bl.getIndex();
        while (this.bblocks.size() <= index) {
            this.bblocks.add(null);
        }
        this.bblocks.set(index, bl);
        decoder.closeElement(el);
    }

    private void decodeBlockEdge(Decoder decoder) throws DecoderException {
        int subel;
        int el = decoder.openElement(ElementId.ELEM_BLOCKEDGE);
        int blockInd = (int)decoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
        PcodeBlockBasic curBlock = this.bblocks.get(blockInd);
        while ((subel = decoder.peekElement()) != 0) {
            curBlock.decodeNextInEdge(decoder, this.bblocks);
        }
        decoder.closeElement(el);
    }

    public void decode(Decoder decoder) throws DecoderException {
        int subel;
        int el = decoder.openElement(ElementId.ELEM_AST);
        if (!this.vbank.isEmpty()) {
            this.clear();
        }
        this.decodeVarnode(decoder);
        this.buildVarnodeRefs();
        BlockMap blockMap = new BlockMap(this.addrFactory);
        while ((subel = decoder.peekElement()) != 0) {
            if (subel == ElementId.ELEM_BLOCK.id()) {
                this.decodeBasicBlock(decoder, blockMap);
                continue;
            }
            this.decodeBlockEdge(decoder);
        }
        decoder.closeElement(el);
    }
}

