/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;

public final class LanguageCompilerSpecPair
implements Comparable<LanguageCompilerSpecPair> {
    public final LanguageID languageID;
    public final CompilerSpecID compilerSpecID;

    public LanguageCompilerSpecPair(String languageID, String compilerSpecID) {
        if (languageID == null) {
            throw new IllegalArgumentException("languageID == null not allowed");
        }
        if (compilerSpecID == null) {
            throw new IllegalArgumentException("compilerSpecID == null not allowed");
        }
        if ("".equals(languageID)) {
            throw new IllegalArgumentException("empty languageID not allowed");
        }
        if ("".equals(compilerSpecID)) {
            throw new IllegalArgumentException("empty compilerSpecID not allowed");
        }
        this.languageID = new LanguageID(languageID);
        this.compilerSpecID = new CompilerSpecID(compilerSpecID);
    }

    public LanguageCompilerSpecPair(LanguageID languageID, CompilerSpecID compilerSpecID) {
        if (languageID == null) {
            throw new IllegalArgumentException("languageID == null not allowed");
        }
        if (compilerSpecID == null) {
            throw new IllegalArgumentException("compilerSpecID == null not allowed");
        }
        this.languageID = languageID;
        this.compilerSpecID = compilerSpecID;
    }

    public LanguageID getLanguageID() {
        return this.languageID;
    }

    public CompilerSpecID getCompilerSpecID() {
        return this.compilerSpecID;
    }

    public Language getLanguage() throws LanguageNotFoundException {
        return DefaultLanguageService.getLanguageService().getLanguage(this.languageID);
    }

    public CompilerSpec getCompilerSpec() throws CompilerSpecNotFoundException, LanguageNotFoundException {
        return this.getLanguage().getCompilerSpecByID(this.compilerSpecID);
    }

    public Language getLanguage(LanguageService languageService) throws LanguageNotFoundException {
        return languageService.getLanguage(this.languageID);
    }

    public CompilerSpec getCompilerSpec(LanguageService languageService) throws CompilerSpecNotFoundException, LanguageNotFoundException {
        return this.getLanguage(languageService).getCompilerSpecByID(this.compilerSpecID);
    }

    public LanguageDescription getLanguageDescription() throws LanguageNotFoundException {
        return DefaultLanguageService.getLanguageService().getLanguageDescription(this.languageID);
    }

    public CompilerSpecDescription getCompilerSpecDescription() throws LanguageNotFoundException, CompilerSpecNotFoundException {
        return this.getLanguageDescription().getCompilerSpecDescriptionByID(this.compilerSpecID);
    }

    public LanguageDescription getLanguageDescription(LanguageService languageService) throws LanguageNotFoundException {
        return languageService.getLanguageDescription(this.languageID);
    }

    public CompilerSpecDescription getCompilerSpecDescription(LanguageService languageService) throws LanguageNotFoundException, CompilerSpecNotFoundException {
        return this.getLanguageDescription(languageService).getCompilerSpecDescriptionByID(this.compilerSpecID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compilerSpecID == null ? 0 : this.compilerSpecID.hashCode());
        result = 31 * result + (this.languageID == null ? 0 : this.languageID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LanguageCompilerSpecPair)) {
            return false;
        }
        LanguageCompilerSpecPair other = (LanguageCompilerSpecPair)obj;
        if (this.compilerSpecID == null ? other.compilerSpecID != null : !this.compilerSpecID.equals(other.compilerSpecID)) {
            return false;
        }
        return !(this.languageID == null ? other.languageID != null : !this.languageID.equals(other.languageID));
    }

    public String toString() {
        return this.languageID + ":" + this.compilerSpecID;
    }

    @Override
    public int compareTo(LanguageCompilerSpecPair o) {
        int result = this.languageID.compareTo(o.languageID);
        if (result == 0) {
            result = this.compilerSpecID.compareTo(o.compilerSpecID);
        }
        return result;
    }
}

