/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.util.Msg;

public abstract class RepeatCountDataType
extends DynamicDataType {
    private DataType repeatDataType;

    protected RepeatCountDataType(DataType repeatDataType, CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
        this.repeatDataType = repeatDataType;
    }

    @Override
    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        try {
            int countSize;
            int n = (buf.getByte(0) & 0xFF) * 16 + (buf.getByte(1) & 0xFF) + 1;
            DataTypeComponent[] comps = new DataTypeComponent[n];
            comps[0] = new ReadOnlyDataTypeComponent(new WordDataType(), this, 2, 0, 0, "Size", "");
            int offset = countSize = comps[0].getLength();
            MemoryBufferImpl newBuf = new MemoryBufferImpl(buf.getMemory(), buf.getAddress());
            newBuf.advance(countSize);
            for (int i = 1; i < n; ++i) {
                DataTypeInstance dti = DataTypeInstance.getDataTypeInstance(this.repeatDataType, newBuf, false);
                if (dti == null) {
                    Msg.error((Object)this, (Object)("ERROR: problem with data at " + newBuf.getAddress()));
                    return null;
                }
                int len = dti.getLength();
                comps[i] = new ReadOnlyDataTypeComponent(dti.getDataType(), this, len, i, offset);
                offset += len;
                newBuf.advance(len);
            }
            return comps;
        }
        catch (AddressOutOfBoundsException | AddressOverflowException | MemoryAccessException e) {
            Msg.error((Object)this, (Object)("ERROR: problem with data at " + buf.getAddress()));
            return null;
        }
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }
}

