/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import java.util.Comparator;

public interface CompositeInternal
extends Composite {
    public static final String ALIGN_NAME = "aligned";
    public static final String PACKING_NAME = "pack";
    public static final String DISABLED_PACKING_NAME = "disabled";
    public static final String DEFAULT_PACKING_NAME = "";
    public static final int DEFAULT_PACKING = 0;
    public static final int NO_PACKING = -1;
    public static final int DEFAULT_ALIGNMENT = 0;
    public static final int MACHINE_ALIGNMENT = -1;

    public int getStoredPackingValue();

    public int getStoredMinimumAlignment();

    public static String toString(Composite composite) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(composite.getPathName() + "\n");
        stringBuffer.append(CompositeInternal.getAlignmentAndPackingString(composite) + "\n");
        stringBuffer.append(CompositeInternal.getTypeName(composite) + " " + composite.getDisplayName() + " {\n");
        CompositeInternal.dumpComponents(composite, stringBuffer, "   ");
        stringBuffer.append("}\n");
        stringBuffer.append("Size = " + composite.getLength() + "   Actual Alignment = " + composite.getAlignment() + "\n");
        return stringBuffer.toString();
    }

    private static void dumpComponents(Composite composite, StringBuilder buffer, String pad) {
        DataTypeComponent[] components;
        for (DataTypeComponent dtc : components = composite.getDefinedComponents()) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dtc.getOffset());
            buffer.append(pad + dataType.getName());
            if (dataType instanceof BitFieldDataType) {
                BitFieldDataType bfDt = (BitFieldDataType)dataType;
                buffer.append("(");
                buffer.append(Integer.toString(bfDt.getBitOffset()));
                buffer.append(")");
            }
            buffer.append(pad + dtc.getLength());
            String name = dtc.getFieldName();
            if (name == null) {
                name = DEFAULT_PACKING_NAME;
            }
            buffer.append(pad + name);
            String comment = dtc.getComment();
            if (comment == null) {
                comment = DEFAULT_PACKING_NAME;
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }

    private static String getTypeName(Composite composite) {
        if (composite instanceof Structure) {
            return "Structure";
        }
        if (composite instanceof Union) {
            return "Union";
        }
        return DEFAULT_PACKING_NAME;
    }

    public static String getAlignmentAndPackingString(Composite composite) {
        StringBuilder buf = new StringBuilder(CompositeInternal.getMinAlignmentString(composite));
        if (buf.length() != 0) {
            buf.append(" ");
        }
        buf.append(CompositeInternal.getPackingString(composite));
        return buf.toString();
    }

    public static String getMinAlignmentString(Composite composite) {
        if (composite.isDefaultAligned()) {
            return DEFAULT_PACKING_NAME;
        }
        StringBuilder buf = new StringBuilder(ALIGN_NAME);
        buf.append("(");
        if (composite.isMachineAligned()) {
            buf.append("machine:");
            buf.append(composite.getDataOrganization().getMachineAlignment());
        } else {
            buf.append(composite.getExplicitMinimumAlignment());
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getPackingString(Composite composite) {
        StringBuilder buf = new StringBuilder(PACKING_NAME);
        buf.append("(");
        if (composite.isPackingEnabled()) {
            if (composite.hasExplicitPackingValue()) {
                buf.append(composite.getExplicitPackingValue());
            } else {
                buf.append(DEFAULT_PACKING_NAME);
            }
        } else {
            buf.append(DISABLED_PACKING_NAME);
        }
        buf.append(")");
        return buf.toString();
    }

    public static class OrdinalComparator
    implements Comparator<Object> {
        public static final OrdinalComparator INSTANCE = new OrdinalComparator();

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int ordinal = (Integer)o2;
            return dtc.getOrdinal() - ordinal;
        }
    }

    public static class OffsetComparator
    implements Comparator<Object> {
        public static final OffsetComparator INSTANCE = new OffsetComparator();

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int offset = (Integer)o2;
            if (offset < dtc.getOffset()) {
                return 1;
            }
            if (offset > dtc.getEndOffset()) {
                return -1;
            }
            return 0;
        }
    }

    public static class ComponentComparator
    implements Comparator<DataTypeComponent> {
        public static final ComponentComparator INSTANCE = new ComponentComparator();

        @Override
        public int compare(DataTypeComponent dtc1, DataTypeComponent dtc2) {
            return dtc1.getOrdinal() - dtc2.getOrdinal();
        }
    }
}

