/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.AbstractAddressSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.GenericAddress;

public class GenericAddressSpace
extends AbstractAddressSpace {
    public GenericAddressSpace(String name, int size, int type, int unique) {
        this(name, size, 1, type, unique);
    }

    public GenericAddressSpace(String name, int size, int type, int unique, boolean showSpaceName) {
        this(name, size, 1, type, unique);
        this.setShowSpaceName(showSpaceName);
    }

    public GenericAddressSpace(String name, int size, int unitSize, int type, int unique) {
        super(name, size, unitSize, type, unique);
    }

    @Override
    public Address getAddress(long offset) throws AddressOutOfBoundsException {
        return new GenericAddress(this, offset);
    }

    @Override
    public Address getAddressInThisSpaceOnly(long offset) {
        return new GenericAddress(this, offset);
    }

    @Override
    protected Address getUncheckedAddress(long offset) {
        return new GenericAddress(offset, this);
    }
}

