/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import ghidra.program.database.function.FunctionDB;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.StackVariableComparator;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;

class FunctionStackFrame
implements StackFrame {
    private Variable[] variables;
    private FunctionDB function;
    private boolean stackGrowsNegative;
    private boolean invalid;

    FunctionStackFrame(FunctionDB function) {
        this.function = function;
        this.stackGrowsNegative = function.getProgram().getCompilerSpec().stackGrowsNegative();
        this.invalid = true;
    }

    boolean checkIsValid() {
        if (this.function.isDeleted()) {
            return false;
        }
        if (this.invalid) {
            this.stackGrowsNegative = this.function.getFunctionManager().getProgram().getCompilerSpec().stackGrowsNegative();
            this.variables = this.function.getVariables(VariableFilter.COMPOUND_STACK_VARIABLE_FILTER);
            Arrays.sort(this.variables, StackVariableComparator.get());
            this.invalid = false;
        }
        return true;
    }

    void checkDeleted() {
        if (!this.checkIsValid()) {
            throw new ConcurrentModificationException("Object has been deleted.");
        }
    }

    void setInvalid() {
        this.invalid = true;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable createVariable(String name, int offset, DataType dataType, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.function.manager.lock.acquire();
        try {
            this.checkDeleted();
            if (dataType != null) {
                dataType = dataType.clone(this.function.getProgram().getDataTypeManager());
            }
            Variable var = new LocalVariableImpl(name, dataType, offset, this.function.getProgram());
            if (this.isParameterOffset(offset)) {
                int ordinal = this.function.getParameterCount();
                Parameter[] params = this.getParameters();
                if (this.stackGrowsNegative) {
                    for (int i = params.length - 1; i >= 0; --i) {
                        if ((long)offset > params[i].getLastStorageVarnode().getOffset()) continue;
                        ordinal = params[i].getOrdinal();
                    }
                } else {
                    for (Parameter param : params) {
                        if ((long)offset < param.getLastStorageVarnode().getOffset()) continue;
                        ordinal = param.getOrdinal();
                    }
                }
                var = this.function.insertParameter(ordinal, var, source);
            } else {
                var = this.function.addLocalVariable(var, source);
            }
            if (!(!(var instanceof Parameter) || this.function.hasCustomVariableStorage() || var.isStackVariable() && var.getStackOffset() == offset)) {
                this.function.setCustomVariableStorage(true);
                VariableStorage storage = new VariableStorage((ProgramArchitecture)this.function.getProgram(), offset, var.getLength());
                var.setDataType(var.getDataType(), storage, true, source);
            }
            Variable variable = var;
            return variable;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    @Override
    public Variable[] getStackVariables() {
        this.function.manager.lock.acquire();
        try {
            this.checkIsValid();
            Variable[] temp = new Variable[this.variables.length];
            System.arraycopy(this.variables, 0, temp, 0, this.variables.length);
            Variable[] variableArray = temp;
            return variableArray;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getLocals() {
        this.function.manager.lock.acquire();
        try {
            this.checkIsValid();
            ArrayList<Variable> list = new ArrayList<Variable>();
            for (Variable variable : this.variables) {
                if (variable instanceof Parameter) continue;
                list.add(variable);
            }
            Variable[] vars = new Variable[list.size()];
            Variable[] variableArray = list.toArray(vars);
            return variableArray;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter[] getParameters() {
        this.function.manager.lock.acquire();
        try {
            this.checkIsValid();
            ArrayList<Parameter> list = new ArrayList<Parameter>();
            for (Variable variable : this.variables) {
                if (!(variable instanceof Parameter)) continue;
                list.add((Parameter)variable);
            }
            Parameter[] vars = new Parameter[list.size()];
            Parameter[] parameterArray = list.toArray(vars);
            return parameterArray;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    @Override
    public int getFrameSize() {
        this.function.manager.lock.acquire();
        try {
            int n = this.getParameterSize() + this.getLocalSize();
            return n;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalSize() {
        this.function.manager.lock.acquire();
        try {
            this.checkIsValid();
            int baseOffset = 0;
            Integer base = VariableUtilities.getBaseStackParamOffset(this.function);
            if (base != null) {
                baseOffset = (int)base.longValue();
            }
            if (this.stackGrowsNegative) {
                if (this.variables.length != 0 && !(this.variables[0] instanceof Parameter)) {
                    int offset = (int)this.variables[0].getLastStorageVarnode().getOffset();
                    if (offset > 0) {
                        offset = 0;
                    }
                    int n = baseOffset - offset;
                    return n;
                }
                int offset = baseOffset;
                return offset;
            }
            int index = this.variables.length - 1;
            if (index < 0) {
                int n = -baseOffset;
                return n;
            }
            if (!(this.variables[index] instanceof Parameter)) {
                Varnode stackVarnode = this.variables[index].getLastStorageVarnode();
                int len = stackVarnode.getSize();
                int offset = (int)stackVarnode.getOffset();
                if (offset < 0) {
                    offset = 0;
                }
                int n = offset - baseOffset + len;
                return n;
            }
            int n = -baseOffset;
            return n;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    @Override
    public boolean growsNegative() {
        return this.stackGrowsNegative;
    }

    @Override
    public void setLocalSize(int size) {
        this.function.setLocalSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getParameterSize() {
        this.function.manager.lock.acquire();
        try {
            this.checkIsValid();
            int baseOffset = 0;
            Integer base = VariableUtilities.getBaseStackParamOffset(this.function);
            if (base != null) {
                baseOffset = (int)base.longValue();
            }
            if (this.stackGrowsNegative) {
                int index = this.variables.length - 1;
                if (index < 0) {
                    int n = 0;
                    return n;
                }
                if (this.variables[index] instanceof Parameter) {
                    Varnode stackVarnode = this.variables[index].getLastStorageVarnode();
                    int len = stackVarnode.getSize();
                    int stackOffset = (int)stackVarnode.getOffset();
                    int n = stackOffset - baseOffset + len;
                    return n;
                }
                int n = 0;
                return n;
            }
            if (this.variables.length != 0 && this.variables[0] instanceof Parameter) {
                int stackOffset = (int)this.variables[0].getLastStorageVarnode().getOffset();
                int n = baseOffset - stackOffset;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParameterCount() {
        this.function.manager.lock.acquire();
        try {
            this.checkIsValid();
            int cnt = 0;
            for (Variable variable : this.variables) {
                if (!(variable instanceof Parameter)) continue;
                ++cnt;
            }
            int n = cnt;
            return n;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    @Override
    public void clearVariable(int offset) {
        this.function.manager.lock.acquire();
        try {
            this.checkDeleted();
            Variable var = this.getVariableContaining(offset);
            if (var != null) {
                if (!this.function.hasCustomVariableStorage()) {
                    this.function.setCustomVariableStorage(true);
                }
                this.function.removeVariable(var);
            }
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    @Override
    public int getParameterOffset() {
        Integer baseOffset = VariableUtilities.getBaseStackParamOffset(this.function);
        return baseOffset != null ? (int)baseOffset.longValue() : 131072;
    }

    @Override
    public int getReturnAddressOffset() {
        return this.function.getReturnAddressOffset();
    }

    @Override
    public void setReturnAddressOffset(int offset) {
        this.function.setReturnAddressOffset(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable getVariableContaining(int offset) {
        this.function.manager.lock.acquire();
        try {
            this.checkIsValid();
            Integer key = offset;
            int index = Arrays.binarySearch(this.variables, key, StackVariableComparator.get());
            if (index >= 0) {
                Variable variable = this.variables[index];
                return variable;
            }
            index = -index - 1;
            if (--index < 0) {
                Variable variable = null;
                return variable;
            }
            Variable var = this.variables[index];
            Varnode stackVarnode = var.getLastStorageVarnode();
            int stackOffset = (int)stackVarnode.getOffset();
            if (stackOffset + stackVarnode.getSize() > offset) {
                Variable variable = var;
                return variable;
            }
            Variable variable = null;
            return variable;
        }
        finally {
            this.function.manager.lock.release();
        }
    }

    @Override
    public boolean isParameterOffset(int offset) {
        Integer baseOffset = VariableUtilities.getBaseStackParamOffset(this.function);
        if (baseOffset == null) {
            return false;
        }
        return this.stackGrowsNegative && offset >= baseOffset || !this.stackGrowsNegative && offset < baseOffset;
    }

    public boolean equals(Object obj) {
        this.checkIsValid();
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionStackFrame otherFrame = (FunctionStackFrame)obj;
        if (this.getLocalSize() != otherFrame.getLocalSize() || this.getParameterOffset() != otherFrame.getParameterOffset() || this.getReturnAddressOffset() != otherFrame.getReturnAddressOffset() || this.variables.length != otherFrame.variables.length) {
            return false;
        }
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].equals(otherFrame.variables[i])) continue;
            return false;
        }
        return true;
    }
}

